/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#ifndef _UTIL_H_
#define _UTIL_H_

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <time.h>
#include <limits.h>
#include <errno.h>
#include <assert.h>
#include <unistd.h>
#include <glob.h>
#include <sys/stat.h>
#include <sys/mman.h>
#include <sys/time.h>

extern FILE *g_stderr;
extern FILE *g_stdout;

void trace(char*, ...);
void warns(char*, ...);

#define warnif(exp, s) { \
	if (exp) {  \
		warns("%s: `%s` [%s:%d]\n", s, #exp, __FILE__, __LINE__); \
		return 0; \
	}\
}
#define errif(exp, s) { \
	if (exp) {  \
		warns("%s: `%s` [%s:%d]\n", s, #exp, __FILE__, __LINE__); \
		return -1; \
	}\
}

char* tmpbuf();
int   sputsn(char*, char*, int);
int   sputs(char*, char*);
char* strndupok(char*, int);
int   strnncmp(char*, int, char*, int);
int   strrnncmp(char*, int, char*, int);
int   strnncasecmp(char*, int, char*, int);
int   strrnncasecmp(char*, int, char*, int);
int   strtoh(char*, int);
int   strtonum(char*, int, double*, int*);
int   isoctal(int);
int   iscrlf(int);
int   xtoi(int);
int   itoX(int);
int   ischar(int, char*);
int   metac(int*, int);
int   unmetac(char**, int);
int   vmclose(char*, int, FILE*);
char* vmopen(char*, int*, FILE**);

/************************************************************
 *
 ************************************************************/
typedef struct {
	FILE* fp;
	char *sp;
	int len;
} stream_t;

int stream_putc(stream_t* st, int c);
int stream_write(stream_t* st, char *s, int n);
int stream_flush(stream_t* st);

#endif /* _UTIL_H_ */
