/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#ifndef _OP_H_
#define _OP_H_

typedef enum {
C_void      = 0x01,
C_addA      = 0x02,
C_subA      = 0x03,
C_mulA      = 0x04,
C_divA      = 0x05,
C_modA      = 0x06,
C_powA      = 0x07,
C_bitandA   = 0x08,
C_bitorA    = 0x09,
C_bitsubA   = 0x0A,
C_bitxorA   = 0x0B,
C_bitshLA   = 0x0C,
C_bitshRA   = 0x0D,
C_andA      = 0x0E,
C_orA       = 0x0F,
C_inc       = 0x10,
C_dec       = 0x11,
C_echo      = 0x12,
C_doc       = 0x13,
C_crlf      = 0x14,
C_if        = 0x15,
C_else      = 0x16,
C_for       = 0x17,
C_while     = 0x18,
C_do        = 0x19,
C_foreach   = 0x1A,
C_switch    = 0x1B,
C_default   = 0x1C,
C_try       = 0x1D,
C_break     = 0x1E,
C_continue  = 0x1F,
C_in        = 0x20,
C_not       = '!',
C_string    = '"',
C_sharp     = '#',
C_case      = '$',
C_mod       = '%',
C_bitand    = '&',
C_char      = '\'',
C_paL       = '(',
C_paR       = ')',
C_mul       = '*',
C_add       = '+',
C_comma     = ',',
C_sub       = '-',
C_join      = '.',
C_div       = '/',
C_catch     = '0',
C_throw     = '1',
C_return    = '2',
C_exit      = '3',
C_goto      = '4',
C_Minclude  = '5',
C_Mdefine   = '6',
C_var       = '7',
C_label     = '8',
C_function  = '9',
C_colon     = ':',
C_semic     = ';',
C_lt        = '<',
C_store     = '=',
C_gt        = '>',
C_que       = '?',
C_class     = '@',
C_file      = 'A',
C_line      = 'B',
C_names     = 'C',
C_stdin     = 'D',
C_stdout    = 'E',
C_stderr    = 'F',
C_tmpout    = 'G',
C_tmperr    = 'H',
C_frameIn   = 'I',
C_frameOut  = 'J',
C_jump      = 'K',
C_load      = 'L',
C_copy      = 'M',
C_sand      = 'N',
C_pop       = 'O',
C_call      = 'P',
C_args      = 'Q',
C_array     = 'R',
C_object    = 'S',
C_loop      = 'T',
C_plus      = 'U',
C_minus     = 'V',
C_bitnot    = 'W',
C_toBool    = 'X',
C_toChar    = 'Y',
C_toInt     = 'Z',
C_sqL       = '[',
C_toFloat   = '\\',
C_sqR       = ']',
C_bitxor    = '^',
C_toString  = '_',
C_regex     = '`',
C_toNumber  = 'a',
C_typeof    = 'b',
C_delete    = 'c',
C_new       = 'd',
C_null      = 'e',
C_true      = 'f',
C_false     = 'g',
C_this      = 'h',
C_symbol    = 'i',
C_int       = 'j',
C_float     = 'k',
C_match     = 'l',
C_notmatch  = 'm',
C_and       = 'n',
C_or        = 'o',
C_eq        = 'p',
C_ne        = 'q',
C_cmp       = 'r',
C_bitshL    = 's',
C_bitshR    = 't',
C_pow       = 'u',
C_cuL       = '{',
C_bitor     = '|',
C_cuR       = '}',
C_bitsub    = '~',
} op_t;


#endif /* _OP_H_ */
