/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#include "util.h"
#include "var.h"
#include "_sym.h"
#include "_ext.h"

static int urldecode(char *s, int n)
{
	char *e, *d;
	int c;
	d = s;
	e = s + n;
	n = 0;
	while ((s < e) && ((c = *s++) != 0)) {
		if (c == '%') {
			if (isxdigit(*s)) {
				c = xtoi(*s++);
				if (isxdigit(*s)) {
					c = (c << 4) | xtoi(*s++);
				}
			}
		} else if (c == '+') {
			c = ' ';
		}
		d[n++] = c;
	}
	d[n] = 0;
	return n;
}

static int getmimeattr(char *s, int n, char *qs, char **vs, int *vn)
{
	char *div = ":=;,";
	char *e, *ks;
	int kn, qn;
	ks = NULL;
	qn = strlen(qs);
	e = s + n;
	while ((s < e) && (isspace(*s) || strchr(div, *s))) s++;
	while (s < e) {
		if (*s == '"') {
			*vs = ++s;
			while ((s < e) && (*s != '"')) s++;
			*vn = s - *vs;
			if (*s == '"') s++;
		} else {
			*vs = s;
			while ((s < e) && !isspace(*s) && !strchr(div, *s)) s++;
			*vn = s - *vs;
		}
		while ((s < e) && isspace(*s)) s++;
		if ((*s == ':') || (*s == '=')) {
			ks = *vs;
			kn = *vn;
		} else {
			if (ks && (kn == qn) && !strncmp(ks, qs, qn)) {
				return 1;
			}
			ks = NULL;
		}
		while ((s < e) && (isspace(*s) || strchr(div, *s))) s++;
	}
	*vs = NULL;
	*vn = 0;
	return 0;
}

static int store_var(exec_t* ex, var_t* top,
	char *ks, int kn, var_t* val)
{
	var_t ref, ref2, pos, pos2;
	char *next, *eon, *eok;
	
	eok = ks + kn;
	pos2.p = NULL;
	
	if (top->p == symbol_proto) {
		if (!object_get(ex, ex->gp, kn = top->u.i, top)) {
			new_object(ex, top, 0);
			object_set(ex, ex->gp, kn, top);
		}
	}
	copy_var(&ref, top);
	
	while (ks < eok) {
		next = memchr(ks, '.', eok - ks);
		if ((next <= ks) || ((next + 1) >= eok)) next = eok;
		kn = strtol(ks, &eon, 0);
		if (eon == next) {
			new_int(&pos, kn);
		} else {
			new_symbol(&pos, string_to_symbol(ex, ks, next - ks));
		}
		if (pos2.p) {
			if (!var_getItem(ex, &ref, &pos2, &ref2)) {
				if (pos.p == symbol_proto) {
					new_object(ex, &ref2, 0);
				} else {
					new_array(ex, &ref2, 0);
				}
				if (!var_setItem(ex, &ref, &pos2, &ref2)) {
					break;
				}
			}
			copy_var(&ref, &ref2);
		}
		if (next >= eok) {
			return var_setItem(ex, &ref, &pos, val);
		}
		copy_var(&pos2, &pos);
		ks = ++next;
	}
	
	return 0;
}

static int filedata_to_var(exec_t* ex, var_t* v, char *s, int n)
{
	static char buf[FILENAME_MAX];
	struct stat st;
	int i, len;
	FILE* fp;
	i = 0;
	do {
		len = sprintf(buf, "%s/%04x", P_tmpdir, i++);
	} while ((stat(buf, &st) == 0) && (i < 0xffff));
	assert(errno == ENOENT);
	errno = 0;
	fp = fopen(buf, "w+");
	fwrite(s, 1, n, fp);
	fclose(fp);
	return new_string_copy(ex, v, buf, len);
}

static int store_file(exec_t* ex, var_t* top,
	char *ks, int kn,
	char *ts, int tn,
	char *fs, int fn,
	char *vs, int vn)
{
	var_t val, tmp;
	if (!ts || (tn <= 0)) {
		tn = strlen(ts = "text/plain");
	}
	if (!fs || (fn <= 0)
	 || !vn || (vn <= 0)) {
		new_null(&val);
	} else {
		
		new_object(ex, &val, 0);
		new_string_copy(ex, &tmp, ts, tn);
		object_set(ex, val.u.p, chars_to_symbol(ex, "type"), &tmp);
		new_string_copy(ex, &tmp, fs, fn);
		object_set(ex, val.u.p, chars_to_symbol(ex, "name"), &tmp);
		filedata_to_var(ex, &tmp, vs, vn);
		object_set(ex, val.u.p, chars_to_symbol(ex, "file"), &tmp);
	}
	return store_var(ex, top, ks, kn, &val);
}

static int store_string(exec_t* ex, var_t* top,
	char *ks, int kn, char *vs, int vn)
{
	var_t val;
	if (!vs || (vn <= 0)) {
		new_null(&val);
	} else {
		vn = jtrim(&vs, vs, vn);
		new_string_with(ex, &val, vs, vn);
	}
	return store_var(ex, top, ks, kn, &val);
}

static int parse_urlencoded(exec_t* ex, var_t* top, char *s, int n, char div)
{
	char *e, *ks, *vs;
	int kn, vn, count = 0;
	e = s + n;
	n = 0;
	while ((s < e) && ((vs = memchr(ks = s, '=', e - s)) != NULL)) {
		kn = vs++ - ks;
		if ((s = memchr(vs, div, e - vs)) != NULL) {
			vn = s++ - vs;
			while (isspace(*s)) s++;
		} else {
			vn = (s = e) - vs;
		}
		kn = urldecode(ks, kn);
		if (kn) {
			vn = urldecode(vs, vn);
			count += store_string(ex, top, ks, kn, vs, vn);
		}
	}
	return count;
}

static int parse_multipart(exec_t* ex, var_t* top,
	char *s, int n, char *div, int divLen)
{
	char *e, *ks, *fs, *ts, *vs;
	int kn, fn, tn, vn, count = 0;
	ks = fs = ts = NULL;
	kn = fn = tn = 0;
	vs = s;
	e = s + n;
	n = 0;
	while ((s < e) && ((s = memchr(s, '-', e - s)) != NULL)) {
		vn = s++ - vs;
		if ((*s != '-') || strncmp(++s, div, divLen)) continue;
		s += divLen;
		if (ks && kn) {
			if (fs) {
				count += store_file(ex, top, ks, kn, fs, fn, ts, tn, vs, vn);
			} else {
				count += store_string(ex, top, ks, kn, vs, vn);
			}
		}
		if (*s == '-') {
			break;
		}
		while (isspace(*s)) s++;
		ks = fs = ts = NULL;
		kn = fn = tn = 0;
		vs = s;
		for (; *s; s++) {
			vn = s - vs;
			if (!iscrlf(*s)) continue;
			if (*(s + 1) == (*s ^ 7)) s++;
			if (isspace(*(++s)) && !iscrlf(*s)) continue;
			n = strcspn(vs, ": \t\v\f\r\n");
			if (!strncasecmp(vs, "content-disposition", n)) {
				getmimeattr(vs, vn, "name", &ks, &kn);
				getmimeattr(vs, vn, "filename", &fs, &fn);
			} else if (!strncasecmp(vs, "content-type", n)) {
				ts = vs + n + strspn(vs + n, ": \t\v\f");
				tn = strcspn(ts, "; \t\v\f\r\n");
			}
			if (iscrlf(*s)) break;
			vs = s;
		}
		while (isspace(*s)) s++;
		vs = s;
	}
	return count;
}

static int parse_environ(exec_t* ex, var_t *top)
{
	extern char **environ;
	char *ks, *vs;
	int i, kn, count = 0;
	for (i = 0; (ks = environ[i]) != NULL; i++) {
		assert((vs = strchr(ks, '=')) != NULL);
		kn = vs++ - ks;
		while ((kn > 0) && isspace(ks[kn - 1])) kn--;
		while (isspace(*vs)) vs++;
		count += store_string(ex, top, ks, kn, vs, strlen(vs));
	}
	return count;
}

int setupcgi(exec_t* ex, FILE* in)
{
	var_t v;
	char *s, *s2;
	int n, n2, count = 0;
	
	new_symbol(&v, chars_to_symbol(ex, "_ENV"));
	count += parse_environ(ex, &v);
	
	if ((s = getenv("HTTP_COOKIE")) != NULL) {
		new_symbol(&v, chars_to_symbol(ex, "_COOKIE"));
		n = strlen(s = strdup(s));
		count += parse_urlencoded(ex, &v, s, n, ';');
		free(s);
	}
	
	if ((s = getenv("QUERY_STRING")) != NULL) {
		new_symbol(&v, chars_to_symbol(ex, "_GET"));
		n = strlen(s = strdup(s));
		count += parse_urlencoded(ex, &v, s, n, '&');
		free(s);
	}
	
	if (((s = getenv("CONTENT_LENGTH")) != NULL)
	&& ((n = atoi(s)) > 0)) {
		s = calloc(n + 1, 1);
		fread(s, 1, n, in);
		new_symbol(&v, chars_to_symbol(ex, "_POST"));
		assert((s2 = getenv("CONTENT_TYPE")) != NULL);
		if (getmimeattr(s2, strlen(s2), "boundary", &s2, &n2)) {
			count += parse_multipart(ex, &v, s, n, s2, n2);
		} else {
			count += parse_urlencoded(ex, &v, s, n, '&');
		}
		free(s);
	}
	
	return count;
}

int flushcgi(exec_t* ex, FILE* out)
{
	char buf[BUFSIZ + 1];
	char *type;
	int n;
	
	rewind(ex->hh);
	
	type = "text/html; charset=utf-8";
	while (fgets(buf, BUFSIZ, ex->hh)) {
		fputs(buf, out);
		if (type
		&& !strncasecmp("content-type", buf, strcspn(buf, ": \t\v\f\r\n"))) {
			type = NULL;
		}
	}
	if (type) {
		fprintf(out, "Content-Type: %s\n", type);
	}
	fputc('\n', out);
	
	rewind(ex->out);
	while ((n = fread(buf, 1, BUFSIZ, ex->out)) > 0) {
		fwrite(buf, 1, n, out);
	}
	
	return 1;
}
