/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#include "util.h"
#include "var.h"
#include "_sym.h"
#include "_ext.h"

/************************************************************
 *
 ************************************************************/
void* object_alloc(exec_t* ex)
{
	return alloc_link(ex, sizeof(object_t), object_proto);
}
void object_free(exec_t* ex, void *v)
{
	free_link(ex, v);
}

/************************************************************
 *
 ************************************************************/
int object_get(exec_t* ex, object_t* obj, int k, var_t* v)
{
	int i;
	for (i = 0; i < obj->n; i++) {
		if (obj->e[i].k == k) {
			break;
		}
	}
	if (i >= obj->n) {
		new_null(v);
		return 0;
	}
	copy_var(v, &obj->e[i].v);
	return 1;
}
int object_del(exec_t* ex, object_t* obj, int k, var_t* v)
{
	int i;
	for (i = 0; i < obj->n; i++) {
		if (obj->e[i].k == k) {
			break;
		}
	}
	if (i >= obj->n) {
		if (v) new_null(v);
		return 0;
	}
	unlock_var(ex, &obj->e[i].v);
	if (v) {
		copy_var(v, &obj->e[i].v);
	} else {
		delete_var(ex, &obj->e[i].v);
	}
	if (--obj->n > i) {
		memmove(obj->e + i, obj->e + i + 1, (obj->n - i) * sizeof(each_t));
	}
	return 1;
}
int object_set(exec_t* ex, object_t* obj, int k, var_t* v)
{
	int i;
	for (i = 0; i < obj->n; i++) {
		if (obj->e[i].k == k) {
			break;
		}
	}
	if (i >= obj->n) {
		i = obj->n++;
		obj->e = realloc(obj->e, obj->n * sizeof(each_t));
		obj->e[i].k = k;
	} else {
		unlock_var(ex, &obj->e[i].v);
		delete_var(ex, &obj->e[i].v);
	}
	copy_var(&obj->e[i].v, v);
	lock_var(ex, &obj->e[i].v);
	return 1;
}
int object_each(object_t* obj, int i, each_t* e)
{
	if ((i < 0) || (i >= obj->n)) {
		return 0;
	}
	memcpy(e, obj->e + i, sizeof(each_t));
	return 1;
}

/************************************************************
 *
 ************************************************************/
void object_trace(exec_t* ex, void *p)
{
	object_t* obj = p;
	int i;
	for (i = 0; i < obj->n; i++) {
		fprintf(ex->out, " %s: %s\n",
			symbol_to_chars(ex, obj->e[i].k),
			var_toChars(ex, &obj->e[i].v));
	}
}
void object_clear(exec_t* ex, void *p)
{
	object_t* obj = p;
	int i;
	for (i = 0; i < obj->n; i++) {
		unlock_var(ex, &obj->e[i].v);
		delete_var(ex, &obj->e[i].v);
	}
	if (obj->e) {
		free(obj->e);
		obj->e = NULL;
	}
	obj->n = 0;
}
int object_getItem(exec_t* ex, void *p, var_t* k, var_t* v)
{
	return object_get(ex, p, var_toSymbol(ex, k), v);
}
int object_setItem(exec_t* ex, void *p, var_t* k, var_t* v)
{
	return object_set(ex, p, var_toSymbol(ex, k), v);
}
int object_delItem(exec_t* ex, void *p, var_t* k, var_t* v)
{
	return object_del(ex, p, var_toSymbol(ex, k), v);
}
int object_eachItem(exec_t* ex, void *p, int i, var_t* k, var_t* v)
{
	each_t e;
	char *s;
	int n;
	if (!object_each(p, i, &e)) {
		return 0;
	}
	if (k) {
		symbol_to_string(ex, e.k, &s, &n);
		new_string_copy(ex, k, s, n);
	}
	if (v) {
		copy_var(v, &e.v);
	}
	return 1;
}
int object_setLength(exec_t* ex, void *p, int n)
{
	object_t *obj = p;
	if (n < 0) n += obj->n;
	if (n < 0) n=0;
	if (n > obj->n) {
		;
	} else if (n < obj->n) {
		while (obj->n-- > n) {
			unlock_var(ex, &obj->e[obj->n].v);
			delete_var(ex, &obj->e[obj->n].v);
		}
	}
	return 1;
}
int object_getLength(exec_t* ex, void *p)
{
	return ((object_t*)p)->n;
}
int object_toBool(exec_t* ex, var_t* v)
{
	return (((object_t*)v->u.p)->n > 0);
}
int object_toChar(exec_t* ex, var_t* v)
{
	return (((object_t*)v->u.p)->n & 0xFF);
}
int object_toInt(exec_t* ex, var_t* v)
{
	return ((object_t*)v->u.p)->n;
}
double object_toFloat(exec_t* ex, var_t* v)
{
	return ((object_t*)v->u.p)->n;
}
int object_toString(exec_t* ex, var_t* v, char **s, int *n)
{
	*s = "";
	*n = 0;
	return 0;
}

/************************************************************
 *
 ************************************************************/
static int _object_keys(exec_t* ex, object_t* obj, int argc, var_t* argv, var_t* res)
{
	char *s;
	int i,n;
	var_t v;
	exerrif(ex, argc != 0,  "bad arguments");
	exerrif(ex, obj->n <= 0,  "bad data");
	new_array(ex, res, NULL);
	for (i = 0; i < obj->n; i++) {
		if (symbol_to_string(ex, obj->e[i].k, &s, &n)) {
			new_string_copy(ex, &v, s, n);
		} else {
			new_null(&v);
		}
		array_push(ex, res->u.p, &v);
	}
	return 1;
}
static int _object_values(exec_t* ex, object_t* obj, int argc, var_t* argv, var_t* res)
{
	int i;
	exerrif(ex, argc != 0,  "bad arguments");
	exerrif(ex, obj->n <= 0,  "bad data");
	new_array(ex, res, NULL);
	for (i = 0; i < obj->n; i++) {
		array_push(ex, res->u.p, & obj->e[i].v);
	}
	return 1;
}

/************************************************************
 *
 ************************************************************/
static int cmp_eachs_key_asNumber(exec_t* ex, each_t *e1, each_t *e2)
{
	char *s1,*s2;
	int n1,n2;
	symbol_to_string(ex, e1->k, &s1, &n1);
	symbol_to_string(ex, e2->k, &s2, &n2);
	return strrnncmp(s1, n1, s2, n2);
}
static int cmp_eachs_key_asString(exec_t* ex, each_t *e1, each_t *e2)
{
	char *s1,*s2;
	int n1,n2;
	symbol_to_string(ex, e1->k, &s1, &n1);
	symbol_to_string(ex, e2->k, &s2, &n2);
	return strnncmp(s1, n1, s2, n2);
}
static int cmp_eachs_value_asNumber(exec_t* ex, each_t *e1, each_t *e2)
{
	return cmp_vars_asNumber(ex, &e1->v, &e2->v);
}
static int cmp_eachs_value_asString(exec_t* ex, each_t *e1, each_t *e2)
{
	return cmp_vars_asString(ex, &e1->v, &e2->v);
}
static void qsort_eachs(exec_t* ex, each_t* eachs, int first, int last,
	int (*cmp)(exec_t*, each_t*, each_t*), int rev)
{
	each_t mid, tmp;
	int low, high;
	if (first >= last) {
		return;
	}
	low  = first;
	high = last;
	memcpy(&mid, eachs + ((first + last) / 2), sizeof(each_t));
	do {
		if (rev) {
			while ((*cmp)(ex, eachs + low,  & mid) > 0) low++;
			while ((*cmp)(ex, eachs + high, & mid) < 0) high--;
		} else {
			while ((*cmp)(ex, eachs + low,  & mid) < 0) low++;
			while ((*cmp)(ex, eachs + high, & mid) > 0) high--;
		}
		if (low <= high) {
			if (low < high) {
				memcpy(&tmp,         eachs + low,  sizeof(each_t));
				memcpy(eachs + low,  eachs + high, sizeof(each_t));
				memcpy(eachs + high, &tmp,         sizeof(each_t));
			}
			low++;
			high--;
		}
	} while (low <= high);
	qsort_eachs(ex, eachs, first, high, cmp, rev);
	qsort_eachs(ex, eachs, low,   last, cmp, rev);
}
static int _object_sort(exec_t* ex, object_t* obj, int argc, var_t* argv, var_t* res)
{
	each_t *e;
	char *s;
	int i, n, c, key, rev, num;
	int (*cmp)(exec_t*, each_t*, each_t*);
	
	exerrif(ex, (n = obj->n) <= 0,  "bad data");
	
	rev = num = key = 0;
	if (argc > 0) {
		exerrif(ex, !(s = var_toChars(ex, argv)), "bad argument-0");
		while ((c = *s++) != 0) {
			switch(tolower(c)) {
			case 'k': key = 1; break;
			case 'r': rev = 1; break;
			case 'n': num = 1; break;
			case 's': num = 0; break;
			}
		}
	}
	if (key) {
		if (num) {
			cmp = cmp_eachs_key_asNumber;
		} else {
			cmp = cmp_eachs_key_asString;
		}
	} else {
		if (num) {
			cmp = cmp_eachs_value_asNumber;
		} else {
			cmp = cmp_eachs_value_asString;
		}
	}
	
	e = calloc(n, sizeof(each_t));
	memcpy(e, obj->e, n * sizeof(each_t));
	for (i = 0; i < n; i++) {
		lock_var(ex, &e[i].v);
	}
	
	qsort_eachs(ex, e, 0, n - 1, cmp, rev);
	
	obj = object_alloc(ex);
	obj->n = n;
	obj->e = e;
	new_object(ex, res, obj);
	return 1;
}

/************************************************************
 *
 ************************************************************/
int object_callFunc(exec_t* ex, void* p, int sym, int argc, var_t* argv, var_t* res)
{
	switch (sym) {
#include "_object_call.h"
	}
	return -1;
}
