/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#include "util.h"
#include "var.h"
#include "_sym.h"
#include "_ext.h"

/************************************************************
 *
 ************************************************************/
typedef struct {
	FILE* fp;
	int (*xp)(FILE*);
} file_t;

int new_file(exec_t* ex, var_t* v, FILE* fp, int (*xp)(FILE*))
{
	file_t* ft;
	ft = (file_t*)alloc_link(ex, sizeof(file_t), file_proto);
	ft->fp = fp;
	ft->xp = xp;
	v->p = file_proto;
	v->u.p = (void*)ft;
	return 1;
}

/************************************************************
 *
 ************************************************************/
void file_clear(exec_t* ex, void* p)
{
	file_t* ft = p;
	if (ft->fp && ft->xp) {
		(*ft->xp)(ft->fp);
	}
	ft->fp = NULL;
	ft->xp = NULL;
}
void file_trace(exec_t* ex, void *p)
{
	file_t* ft = p;
	fprintf(ex->out, "fp:%p, xp:%p\n", ft->fp, ft->xp);
}

/************************************************************
 *
 ************************************************************/
static int _file_close(exec_t* ex, file_t* ft, int argc, var_t* argv, var_t* res)
{
	exerrif(ex, !ft->fp || !ft->xp, "can't close the file");
	new_bool(res, (*ft->xp)(ft->fp) == 0);
	ft->fp = NULL;
	ft->xp = NULL;
	return 1;
}
static int _file_read(exec_t* ex, file_t* ft, int argc, var_t* argv, var_t* res)
{
	char *s;
	int n;
	
	exerrif(ex, argc != 1,  "bad arguments");
	n = var_toInt(ex, argv);
	exerrif(ex, n <= 0,  "bad argument-0");
	
	s = malloc(n + 1);
	
	if (fread(s, 1, n, ft->fp) != n) {
		free(s);
		return 0;
	}
	s[n] = 0;
	new_string_with(ex, res, s, n);
	
	return 1;
}
static int _file_write(exec_t* ex, file_t* ft, int argc, var_t* argv, var_t* res)
{
	char *s;
	int n;
	
	exerrif(ex, argc < 1,  "bad arguments");
	exerrif(ex, !var_toString(ex, argv, &s, &n), "bad argument-0") ;
	
	if (argc >= 2) {
		n = var_toInt(ex, argv + 1);
	}
	exerrif(ex, n <= 0,  "bad argument-1");
	if (fwrite(s, 1, n, ft->fp) != n) {
		return 0;
	}
	new_int(res, n);
	return 1;
}
static int _file_getc(exec_t* ex, file_t* ft, int argc, var_t* argv, var_t* res)
{
	int c;
	exerrif(ex, argc != 0,  "bad arguments");
	if ((c = fgetc(ft->fp)) < 0) {
		return 0;
	}
	new_char(res, c);
	return 1;
}
static int _file_putc(exec_t* ex, file_t* ft, int argc, var_t* argv, var_t* res)
{
	int c,i,m=0;
	exerrif(ex, argc < 1,  "bad arguments");
	for (i = 0; i < argc; i++) {
		c = var_toChar(ex, argv + i);
		if ((c < 0) || (fputc(c, ft->fp) < 0)) {
			/* put error */
			return 0;
		}
		m++;
	}
	new_int(res, m);
	return 1;
}
static int _file_gets(exec_t* ex, file_t* ft, int argc, var_t* argv, var_t* res)
{
	char *s;
	int n, c;
	
	exerrif(ex, argc != 0,  "bad arguments");
	
	s = malloc(BUFSIZ);
	n = 0;
	
	while ((c = fgetc(ft->fp)) > 0) {
		if (c == 0xd) {
			c = fgetc(ft->fp);
			if ((c > 0) && (c != 0xa)) {
				ungetc(c, ft->fp);
			}
			c = 0xa;
		}
		s = realloc(s, n + 2);
		s[n++] = c;
		if (c == 0xa) {
			break;
		}
	}
	
	if (!n) {
		free(s);
		return 0;
	}
	s[n] = 0;
	new_string_with(ex, res, s, n);
	
	return 1;
}
static int _file_puts(exec_t* ex, file_t* ft, int argc, var_t* argv, var_t* res)
{
	char *s;
	int i, n, m = 0;
	exerrif(ex, argc < 1,  "bad arguments");
	for (i = 0; i < argc; i++) {
		if (var_toString(ex, argv + i, &s, &n)) {
			if (fwrite(s, 1, n, ft->fp) != n) {
				/* fwrite error */
				return 0;
			}
			m += n;
		}
	}
	new_int(res, m);
	return 1;
}
static int _file_printf(exec_t* ex, file_t* ft, int argc, var_t* argv, var_t* res)
{
	char *s;
	exerrif(ex, argc < 1,  "bad arguments");
	exerrif(ex, !(s = var_toChars(ex, argv)), "bad argument-0") ;
	new_int(res, printf_to_file(ex, ft->fp, s, argv + 1, argc - 1));
	return 1;
}
static int _file_tell(exec_t* ex, file_t* ft, int argc, var_t* argv, var_t* res)
{
	exerrif(ex, argc != 0,  "bad arguments");
	new_int(res, ftell(ft->fp));
	return 1;
}
static int _file_rewind(exec_t* ex, file_t* ft, int argc, var_t* argv, var_t* res)
{
	exerrif(ex, argc != 0,  "bad arguments");
	rewind(ft->fp);
	new_bool(res, 1);
	return 1;
}
static int _file_seek(exec_t* ex, file_t* ft, int argc, var_t* argv, var_t* res)
{
	int i = 0, w = SEEK_SET;
	exerrif(ex, argc < 1,  "bad arguments");
	i = var_toInt(ex, argv);
	if (argc >= 2) {
		switch (var_toInt(ex, argv + 1)) {
		case 0: w = SEEK_SET; break;
		case 1: w = SEEK_CUR; break;
		case 2: w = SEEK_END; break;
		default:
			fprintf(ex->err, "bad argument: %s\n", typeof_var(ex, argv + 1));
			return 0;
		}
	}
	new_bool(res, fseek(ft->fp, i, w) == 0);
	return 1;
}

/************************************************************
 *
 ************************************************************/
int file_callFunc(exec_t* ex, void* p, int sym, int argc, var_t* argv, var_t* res)
{
	switch (sym) {
#include "_file_call.h"
	}
	return -1;
}
