/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#include "util.h"
#include "var.h"
#include "_sym.h"
#include "_ext.h"

/************************************************************
 *
 ************************************************************/
static int var_to_serial(exec_t* ex, var_t* v, char **s, int *n);

static int serial_length(exec_t* ex, var_t* v)
{
	object_t* obj;
	array_t* arr;
	each_t e;
	char *s;
	int i, n, m;
	if (v->p == object_proto) {
		obj = v->u.p;
		for (i = n = 0; i < obj->n; i++) {
			if (object_each(obj, i, &e)) {
				n += 4 + symbol_to_string(ex, e.k, &s, &m);
				n += serial_length(ex, &e.v);
			}
		}
		return (5 + n);
	} else if (v->p == array_proto) {
		arr = v->u.p;
		for (i = n = 0; i < arr->n; i++) {
			n += serial_length(ex, arr->v + i);
		}
		return (5 + n);
	} else if (v->p == string_proto) {
		return (5 + ((string_t*)v->u.p)->n);
	} else if (v->p == float_proto) {
		return 9;
	} else if (v->p == int_proto) {
		return 5;
	} else if (v->p == char_proto) {
		return 2;
	} else if (v->p == bool_proto) {
		return 1;
	} else if (!v->p) {
		return 1;
	}
	return 0;
}

static int symbol_to_serial(exec_t* ex, int k, char **s, int *n)
{
	char *s2;
	int n2;
	if (!symbol_to_string(ex, k, &s2, &n2)) {
		*(int*)(*s + *n) = (-k);
		*n += 4;
		return 4;
	}
	*(int*)(*s + *n) = n2;
	*n += 4;
	memcpy(*s + *n, s2, n2);
	*n += n2;
	return (4 + n2);
}
static int object_to_serial(exec_t *ex, object_t* obj, char **s, int *n)
{
	each_t e;
	int i, r, r2, r3;
	*(*s + (*n)++) = 'o';
	*(int*)(*s + *n) = obj->n;
	*n += 4;
	r = 5;
	for (i = 0; i < obj->n; i++) {
		if (!object_each(obj, i, &e)
		|| !(r2 = symbol_to_serial(ex, e.k, s, n))
		|| !(r3 = var_to_serial(ex, &e.v, s, n))) {
			return 0;
		}
		r += r2 + r3;
	}
	return r;
}
static int array_to_serial(exec_t* ex, array_t* arr, char **s, int *n)
{
	int i, r, r2;
	*(*s + (*n)++) = 'a';
	*(int*)(*s + *n) = arr->n;
	*n += 4;
	r = 5;
	for (i = 0; i < arr->n; i++) {
		if (!(r2 = var_to_serial(ex, arr->v + i, s, n))) {
			return 0;
		}
		r += r2;
	}
	return r;
}
static int string_to_serial(string_t* str, char **s, int *n)
{
	*(*s + (*n)++) = 's';
	*(int*)(*s + *n) = str->n;
	*n += 4;
	memcpy(*s + *n, str->s, str->n);
	*n += str->n;
	return (5 + str->n);
}
static int float_to_serial(double f, char **s, int *n)
{
	*(*s + (*n)++) = 'f';
	*(double*)(*s + *n) = f;
	*n += 8;
	return 9;
}
static int int_to_serial(int v, char **s, int *n)
{
	*(*s + (*n)++) = 'i';
	*(int*)(*s + *n) = v;
	*n += 4;
	return 5;
}
static int char_to_serial(int c, char **s, int *n)
{
	*(*s + (*n)++) = 'c';
	*(*s + (*n)++) = c;
	return 2;
}
static int bool_to_serial(int v, char **s, int *n)
{
	*(*s + (*n)++) = v ? '1' : '0';
	return 1;
}
static int null_to_serial(char **s, int *n)
{
	*(*s + (*n)++) = 'n';
	return 1;
}
static int var_to_serial(exec_t* ex, var_t* v, char **s, int *n)
{
	if (v->p == object_proto) {
		return object_to_serial(ex, v->u.p, s, n);
	} else if (v->p == array_proto) {
		return array_to_serial(ex, v->u.p, s, n);
	} else if (v->p == string_proto) {
		return string_to_serial(v->u.p, s, n);
	} else if (v->p == float_proto) {
		return float_to_serial(v->u.f, s, n);
	} else if (v->p == char_proto) {
		return char_to_serial(v->u.i, s, n);
	} else if (v->p == int_proto) {
		return int_to_serial(v->u.i, s, n);
	} else if (v->p == bool_proto) {
		return bool_to_serial(v->u.i, s, n);
	} else if (!v->p) {
		return null_to_serial(s, n);
	}
	return 0;
}
int serial_to_bytes(exec_t* ex, var_t* v, char **s, int *n)
{
	int r;
	*s = malloc(serial_length(ex, v) + 1);
	*n = 0;
	r = var_to_serial(ex, v, s, n);
	if (!r) {
		if (*s) free(*s);
		*s = NULL;
		*n = 0;
		return 0;
	}
	*(*s + *n) = 0;
	return r;
}

/************************************************************
 *
 ************************************************************/
static int serial_to_var(exec_t* ex, var_t* v, char** s, char *e);

static int serial_to_symbol(exec_t* ex, int *k, char** s, char* e)
{
	char *s2;
	int n2;
	if ((*s + 4) > e) return 0;
	n2 = *(int*)(*s);
	*s += 4;
	if (n2 < 0) {
		*k = (-n2);
		return 4;
	}
	if ((*s + n2) > e) return 0;
	s2 = *s;
	*s += n2;
	*k = string_to_symbol(ex, s2, n2);
	return (*k ? (4 + n2) : 0);
}
static int serial_to_object(exec_t* ex, var_t* v, char** s, char *e)
{
	var_t v2;
	int i, k, n, r, r2, r3;
	if ((*s + 4) > e) return 0;
	n = *(int*)(*s);
	*s += 4;
	new_object(ex, v, NULL);
	r = 4;
	for (i = 0; i < n; i++) {
		if (!(r2 = serial_to_symbol(ex, &k, s, e))
		|| !(r3 = serial_to_var(ex, &v2, s, e))) {
			object_free(ex, v->u.p);
			return 0;
		}
		object_set(ex, v->u.p, k, &v2);
		r += r2 + r3;
	}
	return r;
}
static int serial_to_array(exec_t* ex, var_t* v, char** s, char* e)
{
	var_t v2;
	int i, n, r, r2;
	if ((*s + 4) > e) return 0;
	n = *(int*)(*s);
	*s += 4;
	new_array(ex, v, NULL);
	r = 4;
	for (i = 0; i < n; i++) {
		if (!(r2 = serial_to_var(ex, &v2, s, e))) {
			array_free(ex, v->u.p);
			return 0;
		}
		array_push(ex, v->u.p, &v2);
		r += r2;
	}
	return r;
}
static int serial_to_string(exec_t* ex, var_t* v, char** s, char* e)
{
	char *s2;
	int n2;
	if ((*s + 4) > e) return 0;
	n2 = *(int*)(*s);
	*s += 4;
	if ((*s + n2) > e) return 0;
	s2 = *s;
	*s += n2;
	new_string_copy(ex, v, s2, n2);
	return (4 + n2);
}
static int serial_to_float(var_t* v, char** s, char *e)
{
	if ((*s + 8) > e) return 0;
	new_float(v, *(double*)(*s));
	*s += 8;
	return 8;
}
static int serial_to_int(var_t* v, char** s, char *e)
{
	if ((*s + 4) > e) return 0;
	new_int(v, *(int*)(*s));
	*s += 4;
	return 4;
}
static int serial_to_char(var_t* v, char** s, char* e)
{
	if (*s >= e) return 0;
	new_char(v, *(*s)++);
	return 1;
}
static int serial_to_var(exec_t* ex, var_t* v, char** s, char *e)
{
	int r;
	if (*s >= e) return 0;
	switch (*(*s)++) {
	case 'o': return (((r = serial_to_object(ex, v, s, e)) > 0) ? ++r : 0);
	case 'a': return (((r = serial_to_array(ex, v, s, e)) > 0) ? ++r : 0);
	case 's': return (((r = serial_to_string(ex, v, s, e)) > 0) ? ++r : 0);
	case 'f': return (((r = serial_to_float(v, s, e)) > 0) ? ++r : 0);
	case 'i': return (((r = serial_to_int(v, s, e)) > 0) ? ++r : 0);
	case 'c': return (((r = serial_to_char(v, s, e)) > 0) ? ++r : 0);
	case '1': new_bool(v, 1); return 1;
	case '0': new_bool(v, 0); return 1;
	case 'n': new_null(v); return 1;
	}
	return 0;
}

int unserial_from_bytes(exec_t* ex, var_t* v, char *s, int n)
{
	int r;
	r = serial_to_var(ex, v, &s, s + n);
	if (!r) {
		new_null(v);
		return 0;
	}
	return r;
}
