/*
 * Copyright (c) 2007, to-do. All rights reserved.
 */
#include "util.h"

/************************************************************
 *
 ************************************************************/
int strnncmp(char *s1, int n1, char* s2, int n2)
{
	int i,r;
	for (i=0; (i < n1) && (i < n2); i++) {
		if ((r = s1[i] - s2[i]) != 0) return r;
	}
	return (n1 - n2);
}
int strrnncmp(char *s1, int n1, char* s2, int n2)
{
	int i,r;
	if ((r = n1 - n2) != 0) return r;
	for (i=0; i < n1; i++) {
		if ((r = s1[i] - s2[i]) != 0) return r;
	}
	return 0;
}
int strtoh(char *s, int n)
{
	int i, c, k = 0;
	for (k = i = 0; (i < n) && ((c = s[i]) > 0); i++) {
		k = ((k & 0xffffff) << 7) ^ (k >> 24) ^ c;
	}
	return k;
}
int iscrlf(int c)
{
	return ((c == 0xa) || (c == 0xd));
}

/***************************************************************
 *
 ***************************************************************/
int isoctal(int c)
{
	return (c >= '0' && c <= '7');
}
int itoX(int c)
{
	if (c < 10) return (c + '0');
	if (c < 16) return ((c - 10) + 'A');
	return '0';
}
int xtoi(int c)
{
	return (isalpha(c) ? (10 + tolower(c) - 'a') : (isdigit(c) ? (c - '0') : 0));
}
int c_to_meta(int* c, int q)
{
	if ((*c == q) || (*c == '\\')) {
		return 1;
	}
	if (((q == '`') || (q == '/'))
	&& *c && strchr("^.*+?[-](|){,}$", *c)) {
		return 1;
	}
	switch (*c) {
	case 0x0: *c = '0'; return 1;
	case 0x7: *c = 'a'; return 1;
	case 0x8: *c = 'b'; return 1;
	case 0x9: *c = 't'; return 1;
	case 0xa: *c = 'n'; return 1;
	case 0xb: *c = 'v'; return 1;
	case 0xc: *c = 'f'; return 1;
	case 0xd: *c = 'r'; return 1;
	}
	return 0;
}
int meta_to_c(char** s, int q)
{
	int c;
	if (!(c = *(*s))) {
		return '\\';
	} else if (c == 'x') {
		(*s)++;
		if (!isxdigit(*(*s))) return 0;
		c = xtoi(*(*s)++);
		if (!isxdigit(*(*s))) return c;
		return ((c << 4) | xtoi(*(*s)++));
	} else if (c == '0') {
		(*s)++;
		if (!isoctal(*(*s))) return 0;
		c = *(*s)++ - '0';
		if (!isoctal(*(*s))) return c;
		return ((c << 3) | (*(*s)++ - '0'));
	} else if ((c == q) || (c == '\\')) {
		return *(*s)++;
	}
	switch (c) {
	case 'a': (*s)++; return 0x7;
	case 'b': (*s)++; return 0x8;
	case 't': (*s)++; return 0x9;
	case 'n': (*s)++; return 0xa;
	case 'v': (*s)++; return 0xb;
	case 'f': (*s)++; return 0xc;
	case 'r': (*s)++; return 0xd;
	}
	return (q ? '\\' : *(*s)++);
}
char* c_to_entity(int c)
{
	     if (c == '"') return "&quot;";
	else if (c == '&') return "&amp;";
	else if (c == '<') return "&lt;";
	else if (c == '>') return "&gt;";
	return NULL;
}
int entity_to_c(char **s)
{
	int c, n = 0;
	if (**s == '#') c = strtol(*s, s, 10);
	else if (!islower(**s)) return '&';
	else if (!strncmp(*s, "nbsp", n=4)) { c = '\t'; (*s) += n; }
	else if (!strncmp(*s, "quot", n=4)) { c = '"';  (*s) += n; }
	else if (!strncmp(*s, "apos", n=4)) { c = '\''; (*s) += n; }
	else if (!strncmp(*s, "amp",  n=3)) { c = '&';  (*s) += n; }
	else if (!strncmp(*s, "dol",  n=3)) { c = '$';  (*s) += n; }
	else if (!strncmp(*s, "lt",   n=2)) { c = '<';  (*s) += n; }
	else if (!strncmp(*s, "gt",   n=2)) { c = '>';  (*s) += n; }
	else return '&';
	if (**s == ';') (*s)++;
	return c;
}
