/*
 * Decompiled with CFR 0.152.
 */
package org.yanroncha.jscope.core.filter.xml;

import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.Attributes;
import org.yanroncha.jscope.core.filter.CoreXmlFilter;

public abstract class Node {
    protected static String ARTICLE_SEP = "/";
    protected static String PARAGRAPH_SEP = ":";
    protected static String PAGE_SEP = "@";
    protected static final String NULL_OBJECT = "null";
    protected static final String TC_LOCATION = "location";
    protected static final String TC_MENU = "menu";
    protected static final String TC_PAGE = "page";
    protected static final String TC_PARAGRAPH = "paragraph";
    protected static final String TC_NO_BREAK = "no_break";
    protected static CoreXmlFilter xmlFilter = null;
    private static Value targetValue = null;
    private HashMap<String, Value> values = new HashMap();

    public static void setFilter(CoreXmlFilter coreXmlFilter) {
        xmlFilter = coreXmlFilter;
    }

    public static int[] getTargetValueLocation() {
        int[] nArray = new int[2];
        if (targetValue != null) {
            nArray[0] = Node.targetValue.line;
            nArray[1] = Node.targetValue.col;
        } else {
            nArray[1] = -1;
            nArray[0] = -1;
        }
        return nArray;
    }

    public Node(Attributes attributes) {
    }

    protected Set<String> getValueKeys() {
        return this.values.keySet();
    }

    protected Value getValueObj(String string) {
        return this.values.get(string);
    }

    protected String getValue(String string) {
        return this.values.get((Object)string).val;
    }

    protected int getValuesCount() {
        return this.values.size();
    }

    public void setValue(String string, String string2, String string3) throws Exception {
        Object object;
        if (string2.length() > 1) {
            object = new StringBuilder(string2);
            int n = ((StringBuilder)object).length() - 1;
            char c = ((StringBuilder)object).charAt(0);
            char c2 = ((StringBuilder)object).charAt(n);
            if (c == '[') {
                if (c2 != ']') {
                    throw new CoreXmlFilter.WrongParameterValueException(this, string, string2);
                }
            } else if (c == '\"') {
                if (c2 != '\"') {
                    throw new CoreXmlFilter.WrongParameterValueException(this, string, string2);
                }
                ((StringBuilder)object).deleteCharAt(n);
                ((StringBuilder)object).deleteCharAt(0);
                String string4 = ((StringBuilder)object).toString();
                string4 = string4.replaceAll("\\\\", "\\\\\\\\");
                string4 = string4.replaceAll("\\\"", "\\\\\"");
                ((StringBuilder)object).delete(0, n - 1);
                ((StringBuilder)object).append(c);
                ((StringBuilder)object).append(string4);
                ((StringBuilder)object).append(c2);
                string2 = ((StringBuilder)object).toString();
            }
        }
        object = xmlFilter.getLocator();
        this.values.put(string, new Value(string2, string3, object.getLineNumber(), object.getColumnNumber()));
    }

    public String fetchValue(String string) {
        try {
            return this.values.remove((Object)string).val;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void checkNecessaryValues(Node node, String ... stringArray) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            if (node.getValueObj(string) != null) continue;
            arrayList.add(string);
        }
        if (arrayList.size() > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append((String)arrayList.get(i));
            }
            throw new CoreXmlFilter.NecessaryParameterLackedException(node, stringBuilder.toString());
        }
    }

    protected String getParagraphLocation(String string) {
        String[] stringArray = string.split(PARAGRAPH_SEP);
        if (stringArray.length == 2) {
            int n = xmlFilter.getPageIndex(stringArray[0]);
            int n2 = xmlFilter.getParagraphIndex(stringArray[0], stringArray[1]);
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('[');
            stringBuilder.append(n);
            stringBuilder.append(',');
            stringBuilder.append(n2);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
        return null;
    }

    public void writeValues(PrintWriter printWriter, int n) throws Exception {
        String string = xmlFilter.getIndent();
        Set<String> set = this.getValueKeys();
        int n2 = set.size();
        int n3 = 1;
        for (String string2 : set) {
            Object object;
            Value value = targetValue = this.getValueObj(string2);
            String string3 = value.val;
            if (string3 == null || string3.length() == 0) {
                string3 = NULL_OBJECT;
            } else if (TC_MENU.equals(value.type)) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('[');
                stringBuilder.append(xmlFilter.getMenuItemLocation(string3));
                stringBuilder.append(']');
                string3 = stringBuilder.toString();
            } else if (TC_LOCATION.equals(value.type)) {
                String[] stringArray = string3.split(PARAGRAPH_SEP);
                object = stringArray[0].split(PAGE_SEP);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('[');
                if (stringArray.length == 1 && ((Object)object).length == 1) {
                    stringBuilder.append(xmlFilter.getMenuItemLocation(string3));
                    stringBuilder.append(",-1,0]");
                } else if (stringArray.length == 1 && ((Object)object).length == 2) {
                    stringBuilder.append(xmlFilter.getContentsLocation(stringArray[0]));
                    stringBuilder.append(",0]");
                } else if (stringArray.length == 2 && ((Object)object).length == 2) {
                    String[] stringArray2 = stringArray[1].split(ARTICLE_SEP);
                    stringBuilder.append(xmlFilter.getContentsLocation(stringArray[0]));
                    stringBuilder.append(',');
                    stringBuilder.append(xmlFilter.getParagraphIndex((String)object[0], stringArray2[0]));
                    if (stringArray2.length == 2) {
                        stringBuilder.append(",\"");
                        stringBuilder.append(stringArray2[1]);
                        stringBuilder.append('\"');
                    }
                    stringBuilder.append(']');
                } else {
                    throw new CoreXmlFilter.WrongParameterValueException(this, string2, string3);
                }
                string3 = stringBuilder.toString();
            } else if (TC_PAGE.equals(value.type)) {
                int n4 = xmlFilter.getPageIndex(string3);
                object = new StringBuilder();
                ((StringBuilder)object).append('[');
                ((StringBuilder)object).append(Integer.toString(n4));
                ((StringBuilder)object).append(']');
                string3 = ((StringBuilder)object).toString();
            } else if (TC_PARAGRAPH.equals(value.type)) {
                if ((string3 = this.getParagraphLocation(string3)) == null) {
                    throw new CoreXmlFilter.WrongParameterValueException(this, string2, string3);
                }
            } else {
                string3 = TC_NO_BREAK.equals(value.type) ? string3.replaceAll("\\\n", "") : string3.replaceAll("\\\n", "<br>");
            }
            printWriter.printf("%s%s: %s", string, string2, string3);
            if (n3 < n2 || n > 0) {
                printWriter.print(",\n");
            } else {
                printWriter.print("\n");
            }
            ++n3;
        }
    }

    public abstract Node setSubNode(String var1, Attributes var2) throws Exception;

    public Node quitNode(String string) throws Exception {
        return null;
    }

    public abstract void writeData(PrintWriter var1, int var2) throws Exception;

    private class Value {
        String val;
        String type;
        int line;
        int col;

        public Value(String string, String string2, int n, int n2) {
            this.val = string;
            this.type = string2;
            this.line = n;
            this.col = n2;
        }
    }

    public static class NodeFormInfo {
        String name;
        HashMap<String, Class<? extends Node>> subNodeMap;
        HashSet<String> innerSubNodes;
        HashSet<String> prmNodes;
        HashSet<String> keywords;

        public NodeFormInfo(String string) {
            this.name = string;
            this.subNodeMap = new HashMap();
            this.innerSubNodes = new HashSet();
            this.prmNodes = new HashSet();
            this.keywords = new HashSet();
        }

        public void regSubNode(String string, Class<? extends Node> clazz) {
            this.subNodeMap.put(string, clazz);
            CoreXmlFilter.initNodeClass(clazz);
        }

        public Node getSubNode(String string, Attributes attributes) {
            try {
                Class<? extends Node> clazz = this.subNodeMap.get(string);
                Constructor<? extends Node> constructor = clazz.getConstructor(Attributes.class);
                return constructor.newInstance(attributes);
            }
            catch (Exception exception) {
                return null;
            }
        }

        public String getName() {
            return this.name;
        }

        public Class<? extends Node> getSubNodeClass(String string) {
            return this.subNodeMap.get(string);
        }

        public void regInnerSubNode(String string) {
            this.innerSubNodes.add(string);
        }

        public boolean isInnerSubNode(String string) {
            return this.innerSubNodes.contains(string);
        }

        public void regPrmNode(String string) {
            this.prmNodes.add(string);
        }

        public boolean isPrmNode(String string) {
            return this.prmNodes.contains(string);
        }

        public void regKeyword(String string) {
            this.keywords.add(string);
        }

        public boolean isKeyword(String string) {
            return this.keywords.contains(string);
        }
    }
}

