/*
 * Decompiled with CFR 0.152.
 */
package org.yanroncha.n3.resource.xml.node;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.xml.sax.Attributes;
import org.yanroncha.n3.resource.xml.N3XmlConverter;
import org.yanroncha.n3.resource.xml.node.Menu;
import org.yanroncha.n3.resource.xml.node.Node;
import org.yanroncha.n3.resource.xml.node.Paragraph;

public class MenuItem
extends Menu {
    private static final String MITEM_SNN_MITEM = "menu_item";
    private static final String MITEM_ISNN_CHILDREN = "children";
    private static final String MITEM_ISNN_HEADER = "header";
    private static final String MITEM_ISNN_FOOTER = "footer";
    private static final String MITEM_PNN_ID = "id";
    private static final String MITEM_PNN_TITLE = "title";
    private static final String MITEM_PNN_TYPE = "type";
    private static final String MITEM_PNN_ACTION = "action";
    private static final String MITEM_PNN_DEF_POS = "defpos";
    private static final String MITEM_PNN_CONTENTS = "contents";
    private static final String MITEM_PNN_IMAGE = "image";
    private static final String MITEM_PNN_EXPAND = "expand";
    private static final String MITEM_PNN_ISIZE = "image_size";
    private static final String MITEM_PNN_TGRID = "tile_grid";
    private static final String MITEM_PNN_TSIZE = "tile_size";
    private static final String MITEM_PNN_EVENT = "event";
    private static final String MITEM_PNN_EVENTVAL = "event_value";
    private static final String MITEM_PNN_B_DESIGN = "base_design";
    private static final String MITEM_PNN_DESIGN = "design";
    private static final String MITEM_PNN_EXTERNAL = "external";
    private static final String MITEM_AN_SORT = "sort";
    private static final String MITEM_AV_TRUE = "true";
    private static final String MITEM_AV_FALSE = "false";
    private static final String MITEM_AN_ID = "id";
    private static final int MITEM_TYPE_NONE = 0;
    private static final int MITEM_TYPE_HASCHILDREN = 1;
    private static final int MITEM_TYPE_HASCONTENTS = 2;
    private static HashMap<String, Integer> itemTypes;
    private static Node.NodeFormInfo nfInfo;
    private static ArrayList<MenuItem> contentsSrcs;
    private static HashMap<String, String> locMap;
    private static HashMap<String, MenuItem> idMap;
    StringBuilder loc = new StringBuilder();
    private boolean contentsSort = false;
    private Paragraph headerNode = null;
    private Paragraph footerNode = null;
    private HashMap<String, Integer> posList = null;
    private String contentsSrc = null;

    public static void init() {
        if (nfInfo != null) {
            return;
        }
        nfInfo = new Node.NodeFormInfo(MITEM_SNN_MITEM);
        nfInfo.regSubNode(MITEM_SNN_MITEM, MenuItem.class);
        nfInfo.regInnerSubNode(MITEM_ISNN_CHILDREN);
        nfInfo.regInnerSubNode(MITEM_ISNN_HEADER);
        nfInfo.regInnerSubNode(MITEM_ISNN_FOOTER);
        nfInfo.regPrmNode("id");
        nfInfo.regPrmNode(MITEM_PNN_TITLE);
        nfInfo.regPrmNode(MITEM_PNN_TYPE);
        nfInfo.regPrmNode(MITEM_PNN_ACTION);
        nfInfo.regPrmNode(MITEM_PNN_DEF_POS);
        nfInfo.regPrmNode(MITEM_PNN_CONTENTS);
        nfInfo.regPrmNode(MITEM_PNN_IMAGE);
        nfInfo.regPrmNode(MITEM_PNN_EXPAND);
        nfInfo.regPrmNode(MITEM_PNN_ISIZE);
        nfInfo.regPrmNode(MITEM_PNN_TGRID);
        nfInfo.regPrmNode(MITEM_PNN_TSIZE);
        nfInfo.regPrmNode(MITEM_PNN_EVENT);
        nfInfo.regPrmNode(MITEM_PNN_EVENTVAL);
        nfInfo.regPrmNode(MITEM_PNN_B_DESIGN);
        nfInfo.regPrmNode(MITEM_PNN_DESIGN);
        nfInfo.regPrmNode(MITEM_PNN_EXTERNAL);
        itemTypes = new HashMap();
        itemTypes.put("\"root\"", 1);
        itemTypes.put("\"contents\"", 2);
        itemTypes.put("\"group_list\"", 1);
        itemTypes.put("\"list\"", 2);
        itemTypes.put("\"group_button\"", 1);
        itemTypes.put("\"button\"", 2);
        itemTypes.put("\"group_icon\"", 1);
        itemTypes.put("\"icon\"", 2);
        itemTypes.put("\"group_tile\"", 1);
        itemTypes.put("\"tile\"", 2);
        itemTypes.put("\"static\"", 1);
        itemTypes.put("\"expander\"", 1);
        itemTypes.put("\"design\"", 0);
        itemTypes.put("\"header\"", 0);
        itemTypes.put("\"footer\"", 0);
        itemTypes.put("\"composite\"", 1);
        itemTypes.put("\"leaf\"", 2);
        itemTypes.put("\"toggle\"", 1);
        contentsSrcs = new ArrayList();
        locMap = new HashMap();
        idMap = new HashMap();
    }

    public static String getLocationById(String string) throws Exception {
        String string2 = locMap.get(string);
        if (string2 == null) {
            throw new N3XmlConverter.IndexNotFoundException(string);
        }
        return string2;
    }

    public static MenuItem getItemById(String string) throws Exception {
        MenuItem menuItem = idMap.get(string);
        if (menuItem == null) {
            throw new N3XmlConverter.IdNotFoundException(MenuItem.class.getName(), string);
        }
        return menuItem;
    }

    public static void convertLocations() throws Exception {
        int n = contentsSrcs.size();
        for (int i = 0; i < n; ++i) {
            MenuItem menuItem = contentsSrcs.get(i);
            String string = menuItem.contentsSrc;
            menuItem.posList = new HashMap();
            if (string == null || string.length() <= 0) continue;
            Object[] objectArray = string.split("\\s*,\\s*");
            int n2 = objectArray.length;
            if (n2 > 0) {
                if (menuItem.contentsSort) {
                    Arrays.sort(objectArray);
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append('[');
                for (int j = 0; j < n2; ++j) {
                    Object object = objectArray[j];
                    String string2 = ((String)object).split(PAGE_SEP)[0];
                    int n3 = xmlConverter.getPageIndex(string2);
                    stringBuilder.append(n3);
                    if (j < n2 - 1) {
                        stringBuilder.append(',');
                    }
                    menuItem.posList.put(string2, j);
                    if (locMap.containsKey(object)) {
                        throw new N3XmlConverter.IdDuplicatedException(menuItem, (String)object);
                    }
                    StringBuilder stringBuilder2 = new StringBuilder(menuItem.loc);
                    stringBuilder2.append(',');
                    stringBuilder2.append(j);
                    locMap.put((String)object, stringBuilder2.toString());
                }
                stringBuilder.append("]");
                string = stringBuilder.toString();
            }
            menuItem.setConvertedValue(MITEM_PNN_CONTENTS, string);
        }
    }

    public MenuItem(Attributes attributes) {
        super(attributes);
        String string = attributes.getValue("id");
        if (string != null) {
            idMap.put(string, this);
        }
    }

    @Override
    public void setValue(String string, String string2, String string3) throws Exception {
        if (MITEM_PNN_CONTENTS.equals(string)) {
            this.contentsSrc = string2;
            contentsSrcs.add(this);
            return;
        }
        super.setValue(string, string2, string3);
    }

    private void setConvertedValue(String string, String string2) throws Exception {
        super.setValue(string, string2, null);
    }

    @Override
    public Node setSubNode(String string, Attributes attributes) throws Exception {
        if (nfInfo.isPrmNode(string)) {
            if (MITEM_PNN_CONTENTS.equals(string)) {
                String string2 = attributes.getValue(MITEM_AN_SORT);
                this.contentsSort = MITEM_AV_TRUE.equals(string2);
            }
            return null;
        }
        if (nfInfo.isInnerSubNode(string)) {
            if (MITEM_ISNN_HEADER.equals(string)) {
                this.headerNode = new Paragraph(attributes);
                return this.headerNode;
            }
            if (MITEM_ISNN_FOOTER.equals(string)) {
                this.footerNode = new Paragraph(attributes);
                return this.footerNode;
            }
            return this;
        }
        Node node = nfInfo.getSubNode(string, attributes);
        if (node != null && node instanceof MenuItem) {
            ((MenuItem)node).setLocation(new StringBuilder(this.loc), this.getSubNodeCount());
            this.addSubNode(node);
            return node;
        }
        return null;
    }

    @Override
    public Node quitNode(String string) throws Exception {
        if (nfInfo.isInnerSubNode(string)) {
            return this;
        }
        this.checkNecessaryValues(this, MITEM_PNN_TYPE, MITEM_PNN_TITLE);
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeData(PrintWriter printWriter, int n) throws Exception {
        int n2;
        String string = this.getValue(MITEM_PNN_TYPE);
        Integer n3 = itemTypes.get(string);
        if (n3 == null) {
            throw new N3XmlConverter.WrongParameterValueException(this, MITEM_PNN_TYPE, string);
        }
        String string2 = xmlConverter.pushIndent();
        printWriter.printf("%s{\n", string2);
        string2 = xmlConverter.pushIndent();
        String string3 = this.fetchValue(MITEM_PNN_DEF_POS);
        if (string3 != null) {
            n2 = n3;
            if ((n2 & 2) != 0) {
                Integer n4 = this.posList.get(string3);
                if (n4 == null) throw new N3XmlConverter.IdNotFoundException(MenuItem.class.getName(), string3);
                printWriter.printf("%s%s: %d,\n", string2, MITEM_PNN_DEF_POS, n4);
            } else if ((n2 & 1) != 0) {
                try {
                    int n5 = Integer.parseInt(string3);
                    if (n5 < 0 || n5 > this.getSubNodeCount()) {
                        throw new N3XmlConverter.WrongParameterValueException(this, MITEM_PNN_DEF_POS, string3);
                    }
                    printWriter.printf("%s%s: %s,\n", string2, MITEM_PNN_DEF_POS, string3);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new N3XmlConverter.WrongParameterValueException(this, MITEM_PNN_DEF_POS, string3);
                }
            }
        }
        n2 = this.getSubNodeCount();
        this.writeValues(printWriter, n2);
        if (n2 > 0) {
            printWriter.printf("%s%s:", string2, MITEM_ISNN_CHILDREN);
            super.writeData(printWriter, this.headerNode == null && this.footerNode == null ? 0 : 1);
        }
        if (this.headerNode != null) {
            this.headerNode.writeData(printWriter, n);
        }
        if (this.footerNode != null) {
            this.footerNode.writeData(printWriter, n);
        }
        string2 = xmlConverter.popIndent();
        printWriter.printf("%s}", string2);
        if (n > 0) {
            printWriter.print(",\n");
        } else {
            printWriter.print("\n");
        }
        xmlConverter.popIndent();
    }

    public void setLocation(StringBuilder stringBuilder, int n) {
        if (stringBuilder != null) {
            this.loc.append((CharSequence)stringBuilder);
            this.loc.append(',');
        }
        this.loc.append(n);
    }

    public String getLocation() {
        return this.loc.toString();
    }

    static {
        nfInfo = null;
    }
}

