/**
 * common configurations of JScope application.
 *
 * project: @JScope.ProjectName@
 * author : @JScope.AuthorName@
 */
JScope.Config = Class.cast({
    // ###########################
    // ##### CONSTANT VALUES #####
    // ###########################
    Const: {
        /**
         * project name
         */
        PROJECT_NAME: "@JScope.ProjectName@",

        /**
         * application name (inner)
         */
        APP_NAME: "@JScope.AppName@",

        /**
         * contents viwer class
         */
        CONT_VIEWER_CLASS: N3C.DefaultViewer,

        /**
         * system button name
         */
        MENU_BACK_BUTTON_NAME: "[MAX 4 CHARS]",
        CONTENTS_QUIT_BUTTON_NAME: "[MAX 4 CHARS]",

        /**
         * paging apnimation
         * ( FlickPager.PANIM_NONE,
         *   FlickPager.PANIM_LEFT_RIGHT,
         *   FlickPager.PANIM_UP_DOWN,
         *   FlickPager.PANIM_FADE_INOUT )
         */
        GLOBAL_ANIM_TYPE: FlickPager.PANIM_NONE,
        // GLOBAL_ANIM_TYPE: FlickPager.PANIM_LEFT_RIGHT,
        // GLOBAL_ANIM_TYPE: FlickPager.PANIM_FADE_INOUT,
        MENU_ANIM_TYPE: FlickPager.PANIM_NONE,
        // MENU_ANIM_TYPE: FlickPager.PANIM_LEFT_RIGHT,
        // MENU_ANIM_TYPE: FlickPager.PANIM_FADE_INOUT,
        PAGING_ANIM_TYPE: FlickPager.PANIM_NONE,
        // PAGING_ANIM_TYPE: FlickPager.PANIM_LEFT_RIGHT,
        // PAGING_ANIM_TYPE: FlickPager.PANIM_FADE_INOUT,

        /**
         * animation time ( milli-sec )
         */
        PAGING_ANIM_INTERVAL: 280,

        /**
         * animation timing vaue
         */
        PAGING_ANIM_TIMING: PageChanger.LINEAR,
        // PAGING_ANIM_TIMING: PageChanger.EASE,
        // PAGING_ANIM_TIMING: PageChanger.EASE_IN,
        // PAGING_ANIM_TIMING: PageChanger.EASE_OUT,

        /**
         * FlickPager parameters
         */
        // FP_FLICK_DISABLED: true,
        FP_CEASE_NAVI: false,
        FP_FLICK_DIFF: [44, 8],
        FP_NAVI_SIZE: [24, 24],
        FP_NAVI_ONLY_IMAGE: false,
        FP_NAVI_DESIGN: "jscope_navi_button",
        FP_KEEP_SCROLL: true,
        FP_WATCH_TIME: 250,
        FP_PINCH_ZOOM: true,
        FP_NAVI_IMAGES: [
            "image/arrow_left.png",
            "image/arrow_right.png"
        ],

        /**
         * use inner location change
         */
        INNER_LOCATEION: true,

        /**
         * use history or not
         */
        HISTORY_BACK: false,

        /**
         * system navigation button margin
         */
        BUTTON_MARGIN: 2,

        /**
         * tile sum margin
         */
        TILE_SUM_MARGIN: 0.2,

        /**
         * Script secure ( !Caution. If you release this switch, application can be destroyed by Core data. )
         */
        SCRIPT_SECURE: true,

        /**
         * storage key ( send key and receive key )
        STORAGE_KEYS: [
            null, null
        ],

        /**
         * secure modules
         */
        SEC_MODULES: [
            // DComponent.Secure.HtmlFilter,
            // DComponent.Secure.HtmlZeroFilter,
            // DComponent.Secure.CrossSiteChecker
        ]
    }
});

/**
 * @JScope.ProjectName@ application
 */
// setup drawers
var @JScope.AppClassName@ = Class.cast({
    // ######################
    // ##### BASE CLASS  ####
    // ######################
    Extends: JScope.Application,

    // ######################
    // ##### INTERFACES #####
    // ######################

    // #################################
    // ##### SET APPLICATION CLASS  ####
    // #################################
    Loader: function() {
        JScope.Application.regAppClass(this);
    },

    // ############################
    // ##### CLASS PROPERTIES #####
    // ############################
    Static: {
    },

    // ###############################
    // ##### INSTANCE PROPERTIES  ####
    // ###############################

    // #######################
    // ##### CONSTRUCTOR #####
    // #######################
    /**
     * constructor
     *
     */
    newInstance: function() {
        // call super class constructor
        this.superClass();
    },

    // ###########################
    // ##### VIRTUAL METHODS #####
    // ###########################
    // initializer
    init: function() {
    },

    // ##########################
    // ##### PUBLIC METHODS  ####
    // ##########################

    // ###########################
    // ##### PRIVATE METHODS  ####
    // ###########################

    // #############################
    // ##### INTERFACE METHODS  ####
    // #############################

    // #######################
    // ##### INNER CLASS #####
    // #######################

});
