/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: testsuite.cpp,v 1.3 2003/12/15 07:32:14 takayuki Exp $
 */

// $Header: /home/CVS/configurator/base/testsuite.cpp,v 1.3 2003/12/15 07:32:14 takayuki Exp $

#include "base/testsuite.h"

#include "base/coverage_defs.h"
#include "base/coverage_undefs.h"

#ifdef TESTSUITE

#undef  main           //ƥȥѤmainΤundef
#undef  cin
#undef  cout
#undef  cerr

#include <stdlib.h>     //EXIT_SUCCESS|EXIT_FAILURE
#include <fstream>      //ȴؿ
#include <cstdio>
#include <iomanip>

using namespace std;

/* ȥ꡼Ѥѿ */
namespace std {
    stringstream _cin;
    stringstream _cout;
    stringstream _cerr;
}

/*
 *  ƥȥȤμ¹楯饹 ; class TestSuiteControl
 */


    //󥹥ȥ饯
TestSuiteControl::TestSuiteControl(ostream & _out, const char * _pattern) : target_session(_pattern), out(&_out), fail(false), verbose(false), case_count(0), fail_count(0)
{}

    //ʥꥪ̾μ
string TestSuiteControl::get_suitename(const char * name) const
{
    string result;
    list<string>::const_iterator scope;

    scope = session.begin();
    while(scope != session.end()) {
        result += *scope;
        result += '.';
        ++ scope;
    }

    if(name != NULL)
        result += name;

    return result;
}


    //ƥȥʥꥪɽ (ֵ : ¹Ԥɬפ뤫ɤ)
bool TestSuiteControl::_enter_case(const char * session, const char * description, const char * filename, long lineno)
{
    bool         result;
    stringstream buf;

        //ɽ
    current_session.assign(get_suitename(session));

        //ܺپ
    if(description != 0)
        buf << description;

        //ե̾ (filename:lineno) 
    if(filename != 0) {
        string            work(filename);
        string::size_type pos;

            //եѥ褿ûڤ
        pos = work.find_last_of("/\\");
        if(pos != string::npos)
            work.erase(0, pos + 1);

        buf << '(' << work;
        if(lineno != -1)
            buf << ':' << lineno;
        buf << ')';
    }
    current_description = buf.str();
    
        //¹Ԥɬפ̵ͭγǧ
    result = (target_session.empty() || current_session.find(target_session) != string::npos);

    if(result) {
        if(verbose) {
            string indent;
            indent.assign(2 * this->session.size(), ' ');
            (*out) << indent << '[' << session << "] " << current_description << endl;

            //(*out) << '[' << current_session << "] " << current_description << endl;
        }

        enter_session(session);
        ++ case_count;
    }

    return result;
}

    //ƥȥå̾ (ʥꥪץե) 
void TestSuiteControl::enter_session(const string & _session)
{   session.push_back(_session);   }

    //ƥȥå̾ (ʥꥪץե) β
void TestSuiteControl::leave_session(void)
{   session.pop_back();   }

    //ƥȥʥꥪμ
void TestSuiteControl::fail_in_suite(string msg)
{
    fail = true;
    (*out) << "Failed : [" << current_session << "]\n   " << current_description << endl;
    if(!msg.empty())
        (*out) << "     #" << msg << endl;
    ++ fail_count;
}


    //Ⱦ󥳥󥹥ȥ饯
TestSuite::SuiteContainerNode::SuiteContainerNode(const char * _session, SuiteFunction _suite) : session(_session), suite(_suite)
{}

    //Ⱦ󥳥󥹥ȥ饯
TestSuite::SuiteContainerNode::SuiteContainerNode(const SuiteContainerNode & src) : session(src.session), suite(src.suite)
{}

    //Ȥμ¹
bool TestSuite::SuiteContainerNode::invoke(TestSuiteControl & suite_control)
{
    if(suite != 0) {
        suite_control.enter_session(session);
        (*suite)(suite_control);
        suite_control.leave_session();
    }

    return !suite_control.is_failed();
}

/*
 *  ƥȥȼ¹ԥ饹
 */

    //󥹥ȥ饯
TestSuite::TestSuite(const char * session, SuiteFunction suite) : fail(false)
{   Singleton<SuiteContainer>::getInstance()->push_back(SuiteContainerNode(session, suite));   }


    //ǥȥ饯
TestSuite::~TestSuite(void)
{}


    //ƥȥȤμ¹  (ֵ:Ȥ¹Ԥɤ)
bool TestSuite::performTestSuite(int flags, const char * pattern)
{
    bool                        result;
    TestSuiteControl            suite_control(cerr, pattern);
    SuiteContainer *            container;
    SuiteContainer::iterator    scope;

        //¹ԥȥꥹȤλ
    container = Singleton<SuiteContainer>::getInstance();

        //Ĺ
    if( (flags & VERBOSE) != 0 )
        suite_control.set_verbose();

        //ϿȤμ¹
    scope = container->begin();
    while(scope != container->end()) {

        result = scope->invoke(suite_control);

            //ߤ or ̤Ǽ¹
        if( !result && (flags & THROUGH) == 0)
            break;

        ++ scope;
    }

        //顼ʤOKɽ
    if(!suite_control.is_failed())
        cerr << "OK (" << suite_control.countCases() << " passed)" << endl;
    else
        cerr << "Failed (" << suite_control.countFails() << '/' << suite_control.countCases() << ')' << endl;

    return !suite_control.is_failed();    //Ȥ˼¹ԤǤtrue
}


    //ϿƤȥåץ٥륹Ȥΰɽ
void TestSuite::listTestSuite(void)
{
    SuiteContainer::iterator  scope;
    int                       count;
    SuiteContainer *          container;

    count     = 0;
    container = Singleton<SuiteContainer>::getInstance();
    
    scope = container->begin();
    while(scope != container->end()) {
        cout << "  ";
        cout.width(3);
        cout << count << ':' << scope->getName() << endl;

        ++ count;
        ++ scope;
    }
    cout << "Total " << count << " sets of suite exist.\n";
}



/*
 *   åݥѴؿ
 */

bool TestSuite::isReached(std::string checkname)
{
    set<string>::iterator scope;

    scope = Singleton<Checkpoint>::getInstance()->find(checkname);

    return scope != Singleton<Checkpoint>::getInstance()->end();
}


/*
 *   ƥȥȼ¹Ѻȴؿ
 */

    //ե
bool TestSuite::compareFileContents(const char * filename, const char * filecontents, bool _remove)
{
    fstream file(filename,ios::in);
    int     ch;
    bool    result = true;

        //ƥå
    while(result && *filecontents != '\x0' && file.good()) {
        ch = file.get();

        if(ch != (int)*filecontents)
            result = false;

        ++ filecontents;
    }

        //EOFãƤ뤫
    if(result) {
        if(!file.good() || file.get() != EOF)
            result = false;
    }

    file.close();

    if(_remove)
        ::remove(filename);

    return result;
}

    
/*
    *   ƥȥȼ¹mainؿ
    */
int main(int argc, char ** argv)
{
    int    result;
    int    pos;
    int    flags;
    string category;

    flags = TestSuite::DEFAULT;

    for(pos = 1; pos < argc; ++ pos) {
        if(*argv[pos] == '-') {
            switch(argv[pos][1]) {
            case 'v': 
                flags |= TestSuite::VERBOSE;
                break;
            case 'V': 
                flags &= ~TestSuite::VERBOSE;
                break;
            case 't': 
                flags |= TestSuite::THROUGH;
                break;
            case 'T': 
                flags &= ~TestSuite::THROUGH;
                break;
            case 'l': 
                TestSuite::listTestSuite();
                return EXIT_SUCCESS;
            case 'h':
                cerr << "Usage : program (option) (suite)\n"
                            " -v, -V  : Verbose output on(-v) / off(-V)\n"
                            " -t, -T  : Go through with the suite, on(-t) / off(-T)\n"
                            " -l      : List the top level suites\n";
                return EXIT_SUCCESS;
            default:
                cerr << "Unknown option [" << argv[pos] << "]\n";
                return EXIT_FAILURE;
            }
        }
        else {
            if(!category.empty()) {
                cerr << "Two or more category specified.\n";
                return EXIT_FAILURE;
            }
            category.assign(argv[pos]);
        }
    }

    result = EXIT_FAILURE;
    if(TestSuite::performTestSuite(flags, category.c_str()))
        result = EXIT_SUCCESS;

#ifdef COVERAGE
    fstream fout("coverage.txt",ios::out);
    if(fout.is_open()) {
        Coverage::printCoverage(fout);
        fout.close();
    }
#endif

    return result;
}

#endif //TESTSUITE

