/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *                2003      by  Advanced Data Controls, Corp
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_timer.h,v 1.3 2003/12/19 11:24:18 honda Exp $
 */

/*
 *  CPU¸ޥ⥸塼Integratorѡ
 *  TMU0
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>
#include <integrator.h>

/*
 *  ޳ߤγֹ
 */
#define	INHNO_TIMER	IRQ_TM1_BIT

#ifndef _MACRO_ONLY

/*
 *  ͤɽη
 */
typedef UW	CLOCK;

/*
 *  ͤɽȥߥáñ̤ȤѴ
 *  TIMER_CLOCK ϥåȥܡ
 */
#define TO_CLOCK(nume, deno) (TIMER_CLOCK * (nume) / (deno))
#define TO_USEC(clock)       ((clock) * 1000 / TIMER_CLOCK)

/*
 *  ǤΥ޼ñ̤ɽ
 */
#define MAX_CLOCK	((CLOCK) 0xffffffff)
/*
 *  ޤθͤȯͤȤߤʤȽ
 */
#define GET_TOLERANCE	100
#define BEFORE_IREQ(clock) \
        ((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
hw_timer_initialize()
{
	CLOCK	cyc = TO_CLOCK(TIC_NUME, TIC_DENO);
        
	/*
	 *  ޴Ϣ
	 */
	/*  */
	sil_wrw_mem((VP)TM1_CTRL,TCTRL_STOP);
	/* ޾ͤΥå */
	assert(cyc <= MAX_CLOCK);       
	/* ߤΥꥢ  */
	sil_wrw_mem((VP)TM1_CTRL,0x01);
	sil_wrw_mem((VP)TM1_LOAD,cyc);
	/* ͤ򥻥å */
	sil_wrw_mem((VP)TM1_VAL,cyc);
	/* ȥ   */
        sil_wrw_mem((VP)TM1_CTRL,TCTRL_START);
	/* ߵ */    	
	sil_wrw_mem((VP)IRQ0_ENABLESET,IRQ_TM1);
}

/*
 *  ޳׵Υꥢ
 */
Inline void
hw_timer_int_clear()
{
  sil_wrw_mem((VP)TM1_CLR,0x01);    /* ڥǥ󥰥ӥåȤ򥯥ꥢ */
}

/*
 *  ޤ߽
 */
Inline void
hw_timer_terminate()
{
    /* ڥǥ󥰥ӥåȤ򥯥ꥢ */
    sil_wrw_mem((VP)TM1_CLR,0x01);    
    /*  */
    sil_wrw_mem((VP)TM1_CTRL,TCTRL_STOP);
    /* Ե*/
    sil_wrw_mem((VP)IRQ0_ENABLECLR,
	    sil_rew_mem((VP)IRQ0_ENABLECLR)&~IRQ_TM1);
}

/*
 *  ޤθͤɤߤ
 *
 *  ߶ػ߶ǸƤӽФȡ
 */
Inline CLOCK
hw_timer_get_current(void)
{
	return(TO_CLOCK(TIC_NUME, TIC_DENO) - sil_rew_mem((VP)TM1_VAL));
}

Inline BOOL
hw_timer_fetch_interrupt(void)
{
	return(sil_rew_mem((VP)IRQ0_STATUS) & IRQ_TM1);
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */



