/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  Copyright (C) 2005-2007 by Y.D.K.Co.,LTD Technologies company
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_support.S,v 1.2 2007/05/21 01:33:50 honda Exp $
 */

#define _MACRO_ONLY
#include "jsp_kernel.h"
#include <ns9360.h>

/* ץå⡼ */
Mode_SVC    =   0x13

/* ơ쥸bit */
I_Bit       =   0x80
F_Bit       =   0x40

/*  BBUS reset register */
BBUS_RESET_BASE     = 0x90600000


/*
 *  ٥Υåȥƥ¸ν
 *
 *  ȥåץ⥸塼ǡ˸ƤӽФ롥          
 */       

        .text
        .align 2
        .global hardware_init_hook
hardware_init_hook: 

/*
 * NS9360¸ν
 */
/*
 * bbus_reset
 */
        mov     r0, #0x0
        ldr     r0, =BBUS_RESET_BASE
        mov     r1, #0x0
        str     r1, [r0, #0]

/*
 * CSGPIO Initial
 */
        stmfd sp!, {r4 - r11,lr}   /* 쥸¸ */
        bl      cpu_CsGpioInit
        ldmfd sp!,{r4 - r11,lr}

/*----*/
init_done:
        mov     pc, lr


/*
 *
 *  ߤν
 *         
 */        
        .text
        .align 4    
        .global IRQ_Handler
IRQ_Handler:

        /* 
         * ߥ⡼ 
         * 
         * cpsrspsr_irq褬r14_irq(lp)ꡤ
         * spsr_irqr14_irqr13(sp)_irq r14,r13Ȥʤ롥
         */

        /* 
         *  ư⡼(ѡХ⡼)
         */
        mov     sp,#(CPSR_SVC | CPSR_FIQ_BIT | CPSR_IRQ_BIT) 
        msr     cpsr_all, sp
        stmfd   sp!, {r0-r3,ip,lr,pc} /* pcϥߡ */


        /*
         * spsrϤ뤿IRQ⡼ɤ
         */
        mov     r0,#(CPSR_IRQ | CPSR_FIQ_BIT | CPSR_IRQ_BIT)
        msr     cpsr,r0
        sub     r0,lr,#4
        mrs     r1,spsr
        

        /*
         *  ѡХ⡼ɤ
         */ 
        and     r2,  r1, #CPSR_FIQ_BIT /* FIQӥåȤηѾ */
        orr     r2,  r2, #(CPSR_SVC|CPSR_IRQ_BIT)
        msr     cpsr, r2
        str     r0, [sp,#0x18] /* Store pc */
        stmfd   sp!,{r1}       /* spsr */


        /*
         *  ¿ųߤȽ
         */
        ldr     r2, =interrupt_count
        ldr     r3, [r2]
        add     r0,r3,#1
        str     r0, [r2]
        cmp     r3, #0x00

        moveq   r2,sp            /* ͥȳߤǤʤ */
        ldreq   sp,=STACKTOP     /* åѹ    */
        stmeqfd sp!,{r2}         /* å¸ */

        /*
         *  װȽꡥ
         *  INT_IDɤ߹ߡ(ˤɬפϤʤ)
         */

        ldr     r3, =ISRADDR_REG
        ldr     r0, [r3]        /* ߥ٥ɤ߽Ф */

        /*
         *  ̤γߤå
         */
        cmp     r0, #0x00
        beq     undefined_interrupt
        
        /* 
         * ߵ 
         */
        mrs     r2, cpsr
        and     r2,  r2, #~CPSR_IRQ_BIT /* ߵ */
        msr     cpsr,r2

        /* 
         * Call Handler  
         */        
        mov     lr,  pc   
        mov     pc,  r0

        /* 
         * ߶ػ 
         */
        mrs     r2, cpsr
        and     r2,  r2, #CPSR_FIQ_BIT /* FIQӥåȤηѾ */         
        orr     r2,  r2, #(CPSR_SVC|CPSR_IRQ_BIT)
        msr     cpsr,r2

        /* 
         * ߥͥȲ(interrupt_count) ǥ 
         */
        ldr     r2, =interrupt_count
        ldr     r1, [r2]        
        sub     r3, r1, #1                        
        str     r3, [r2]
        cmp     r3, #0x00        
        bne     return_to_task_irq
        
        /*
         * ߥͥȤ̵ΤǡƤΥޥ򥯥ꥢ
         */
        ldr     r2,  =ISRADDR_REG
        str     r0,  [r2]       /* ߥޥꥢ */
        /* 
         * å 
         */
        ldmfd   sp!,{r0}         
        mov     sp, r0        
                
        ldr     r1, =reqflg    /* Check reqflg */
        ldr     r0, [r1]
        cmp     r0, #0
        beq     return_to_task_irq
        mov     r0, #0
        str     r0, [r1]       /* Clear reqflg */
        b       ret_int

return_to_task_irq:
        /*
         *  
         *  ߵĤȤʤ뤬ƥȾ¸Ƥ뤿ᡤ
         *  Ϥʤ
         */
        ldmfd   sp!,{r1}           /* CPSR */
        mrs     r2, cpsr           /* FIQѾ            */
        and     r2, r2, #CPSR_FIQ_BIT
        and     r1, r1, #~CPSR_FIQ_BIT
        orr     r1, r1, r2            
        msr     spsr, r1           
        ldmfd   sp!,{r0-r3,ip,lr,pc}^ /* + ߵ */

        /*
         *  ̤γߤäȤ˸ƤӽФ
         */    
undefined_interrupt:
         b      undef_interrupt
    

/*
 * åط
 * UW       cpuEnableICache( void );
 * UW       cpuEnableDCache( void );
 * UW       cpuEnableMMU( UW tlbaddr );
 * UW       cpuDCache_Line_Invalid( UW mva );
 * UW       cpuDCache_Line_Flush( UW mva );
 * UW       cpuDCache_Line_FlushInalid( UW mva );
 * UW       cpuDCache_DrainWriteBuffer( void );
 */


        .global cpuEnableICache, cpuEnableDCache
        .global cpuEnableMMU
        .global cpuDCache_Line_Invalid, cpuDCache_Line_Flush
        .global cpuDCache_Line_FlushInvalid, cpuDCache_DrainWriteBuffer


#define CP15_ICACHE     0x1000
#define CP15_DCACHE     0x0004
#define CP15_MMU        0x0001


/*
 * CP15-R1I-cache bit(b12)=1 ˤ롣
 * ʤ
 */
cpuEnableICache:
        mcr     p15, 0, r0, c7, c5, 0       /* ICache invalidate                */
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        nop
        mrc     p15, 0, r0, c1, c0, 0       /* CP15 R1                          */
        orr     r0, r0, #CP15_ICACHE        /* I-Cache enable                   */
        mcr     p15, 0, r0, c1, c0, 0       /* Set CP15 R1 I-cache              */
        mov     pc, lr


/*
 * CP15-R7Dcache invalidate »ܸCP15-R1D-cache bit(b2)=1ˤ롣
 * ʤ
 */
cpuEnableDCache:
        mcr     p15, 0, r0, c7, c6, 0       /* DC all invalidate                */
        mrc     p15, 0, r0, c1, c0, 0       /* CP15 R1                          */
        orr     r0, r0, #CP15_DCACHE        /* D-Cache enable                   */
        mcr     p15, 0, r0, c1, c0, 0       /* Set CP15 R1 D-cache              */
        mov     pc,lr


/*
 * CP15-R1MMU bit(bit0)=1ˤ롣TLBTBLɥ쥹˥뤹롣
 * r0:TLB address
 */
cpuEnableMMU:
        mcr     p15, 0, r0, c2, c0, 0       /* Set CP15 R2 TLB pointer          */
        mov     r0, #0                      /*                                  */
        mvn     r0, r0                      /* all domain is manager            */
        mcr     p15, 0, r0, c3, c0, 0       /* set Domain access (CP15 R3)      */

        mrc     p15, 0, r0, c1, c0, 0       /* CP15 R1                          */
        orr     r0, r0, #CP15_MMU           /* MMU enable                       */
        mcr     p15, 0, r0, c1, c0, 0       /* Set CP15 R1 MMU enable           */
        mov     pc,lr


/*
 * CP15-R7Invalidate DCache single entry(MVA)¹Ԥ롣
 * r0:MVA
 */
cpuDCache_Line_Invalid:
        mcr     p15, 0, r0, c7, c6, 1       /* DC invalidate single entry(MVA)  */
        mov     pc,lr


/*
 * CP15-R7Clean DCache single entry(MVA)¹Ԥ롣
 * r0:MVA
 */
cpuDCache_Line_Flush:
        mcr     p15, 0, r0, c7, c10, 1      /* DC clean single entry(MVA)       */
        mov     pc,lr


/*
 * CP15-R7Clean & Invalidate DCache single entry(MVA)¹Ԥ롣
 * r0:MVA
 */
cpuDCache_Line_FlushInvalid:
        mcr     p15, 0, r0, c7, c14, 1      /* DC clean single entry(MVA)       */
        mov     pc,lr


/*
 * CP15-R7Drain write buffer¹Ԥ롣
 */
cpuDCache_DrainWriteBuffer:
        mcr     p15, 0, r0, c7, c10, 4      /* Drain write buffer               */
        mov     pc,lr

