/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyritht (C) 2005- by Monami software, LP.
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id$
 */

/*
 *  ^C}W[ iLPC2214pj
 *  TIMER0gp
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>
#include <lpc2214.h>

/*
 *  ^C}݂̊ݔԍ
 */
#define    INHNO_TIMER    4

#ifndef _MACRO_ONLY

/*
 *  ^C}l̓\̌^
 */
typedef UW    CLOCK;

/*
 *  ^C}l̓\ƃ~bEʕbPʂƂ̕ϊ
 *  TIMER_CLOCK ̓^[Qbg{[hɐݒ
 */
#define TO_CLOCK(nume, deno)    (TIMER_CLOCK * (nume) / (deno))
#define TO_USEC(clock)      ((clock) * 1000 / TIMER_CLOCK)

/*
 *  ݒłő̃^C}iPʂ͓\j
 */
#define MAX_CLOCK    ((CLOCK) 0xffffffff)

/*
 *  ^C}̌ݒlݔO̒lƂ݂Ȃ̔f
 */
#define GET_TOLERANCE    100
#define BEFORE_IREQ(clock) \
        ((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)

/*
 *  ^C}̋N
 *
 *  ^C}CIȃ^C}ݗv𔭐D
 */
Inline void
hw_timer_initialize()
{
    UW	        wbits;
    CLOCK	cyc = TO_CLOCK(TIC_NUME, TIC_DENO);

    /*
     *  ݊֘A̐ݒ
     */

    /* 荞݃xݒ(\tgEFA) */
    define_ipm(INHNO_TIMER,-15);

    
    /* ݃Cl[u */
    sil_wrw_mem((VP)TIMER_T0TCR, 0);
    sil_wrw_mem((VP)TIMER_T0IR, 0xff);
    sil_wrw_mem((VP)TIMER_T0TC, 0);
    sil_wrw_mem(TIMER_T0PR, 0);
    sil_wrw_mem(TIMER_T0PC, 0);
    sil_wrw_mem(TIMER_T0MCR, (MCR_INT_MR0 | MCR_RST_MR0 | MCR_STP_MR0));
    sil_wrw_mem(TIMER_T0MR0, 3675);

    /* counter enabled. */
    sil_wrw_mem((VP)TIMER_T0TCR, 1);
}


/*
 *  ^C}ݗṽNA
 */
Inline void
hw_timer_int_clear()
{
    UW wbits;

    /* ݃NA */
    sil_wrw_mem((VP)TIMER_T0IR, 0xff);
    /* counter enabled. */
    sil_wrw_mem((VP)TIMER_T0TCR, 1);
}



/*
 *  ^C}̒~
 */
Inline void
hw_timer_terminate()
{
    UW wbits;

    /* ݃fBZ[u */
    /* TODO */

    sil_wrw_mem((VP)TIMER_T0IR, 0xff);
}


/*
 *  ^C}̌ݒl̓ǂ݂
 *
 *  ݋֎~ԒŌĂяoƁD
 */
Inline CLOCK
hw_timer_get_current(void)
{
    return(TO_CLOCK(TIC_NUME, TIC_DENO) -
           sil_rew_mem((VP)TIMER_T0TC));
}


Inline BOOL
hw_timer_fetch_interrupt(void)
{
  return sil_rew_mem((VP)TIMER_T0IR) & 1;
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
