/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005- by Monami software, LP.
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id$
 */

/*
 *    LPC2214 @\phCo
 */
#include <s_services.h>
#include <lpc2214.h>

/*
 * UARTp ȈSIOhCo
 */

/*
 *  VAI/O|[gubN
 */
typedef struct sio_port_initialization_block {

} SIOPINIB;

/*
 *  VAI/O|[gǗubN
 */
struct sio_port_control_block {
    const SIOPINIB  *siopinib; /* VAI/O|[gubN */
    VP_INT          exinf;     /* g */
    BOOL    openflag;          /* I[vς݃tO */
    BOOL    sendflag;          /* M݃Cl[utO */
    BOOL    getready;          /* M */
    BOOL    putready;          /* 𑗐Mł */
};

/*
 * VAI/O|[gubN
 */
const SIOPINIB siopinib_table[TNUM_SIOP] = {{}};

/*
 *  VAI/O|[gǗubÑGA
 */
SIOPCB  siopcb_table[TNUM_SIOP];

/*
 *  VAI/O|[gIDǗubNo߂̃}N
 */
#define INDEX_SIOP(siopid)  ((UINT)((siopid) - 1))
#define get_siopcb(siopid)  (&(siopcb_table[INDEX_SIOP(siopid)]))


/*
 * M?
 */ 
Inline BOOL
uart_getready(SIOPCB *siopcb)
{
    return (sil_rew_mem(UART_LSR) & 0x01) != 0;
}

/*
 * 𑗐Mł邩?
 */
Inline BOOL
uart_putready(SIOPCB *siopcb)
{
    return (sil_rew_mem(UART_LSR) & 0x20) != 0;
}

/*
 *  M̎o
 */
Inline UB
uart_getchar(SIOPCB *siopcb)
{
    return (UB)sil_rew_mem(UART_RBR);  
}

/*
 *  M镶̏
 */
void
uart_putchar(SIOPCB *siopcb, UB c)
{
    sil_wrw_mem(UART_THR, (VW)c);
}

/*
 *  M݋
 */
Inline void
uart_enable_send(SIOPCB *siopcb)
{
    VW wbits;
    wbits = sil_rew_mem(UART_IER);
    wbits |= UART_INT_T;
    sil_wrw_mem(UART_IER,wbits);
}

/*
 *  M݋֎~
 */
Inline void
uart_disable_send(SIOPCB *siopcb)
{
    VW wbits;
    wbits = sil_rew_mem(UART_IER);
    wbits &= ~UART_INT_T;
    sil_wrw_mem(UART_IER,wbits);
}

/*
 *  M݋
 */
Inline void
uart_enable_rcv(SIOPCB *siopcb)
{
    VW wbits;
    wbits = sil_rew_mem(UART_IER);
    wbits |= UART_INT_R;
    sil_wrw_mem(UART_IER,wbits);
}

/*
 *  M݋֎~
 */
Inline void
uart_disable_rcv(SIOPCB *siopcb)
{
    VW wbits;
    wbits = sil_rew_mem(UART_IER);
    wbits &= ~UART_INT_R;
    sil_wrw_mem(UART_IER,wbits);
}



/*
 * J[lÑOo͗p̏
 */
void
uart_init(void){
    UW wbits;
    UH devisor;

#if 0
    /*
     *  GP34`41  FFUART Ƃėp
     */
    wbits = sil_rew_mem(GPIO_GAFR0_y);
    wbits = (wbits & 0xfff0000f) | 0x000a9550;
    sil_wrw_mem(GPIO_GAFR0_y, wbits);

    /*
     *  TXD, RTS/RTS o͂ɂ
     */
    wbits = sil_rew_mem(GPIO_GPDR_y);
    wbits = (wbits & 0xfffffc7f) | 0x00000380;
    sil_wrw_mem(GPIO_GPDR_y, wbits);
    
    /*
     * RS232C hCon[hEFÃCl[u
     */
    wbits = sil_rew_mem(CQ_PXA250_CONFIG);
    wbits |= 0x200;
    sil_wrw_mem(CQ_PXA250_CONFIG, wbits);
#endif

    /*
     *  UART_BPS 14ȉ̂ƂA
     *  ZʂI[ot[B
     *  ۂɂȐlɂ邱Ƃ
     *  肦ȂÔ߁B
     */
#if (UART_BPS < 15)
#error UART_BPS is too small or undefined.
#endif

    devisor = 921600 / UART_BPS;

    sil_wrw_mem(UART_LCR, 0x80);
    sil_wrw_mem(UART_DLL, devisor & 0xff);
    sil_wrw_mem(UART_DLH, (devisor >> 8) & 0xff);
    sil_wrw_mem(UART_LCR, 0x3);
    sil_wrw_mem(UART_FCR, 0x1);
    sil_wrw_mem(UART_MCR, 0x3);
    sil_wrw_mem(UART_IER, 0x40);
}


/*
 *  I`bvUART̃|[Oo
 */
void
uart_putc(char c)
{
    UW buf_level;
    
    while((sil_rew_mem(UART_LSR) & 0x20) == 0) {
	/* spin lock */
    }
    
    sil_wrw_mem(UART_THR,(VW)c);
}

/*
 *  SIOhCȍ[`
 *  1|[gȂ߁C܂Ӗ͂Ȃ
 */
void
uart_initialize()
{
    SIOPCB  *siopcb;
    UINT    i;

    /*
     *  VAI/O|[gǗubN̏
     */
    for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
        siopcb->siopinib = &(siopinib_table[i]);
        siopcb->openflag = FALSE;
        siopcb->sendflag = FALSE;
    }
}

/*
 * I[vĂ|[g邩
 */
BOOL
uart_openflag(void)
{
    return(siopcb_table[0].openflag);
}


/*
 * VAI/O|[g̃I[v
 */
SIOPCB *
uart_opn_por(ID siopid, VP_INT exinf)
{
    SIOPCB      *siopcb;
    const SIOPINIB  *siopinib;

    siopcb = get_siopcb(siopid);
    siopinib = siopcb->siopinib;

    uart_init();
    
    siopcb->exinf = exinf;
    siopcb->getready = siopcb->putready = FALSE;
    siopcb->openflag = TRUE;

    /* clear FIFO  TxThr = 0 RxThr = 1*/
    sil_wrw_mem(UART_FCR,(VW)(UART_FCR_TC | UART_FCR_RC));
  
    /* set interrupt */
    sil_wrw_mem(UART_IER, 0x42);

    return(siopcb);
}

/*
 *  VAI/O|[g̃N[Y
 */
void
uart_cls_por(SIOPCB *siopcb)
{
    siopcb->openflag = FALSE;
}

/*
 *  VAI/O|[gւ̕M
 */
BOOL
uart_snd_chr(SIOPCB *siopcb, char c)
{
    if (uart_putready(siopcb)){
        uart_putchar(siopcb, c);
        return(TRUE);
    }
    return(FALSE);
}

/*
 *  VAI/O|[g̕M
 */
INT
uart_rcv_chr(SIOPCB *siopcb)
{
    if (uart_getready(siopcb)) {
        return((INT)(UB) uart_getchar(siopcb));
    }
    return(-1);
}

/*
 *  VAI/O|[g̃R[obN̋
 */
void
uart_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
    switch (cbrtn) {
        case SIO_ERDY_SND:
            uart_enable_send(siopcb);
            break;
        case SIO_ERDY_RCV:
            uart_enable_rcv(siopcb);
            break;
    }
}


/*
 *  VAI/O|[g̃R[obN̋֎~
 */
void
uart_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
    switch (cbrtn) {
        case SIO_ERDY_SND:
            uart_disable_send(siopcb);
            break;
        case SIO_ERDY_RCV:
            uart_disable_rcv(siopcb);
            break;
    }
}



/*
 *  VAI/O|[gɑ΂銄ݏ
 */
static void
uart_isr_siop(SIOPCB *siopcb)
{
    if (uart_getready(siopcb)) {
        /*
         *  MʒmR[obN[`ĂяoD
         */
        uart_ierdy_rcv(siopcb->exinf);
    }
    if (uart_putready(siopcb)) {
        /*
         *  M\R[obN[`ĂяoD
         */
        uart_ierdy_snd(siopcb->exinf);
    }
}


/*
 *  SIO̊݃T[rX[`
 */
void
uart_isr()
{
	sil_wrw_mem((VP *)0xe002800c, 0x40000000);

    uart_isr_siop(&(siopcb_table[0]));
}

