/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  L쌠҂́Cȉ (1)`(4) ̏CFree Software Foundation 
 *  ɂČ\Ă GNU General Public License  Version 2 ɋL
 *  qĂ𖞂ꍇɌC{\tgEFAi{\tgEFA
 *  ς̂܂ށDȉjgpEEρEĔzziȉC
 *  pƌĂԁj邱Ƃ𖳏ŋD
 *  (1) {\tgEFA\[XR[ȟ`ŗpꍇɂ́CL̒
 *      \C̗pщL̖ۏ؋K肪Ĉ܂܂̌`Ń\[
 *      XR[hɊ܂܂Ă邱ƁD
 *  (2) {\tgEFACCu`ȂǁC̃\tgEFAJɎg
 *      pł`ōĔzzꍇɂ́CĔzzɔhLgip
 *      ҃}jAȂǁjɁCL̒쌠\C̗pщL
 *      ̖ۏ؋Kfڂ邱ƁD
 *  (3) {\tgEFAC@ɑgݍނȂǁC̃\tgEFAJɎg
 *      płȂ`ōĔzzꍇɂ́Ĉꂩ̏𖞂
 *      ƁD
 *    (a) ĔzzɔhLgip҃}jAȂǁjɁCL̒
 *        쌠\C̗pщL̖ۏ؋Kfڂ邱ƁD
 *    (b) Ĕzž`ԂCʂɒ߂@ɂāCTOPPERSvWFNg
 *        񍐂邱ƁD
 *  (4) {\tgEFA̗pɂ蒼ړI܂͊ԐړIɐ邢Ȃ鑹
 *      QCL쌠҂TOPPERSvWFNgƐӂ邱ƁD
 * 
 *  {\tgEFÁCۏ؂Œ񋟂Ă̂łDL쌠҂
 *  TOPPERSvWFNǵC{\tgEFAɊւāC̓Kp\
 *  ܂߂āCȂۏ؂sȂD܂C{\tgEFA̗pɂ蒼
 *  ړI܂͊ԐړIɐȂ鑹QɊւĂC̐ӔC𕉂ȂD
 * 
 *  @(#) $Id$
 */

/*
 *    ^[QbgVXeˑW[iEZARM7pj
 */

#include "jsp_kernel.h"
#include <lpc2214.h>



void
hardware_init_hook()
{
    extern int __ivector_end;
    int i;
    VB *sram;

    sram = (VB *)0x40000000;
    /*
     *  Remap vector to Static RAM.
     */
    for(i = 0; i < 0x40; i++) {
      sram[i] = *((VB *)i);
    }
    sil_wrw_mem((VP)(0xe01fc040), 2);
}

/*
 *  ^[QbgVXeˑ̏
 */
void
sys_initialize()
{
    int i;

    sil_wrw_mem((VP *)(0xfffff034), undef_interrupt);

    /*
     *  ARM̃xN^e[u֊݃nho^
     */
    arm_install_handler(IRQ_Number,IRQ_Handler);
  
    /*
     *  sys_putc \ɂȂ悤UART
     */
    uart_init();
}


/*
 *  ^[QbgVXȅI
 */
void
sys_exit(void)
{
    syslog(LOG_EMERG, "End Kernel.....!");
    while(1);
}




/*
 *  ^[QbgVXe̕o
 */
void
sys_putc(char c)
{
    if (c == '\n') {
        uart_putc('\r');
    }
  uart_putc(c);  
}


/*
 *  ݃nh̐ݒ
 *
 *  ݔԍ inhno ̊݃nh̋NԒn inthdr ɐݒ肷D
 */
void
define_inh(INHNO inhno, FP inthdr)
{
    VW *base;
    assert(inhno < MAX_INT_NUM);

    base = (VW *)(0xfffff100);
    sil_wrw_mem((VP *)(&base[inhno]), inthdr);
    sil_wrw_mem((VP *)0xfffff010, 1 << inhno);

    base = (VW*)0xfffff200;
    sil_wrw_mem((VP *)&(base[inhno]), inhno | 0x20);
}


/*
 * ݗDxݒD
 */
void
define_ipm(INHNO inhno, PRI pri)
{
    VW *base;

    assert(inhno < MAX_INT_NUM);
#if 0
    base = (VW*)0xfffff200;
    if (pri == 0) {
	sil_wrw_mem((VP *)&(base[inhno]), 0);
    } else {
	pri = 16 + pri;
	assert(0 <= pri && pri <= 15);
	sil_wrw_mem((VP *)&(base[inhno]), pri | 0x20);
    }
#endif
}


void
dis_int(INHNO inhno)
{
  sil_wrw_mem((VP *)0xfffff014, 1 << inhno);
}

void
ena_int(INHNO inhno)
{
  sil_wrw_mem((VP *)0xfffff010, 1 << inhno);
}



/*
 *  `݂̊ꍇ̏
 */
void
undef_interrupt(){
    syslog(LOG_EMERG, "Unregistered Interrupt occurs.");
    while(1);
}
