/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2006 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005-2006 by Logic Research Co., Ltd.
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 */


#define _MACRO_ONLY
#include "jsp_kernel.h"
#include "frk_aduc.h"


        /*
         * Vectorơ֥ȥץơ֥
         * Ϲ0x3c
         */
        .section .data.vctsram,"a"
        .code 32
        .align 0
        .global vct_tb_sram
vct_tb_sram:
        ldr pc, reset_vector       /* ꥻå             */
        ldr pc, undef_vector       /* ̤̿           */
        ldr pc, swi_vector         /* եȥ   */
        ldr pc, prefech_vector     /* ץեåܡ */
        ldr pc, data_abort_vector  /* ǡܡ       */
         nop
        ldr pc, irq_vector         /* IRQ                  */
        ldr pc, fiq_vector         /* IRQ                  */

/*
 *  ٥ơ֥
 */
reset_vector:
        .long   start
undef_vector:
        .long   undef_exception
swi_vector:
        .long   swi_exception
prefech_vector:
        .long   prefetch_exception
data_abort_vector:
        .long   data_abort_exception
irq_vector:
        .long   irq_exception
fiq_vector:
        .long   fiq_exception




/*
 *  ٥Υåȥƥ¸ν
 *
 *  ȥåץ⥸塼ǡ˸ƤӽФ롥          
 */       

        .text
        .align 2
        .global hardware_init_hook
hardware_init_hook: 
        mov     pc, lr


        .text
        .align 2
        .global software_init_hook
software_init_hook:
        mov     pc, lr

        .text
        .align 2
        .global software_term_hook
software_term_hook:
        mov     pc, lr


/*
 *
 *  ߤν
 *         
 */        
        .text
        .align 4    
        .global IRQ_Handler
IRQ_Handler:

        /* 
         * ߥ⡼ 
         * 
         * cpsrspsr_irq褬r14_irq(lp)ꡤ
         * spsr_irqr14_irqr13(sp)_irq r14,r13Ȥʤ롥
         */

        /* 
         *  ư⡼(ѡХ⡼)
         */
        mov   sp,#(CPSR_SVC | CPSR_FIQ_BIT | CPSR_IRQ_BIT) 
        msr   cpsr_all, sp
        stmfd sp!, {r0-r3,ip,lr,pc} /* pcϥߡ */

 
  
        /*
         * spsrϤ뤿IRQ⡼ɤ
         */
        mov   r0,#(CPSR_IRQ | CPSR_FIQ_BIT | CPSR_IRQ_BIT)
        msr   cpsr,r0
        sub   r0,lr,#4
        mrs   r1,spsr
   
        /*
         *  ѡХ⡼ɤ
         */
        and   r2,  r1, #CPSR_FIQ_BIT /* FIQӥåȤηѾ */
        orr   r2,  r2, #(CPSR_SVC|CPSR_IRQ_BIT)        
        msr   cpsr_all, r2
        str   r0, [sp,#0x18] /* Store pc */
        stmfd sp!,{r1}       /* spsr */


        /*
         *  ¿ųߤȽ
         */
        ldr     r2, =interrupt_count
        ldr     r3, [r2]
        add     r0,r3,#1
        str     r0, [r2]
        cmp     r3, #0x00

        moveq   r2,sp            /* ͥȳߤǤʤ */
        ldreq   sp,=STACKTOP     /* åѹ    */
        stmeqfd sp!,{r2}         /* å¸ */


        /*
         *  װȽꡥ
         */
        ldr     r1, =IRQSTA

		ldr     r0, =IRQEN
		ldr     r2, [r0]
		stmfd   sp!, {r2}			/* ޥӥåȤ */

        ldr     r2, [r1]
        mov     r0, #1
		mov		r3, #1
find_bit_loop:
        mov     r1, r3, lsl r0
        tst     r2, r1
        bne     find_bit_end   
        add     r0, r0, #1
        bpl     find_bit_loop
find_bit_end:
        mov     r3, r0
        ldr     r0,=int_mask_table    /* ߥޥơ֥θƤӽФ*/
        ldr     r0,[r0,r3,lsl #2]     /* r0<-ߥޥ              */    
        ldr     r1, =IRQCLR			  /* ߥ쥸ؤΥå      */
        str     r0,[r1]

        ldr     r0,  =int_table       /* ߵơ֥ɤ߽Ф  */
        ldr     r0,  [r0,r3,lsl #2]   /* r0<-ߥϥɥ            */    


        /*
         *  ̤γߤå
         */
        cmp     r0, #0x00
        beq     undefined_interrupt
        
        /* 
         * ߵ 
         */                
        mrs     r2, cpsr
        and     r2,  r2, #~CPSR_IRQ_BIT /* ߵ */
        msr     cpsr,r2

        /* 
         * Call Handler  
         */        
        mov     lr,  pc   
        bx      r0

        /* 
         * ߶ػ 
         */
        mrs     r2, cpsr
        and     r2,  r2, #CPSR_FIQ_BIT /* FIQӥåȤηѾ */         
        orr     r2,  r2, #(CPSR_SVC|CPSR_IRQ_BIT)
        msr     cpsr,r2

        ldmfd   sp!, {r0}                /* ޥӥåȤ */
        ldr     r1,  =IRQEN        /*ߵ*/
        str     r0,  [r1]

        /* 
         * ߥͥȲ(interrupt_count) ǥ 
         */
        ldr     r2, =interrupt_count
        ldr     r1, [r2]        
        sub     r3, r1, #1                        
        str     r3, [r2]
        cmp     r3, #0x00        
        bne     return_to_task_irq
        
        /* 
         * å 
         */
        ldmfd   sp!,{r0}         
        mov     sp, r0        
                
        ldr     r1, =reqflg    /* Check reqflg */
        ldr     r0, [r1]
        cmp     r0, #0
        beq     return_to_task_irq
        mov     r0, #0
        str     r0, [r1]       /* Clear reqflg */
        b       ret_int

return_to_task_irq:
        /*
         *  
         *  ߵĤȤʤ뤬ƥȾ¸Ƥ뤿ᡤ
         *  Ϥʤ
         */
        ldmfd   sp!,{r1}           /* CPSR */
        mrs     r2, cpsr           /* FIQѾ            */
        and     r2, r2, #CPSR_FIQ_BIT
        and     r1, r1, #~CPSR_FIQ_BIT
        orr     r1, r1, r2                 
        msr     spsr, r1           /* ߵ   */
        ldmfd   sp!,{r0-r3,ip,lr,pc}^ /* + ߵ */

        /*
         *  ̤γߤäȤ˸ƤӽФ
         */    
undefined_interrupt:
         b      undef_interrupt
    

