/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2010 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id: hw_serial.c,v 1.12 2007/03/23 07:22:15 honda Exp $
 */

/*
 *  åȰ¸ꥢI/O⥸塼H8ѡ
 *    ݡȤ 1ܤξ HWPORT1_ADDR˻ꤵ줿ݡȤѤ
 *      2ܤξϡHWPORT1_ADDR桼ѡHWPORT2_ADDR򥳥󥽡
 *      ϤȤƻѤ롣
 *      HWPORTx_ADDR åȰ¸ sys_config.hǻꤹ롣
 *    Υ⥸塼ˤäơXON/XOFFե椬Ԥ
 *      ƤΤǡTxDRxD2ܤǤ褤
 */

#include "jsp_kernel.h"
#include <hw_serial.h>
#include <h8_sil.h>

/*
 *  ܡ졼Ȥ1ӥåʬλ[nsec]Ѵޥ
 *  黻ǥСեʤ褦longѤƤ
 */
#define BAUD_TO_NSEC(b)       (UINT)(((1000000ul / (b)) + 1ul) * 1000ul)

/*
 *  ܡ졼ȤBRRͤѴޥ
 */
#define H8BRR_RATE(b)	(((b)>38400)?((UB)(((CPU_CLOCK+(16*(b)))/(32*(b)))-1))\
			          :((UB)((CPU_CLOCK/(32*(b)))-1)))

/*
 *  ꥢݡȤν֥å
 */

static const SIOPINIB siopinib_table[TNUM_PORT] = {
	{
		SYSTEM_SCI,
		SYSTEM_BAUD_RATE,
                {
                        (UB*)SYSTEM_SCI_IPR,
                        SYSTEM_SCI_IP_BIT,
                        SYSTEM_SCI_IPM
                },
		SYSTEM_SCI_SMR
	}

#if TNUM_PORT >= 2
	,{
		USER_SCI,
		USER_BAUD_RATE,
                {
                        (UB*)USER_SCI_IPR,
                        USER_SCI_IP_BIT,
                        USER_SCI_IPM
                },
		USER_SCI_SMR
	}
#endif	/* of #if TNUM_PORT >= 2 */

#if TNUM_PORT >= 3
	,{
		USER2_SCI,
		USER2_BAUD_RATE,
                {
                        (UB*)USER2_SCI_IPR,
                        USER2_SCI_IP_BIT,
                        USER2_SCI_IPM
                },
		USER2_SCI_SMR
	}
#endif	/* of #if TNUM_PORT >= 3 */

};


/*
 *  ꥢݡȤ֥å
 */

SIOPCB siopcb_table[TNUM_PORT];

/*
 *  SIO ID ֥åؤѴޥ
 */

#define get_siopinib(sioid)	(&(siopinib_table[INDEX_SIO(sioid)]))

/*
 *  SCI ν
 */

void
SCI_initialize (ID sioid)
{
	const SIOPINIB	*inib;

	inib = get_siopinib(sioid);
	SCI_cls_por(inib->base);
			/*
			 *⡼
			 *ĴƱ
			 *饯Ĺ
			 *ѥƥ
			 *ȥåץӥåĹ
			 *å
			 */
	sil_wrb_mem((VP)(inib->base + H8SMR), inib->smr_init);

					/*  ܡ졼  	*/
	sil_wrb_mem((VP)(inib->base + H8BRR), H8BRR_RATE(inib->baudrate));

			/* ߶ػߤȥå	*/
	h8_anb_reg((UB *)(inib->base + H8SCR),
            	    (UB)~(H8SCR_TIE  | H8SCR_RIE  | H8SCR_MPIE |
            	          H8SCR_TEIE | H8SCR_CKE1 | H8SCR_CKE0 ));

	/* ܡ졼Ȥ塢1ӥåʬԤʤФʤʤ*/
	sil_dly_nse(BAUD_TO_NSEC(inib->baudrate));

					/* 顼ե饰򥯥ꥢ		*/
	h8_anb_reg((UB *)(inib->base + H8SSR),
	            ~(H8SSR_ORER | H8SSR_FER | H8SSR_PER));

        /*
         *  ץ饤ƥ٥
         *      ϳߥȥ¸ʬʬΥ٤
         */
	define_int_plevel(&(inib->irc));

	/* ߤߤεĤϥꥢ I/O ǹԤ */
	/*  */
	h8_orb_reg((VP)(inib->base + H8SCR), (H8SCR_TE | H8SCR_RE));
}

/*
 *  SCI Υ
 */

void
SCI_cls_por (UW base)
{
#ifndef HEW_SIMULATOR
	/* TDRE  1 ˤʤޤԤ */
	while ((sil_reb_mem((VP)(base + H8SSR)) & H8SSR_TDRE) == 0)
		;

	/* 11ӥåʬԤġ*/
	sil_dly_nse(11*BAUD_TO_NSEC(H8_MIN_BAUD_RATE));
#endif	/* HEW_SIMULATOR */
					/* 		*/
	h8_anb_reg((UB *)(base + H8SCR),
	           (UB)~(H8SCR_TIE | H8SCR_RIE | H8SCR_TE | H8SCR_RE));
}

/*
 *  SCI_in_handler -- SCI ϳߥϥɥ
 */

void
SCI_in_handler(ID sioid)
{
	SIOPCB	*pcb;
	VP	p_ssr;
	UB	status;
	
	pcb = get_siopcb(sioid);
	p_ssr = (VP)(pcb->inib->base + H8SSR);
	status = sil_reb_mem(p_ssr);
	
#if 0	/*  ȥ  */
	/*
	 *  SIO顼ߥӥ롼Ǥʤ
	 *  Ǥ⥨顼åԤäƤͳ
	 *  ʲΥ󥹤ꤷƤ뤿ᡣ
	 *  ʥ쥢ΤᡢȥȤƤ롣
	 *  
	 *  ꥢߡˤȯߥϥɥ餬ư롣
	 *  ߽¿ųߤꡢꥢα롣
	 *  㡧޳
	 *  ˥ǡ㤨СХ󥨥顼ȯ
	 *  γ߽λγ߽롣
	 *  κݡꥢΥ顼ե饰Ωä֤ǡ
	 *  辰μߤγߥϥɥ餬¹Ԥ롣
	 */
	if (status & (H8SSR_ORER | H8SSR_FER | H8SSR_PER)) {

		/* 顼		*/

	    	/* 顼ե饰򥯥ꥢ	*/
		sil_wrb_mem(p_ssr,
		            status & ~(H8SSR_ORER | H8SSR_FER | H8SSR_PER));
	}
#endif

	if (status & H8SSR_RDRF) {
		if (pcb->openflag) {
			/* ǽХå롼ƽФ*/
			SCI_ierdy_rcv(pcb->exinf);
		} else {
			sil_wrb_mem(p_ssr, status & ~H8SSR_RDRF);
		}
	}
}

/*
 *  SCI_out_handler -- SCI ϳߥϥɥ
 */

void
SCI_out_handler(ID sioid)
{
	SIOPCB	*pcb;

	pcb = get_siopcb(sioid);
	if (pcb->openflag) {
		/* ǽХå롼ƽФ*/
		SCI_ierdy_snd(pcb->exinf);
	}
}

#ifdef H8_CFG_SCI_ERR_HANDLER

/*
 *  SCI_err_handler -- SCI 顼ϳߥϥɥ
 */

void
SCI_err_handler(ID sioid)
{
	SIOPCB	*pcb;
	VP	p_ssr;
	UB	status;

	pcb = get_siopcb(sioid);
	p_ssr = (VP)(pcb->inib->base + H8SSR);
	status = sil_reb_mem(p_ssr);
	if (status & (H8SSR_ORER | H8SSR_FER | H8SSR_PER)) {

		/* 顼		*/

	    	/* 顼ե饰򥯥ꥢ	*/
		sil_wrb_mem(p_ssr,
		            status & ~(H8SSR_ORER | H8SSR_FER | H8SSR_PER));
	}
}

#endif	/* of #ifdef H8_CFG_SCI_ERR_HANDLER */

/*
 *  sio_initialize -- ꥢݡȥɥ饤Фν
 */

void
sio_initialize (void)
{
	int ix;

	/* SIO ֥åν */
	for (ix = TNUM_PORT; ix -- > 0; ) {
		siopcb_table[ix].inib     = &siopinib_table[ix];
		siopcb_table[ix].openflag = FALSE;
	}
}

/*
 *  sio_ena_cbr -- ꥢ I/O ΥХåε
 */

void
sio_ena_cbr(SIOPCB *pcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:
		SCI_enable_send(pcb);
		break;
	case SIO_ERDY_RCV:
		SCI_enable_recv(pcb);
		break;
	}
}

/*
 *  sio_dis_cbr -- ꥢ I/O ΥХåζػ
 */

void
sio_dis_cbr(SIOPCB *pcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:
		SCI_disable_send(pcb);
		break;
	case SIO_ERDY_RCV:
		SCI_disable_recv(pcb);
		break;
	}
}

/*
 *  SCI 
 */

void
sio_in_handler (void)
{
	SCI_in_handler(1);
}

void
sio_out_handler (void)
{
	SCI_out_handler(1);
}

#ifdef H8_CFG_SCI_ERR_HANDLER

void
sio_err_handler (void)
{
	SCI_err_handler(1);
}

#endif	/* of #ifdef H8_CFG_SCI_ERR_HANDLER */

#if TNUM_PORT >= 2

void
sio_in2_handler (void)
{
	SCI_in_handler(2);
}

void
sio_out2_handler (void)
{
	SCI_out_handler(2);
}

#ifdef H8_CFG_SCI_ERR_HANDLER

void
sio_err2_handler (void)
{
	SCI_err_handler(2);
}

#endif	/* of #ifdef H8_CFG_SCI_ERR_HANDLER */
#endif	/* of #if TNUM_PORT >= 2 */

#if TNUM_PORT >= 3

void
sio_in3_handler (void)
{
	SCI_in_handler(3);
}

void
sio_out3_handler (void)
{
	SCI_out_handler(3);
}

#ifdef H8_CFG_SCI_ERR_HANDLER

void
sio_err3_handler (void)
{
	SCI_err_handler(3);
}

#endif	/* of #ifdef H8_CFG_SCI_ERR_HANDLER */

#endif	/* of #if TNUM_PORT >= 3 */

