/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *  Copyright (C) 2001-2007 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _H8S_SIL_H_
#define _H8S_SIL_H_

#ifndef _MACRO_ONLY
#include <sil.h>
#endif /* _MACRO_ONLY */

/*
 *  H8S쥸󥿥ե
 *١ɥ쥹H8S_BASE_ADDRh8s.h
 *CPUư⡼ɤˤꡢȤʬ롣
 */

/*
 *  ١ɥ쥹βû
 *UHǥ㥹ȤƤΤϡĤΰ̣롣
 *16ӥåȤФ
 *ûκݤĥɤ
 */
#define ADD_BASE_ADDR(addr)	(VP)(H8S_BASE_ADDR + (UW)(UH)(addr))

/*  쥸ؤΥ  */
#define h8s_reb_reg(addr)	sil_reb_mem(ADD_BASE_ADDR(addr) )
#define h8s_wrb_reg(addr, val)	sil_wrb_mem(ADD_BASE_ADDR(addr), (VB)(val))

#define h8s_reh_reg(addr)	sil_reh_mem(ADD_BASE_ADDR(addr) )
#define h8s_wrh_reg(addr, val)	sil_wrh_mem(ADD_BASE_ADDR(addr), (VH)(val))

/*
 *  黻
 */
#define h8s_orb_reg(addr, val)	h8s_wrb_reg(addr, h8s_reb_reg(addr) | (val))
#define h8s_andb_reg(addr, val) h8s_wrb_reg(addr, h8s_reb_reg(addr) & (val))

#define h8s_orh_reg(addr, val)	h8s_wrh_reg(addr, h8s_reh_reg(addr) | (val))
#define h8s_andh_reg(addr, val)	h8s_wrh_reg(addr, h8s_reh_reg(addr) & (val))

#endif /* _H8S_SIL_H_ */
