/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.h,v 1.9 2003/12/24 07:24:40 honda Exp $
 */

/*
 *	ץå¸⥸塼Linuxѡ
 */

#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  ͥ̾Υ͡
 */
#include <cpu_rename.h>

#ifndef _MACRO_ONLY

/*
 *  Linuxɸ।󥯥롼ɥե
 */

#include <signal.h>
#include <setjmp.h>

/*
 *  chg_ims/get_ims 򥵥ݡȤ뤫ɤ
 */
#define	SUPPORT_CHG_IMS

/*
 *  TCB Ϣ
 *
 *  cpu_context.h 쥬ȤȤΰ¸δطǡ
 *  cpu_context.h ˤʤ
 */

/*
 *  TCB ΥեɤΥӥå
 */
#define	TBIT_TCB_PRIORITY	8	/* priority եɤΥӥå */
#define	TBIT_TCB_TSTAT		8	/* tstat եɤΥӥå */

/*
 *  ƥȥ֥å
 */
typedef struct task_context_block {
	jmp_buf env;		/* CPUƥ */
} CTXB;

/*
 *   CPU㳰ϥɥ
 */

#define EXCHNO_ZDIV  SIGFPE

/*
 *  ƥֻ
 */


Inline int
current_stack()
{
    struct sigaltstack      ss;

    sigaltstack(((void *)0), &ss);
    return(ss.ss_flags & SS_ONSTACK);
}


Inline BOOL
sense_context()
{
	return(current_stack());
}

Inline BOOL
sense_lock()
{
    sigset_t currentSet;
    
    sigprocmask(SIG_BLOCK, ((void *)0), &currentSet);

#if defined(linux) & (defined(i386) | defined(_i386_) | defined(__i386__))
    if(currentSet.__val[0] == ~(0 | (1<<(SIGKILL-1)) | (1<<(SIGSTOP-1)))
       &&  currentSet.__val[1] == ~0 )
        return(TRUE);
    else
        return(FALSE);
#else
    
#error not supported.
    
#endif /* linux */    
}


#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock

/*
 *  CPUåȤβʥƥѡ
 *
 *  task_intmask ϡchg_ipm 򥵥ݡȤ뤿ѿchg_ipm 򥵥ݡ
 *  Ȥʤˤϡtask_intmask  0 ˤʤäƤȹͤФ褤
 */

#ifdef SUPPORT_CHG_IMS
extern IMS	task_sigmask;	/* ƥȤǤγߥޥ */
#endif /* SUPPORT_CHG_IMS */

Inline void
t_lock_cpu()
{
    sigset_t  newmask;
    
    sigfillset(&newmask);
    sigprocmask(SIG_SETMASK,&newmask,0);
}

Inline void
t_unlock_cpu()
{
#ifdef SUPPORT_CHG_IMS
	/*
	 *  t_unlock_cpu ƤӽФΤ CPUå֤ΤߤǤ뤿
	 *  ᡤ task_intmask 񤭴뤳ȤϤʤ
	 */
    sigprocmask(SIG_SETMASK,&task_sigmask,0);
#else /* SUPPORT_CHG_IMS */
    sigset_t  mask;
    
    sigemptyset(&mask);
    sigprocmask(SIG_SETMASK,&mask,0);
#endif /* SUPPORT_CHG_IMS */
}

/*
 *  CPUåȤβ󥿥ƥѡ
 */

extern IMS	int_sigmask;	/* 󥿥ƥȤǤγߥޥ */

Inline void
i_lock_cpu()
{
    sigset_t  mask;
    
    sigfillset(&mask);
    sigprocmask(SIG_SETMASK,&mask,&int_sigmask);
}

Inline void
i_unlock_cpu()
{
    sigprocmask(SIG_SETMASK,&int_sigmask,0);
}

/*
 *  ǥѥå
 */

/*
 *  ǹ̥ͥؤΥǥѥå
 *
 *  dispatch ϡƥȤƤӽФ줿ӥ
 *  ǡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void	dispatch();


/*
 *  ߤΥƥȤΤƤƥǥѥå
 *
 *  exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */

extern void    exit_and_dispatch(void);

/*
 *  ߥϥɥ顿CPU㳰ϥɥ
 */


/*
 *  ߥϥɥ
 *
 *  ٥ȥֹ inhno γߥϥɥεưϤ inthdr ꤹ롥
 */

Inline void
define_inh(INHNO inhno, FP inthdr)
{
    /*
     *  SIGUSR1֥ååڤؤͭϿ롣
     *  ͥ٤դϥޥӥåȤꤹ
     *  ɬפΤǤˡϻȤʤ
     */
    
    struct sigaction action;

    action.sa_handler = inthdr;
    sigemptyset(&action.sa_mask);
    sigaddset(&action.sa_mask,SIGUSR1);
    action.sa_flags = SA_ONSTACK;
    
    sigaction(inhno, &action, 0);    
}

/*
 *  CPU㳰ϥɥ
 *
 *  ٥ȥֹ excno CPU㳰ϥɥεưϤ exchdr ꤹ롥
 */
Inline void
define_exc(EXCNO excno, FP exchdr)
{
    /*
     * ֥åޥ̵åڤؤͭϿ롣
     */
    struct sigaction action;

    action.sa_handler = exchdr;
    sigemptyset(&action.sa_mask);
    sigaddset(&action.sa_mask,SIGUSR1);    
    action.sa_flags = SA_ONSTACK;    
    sigaction(excno, &action, 0);
}

/*
 *  ߥϥɥ顿CPU㳰ϥɥν
 */

/*
 *  ߥϥɥνޥ
 *
 *  ʥ뤬ȯԤƤȥʥ륹å˼ưŪڤؤ롣
 *  ƤγߥϥɥϥǥѥåưSIGUSR1ޥ
 *  ư롣ΤreqflgΥå奷ʥ뤬ȯԤƵư줿
 *  ϥɥǥǥѥå׵ᤵƤư
 */


#define	INTHDR_ENTRY(inthdr)      \
void inthdr##_entry(void){        \
     inthdr();                           /* ߥϥɥƤӽФ */ \
     if(_kernel_reqflg)                  /* regflg TRUEǤ      */ \
       raise(SIGUSR1);                   /* ǥѥåƤӽФ   */ \
}                                      

#define INT_ENTRY(inthdr)   inthdr##_entry


/*
 *  CPU㳰ϥɥνޥ
 *
 *  ʥ뤬ȯԤƤȥʥ륹å˼ưŪڤؤ롣 
 *  ƤCPU㳰ϥɥϥǥѥåưSIGUSR1ޥ
 *  ư롣ΤreqflgΥå奷ʥ뤬ȯԤƵư줿
 *  ϥɥǥǥѥå׵ᤵƤư 
 */
#define	EXCHDR_ENTRY(exchdr)	  \
void exchdr##_entry(VP sp){        \
     exchdr(sp);                         /* ߥϥɥƤӽФ */ \
     if(_kernel_reqflg)                  /* regflg TRUEǤ      */ \
       raise(SIGUSR1);                   /* ǥѥåƤӽФ   */ \
}

#define EXC_ENTRY(exchdr) exchdr##_entry

/*
 *  CPU㳰ȯΥƥ֤λ
 */

/*
 *  CPU㳰ȯΥǥѥå
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
	return((*((UH *) p_excinf) & 0x1000) == 0);
}

/*
 *  CPU㳰ȯCPUå֤λ
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	return((*((UH *) p_excinf) & 0x0700) == 0x0700);
}


/*
 *  ץå¸ν
 */
extern void	cpu_initialize(void);

/*
 *  ץå¸νλ
 */
extern void	cpu_terminate(void);

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */







