/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _MIPS3_H_
#define _MIPS3_H_

#include <util.h>

/*
 *  MIPS3 
 */

/* CPU쥸̾ */
#define zero    $0      /*  */
#define at      $1      /* ֥Υƥݥ */
#define v0      $2      /* ؿ */
#define v1      $3
#define a0      $4      /* ؿΰ */
#define a1      $5
#define a2      $6
#define a3      $7
#define t0      $8      /* ƥݥ쥸 tx (x=0-9)ؿƤӽФ˲ */
#define t1      $9
#define t2      $10
#define t3      $11
#define t4      $12
#define t5      $13
#define t6      $14
#define t7      $15
#define s0      $16     /* sx (x=0-7) : ؿƤӽФѤʥ쥸 */
#define s1      $17
#define s2      $18
#define s3      $19
#define s4      $20
#define s5      $21
#define s6      $22
#define s7      $23
#define t8      $24     /* ƥݥ쥸 tx (x=0-9)ؿƤӽФ˲ */
#define t9      $25
#define k0      $26     /* OSѤͽѤ */
#define kt0     $26
#define k1      $27
#define kt1     $27
#define gp      $28     /* ѿΰΥ١ɥ쥹 */
#define sp      $29     /* åݥ */
#define fp      $30     /* ե졼ݥ */
/* ⤷ */
#define s8      $30     /* s8 : ؿƤӽФѤʥ쥸 */
#define ra      $31     /* ؿꥢɥ쥹 */

/* CP0쥸̾ */
#define Index           $0
#define Random          $1
#define EntryLo0        $2
#define EntryLo1        $3
#define Context         $4
#define PageMask        $5
#define Wired           $6
#define Error           $7
#define BadVAddr        $8
#define Count           $9
#define EntryHi         $10
#define Compare         $11
#define Status          $12
#define Cause           $13
#define EPC             $14
#define PRId            $15
#define Config          $16
#define LLAddr          $17
#define WatchLo         $18
#define WatchHi         $19
#define XContext        $20
/* $21-$24 - ͽ */
#define Performance     $25
#define ParityErr       $26
#define CacheErr        $27
#define TagLo           $28
#define TagHi           $29
#define ErrorEPC        $30
/* $31 - ͽ */

/*  饤󥢥֥ǻȤ  */
#define str_k0		"$26"
#define str_Status	"$12"

/*  ơ쥸ط  */
#define SR_IE		BIT0			/*  IEӥå  */
#define SR_EXL		BIT1			/*  EXLӥå  */
#define SR_ERL		BIT2			/*  ERLӥå  */

#define SR_EXL_IE	(SR_EXL | SR_IE)	/*  EXL,IEӥå  */
#define SR_ERL_EXL	(SR_ERL | SR_EXL)	/*  ERL,EXLӥå  */
#define SR_ERL_EXL_IE	(SR_ERL_EXL | SR_IE)	/*  ERL,EXL,IEӥå  */
#define SR_IM		0xff00			/*  IMӥåȤФޥ  */

#define SR_UX		BIT5			/*  UXӥå  */
#define SR_SX		BIT6			/*  SXӥå  */
#define SR_KX		BIT7			/*  SXӥå  */
#define SR_DE		BIT16			/*  DEӥå  */
#define SR_SR		BIT20			/*  SRӥå  */
#define SR_BEV		BIT22			/*  BEVӥå  */
#define SR_RE		BIT25			/*  REӥå  */
#define SR_CU0		BIT28			/*  CU0ӥå  */
#define SR_CU1		BIT29			/*  CU1ӥå  */
#define SR_CU2		BIT30			/*  CU2ӥå  */
#define SR_XX		BIT31			/*  XXӥå  */

/*  쥸ط  */
#define Cause_IP0       BIT8    /*  IP0ӥå  */
#define Cause_IP1       BIT9    /*  IP1ӥå  */
#define Cause_IP2       BIT10   /*  IP2ӥå  */
#define Cause_IP3       BIT11   /*  IP3ӥå  */
#define Cause_IP4       BIT12   /*  IP4ӥå  */
#define Cause_IP5       BIT13   /*  IP5ӥå  */
#define Cause_IP6       BIT14   /*  IP6ӥå  */
#define Cause_IP7       BIT15   /*  IP7ӥå  */

/*  ߤФIPӥåȤ̾  */
#define Cause_Int0	Cause_IP2  /*  Int0׵ӥå  */
#define Cause_Int1	Cause_IP3  /*  Int1׵ӥå  */
#define Cause_Int2	Cause_IP4  /*  Int2׵ӥå  */
#define Cause_Int3	Cause_IP5  /*  Int3׵ӥå  */
#define Cause_Int4	Cause_IP6  /*  Int4׵ӥå  */

/*  쥸鸶ɤФޥ  */
#define ExcCode_mask    0x7c

/* 㳰 */
#define Int     0       /* 㳰 */
#define Mod     1       /* TLBѹ㳰 */
#define TLBL    2       /* TLB԰㳰 (ɤޤ̿եå) */
#define TLBS    3       /* TLB԰㳰 (ȥ) */
#define AdEL    4       /* ɥ쥹顼㳰 (ɤޤ̿եå) */
#define AdES    5       /* ɥ쥹顼㳰 (ȥ) */
#define IBE     6       /* Х顼㳰 (̿եå) */
#define DBE     7       /* Х顼㳰 (ǡΥɤޤϥȥ) */
#define Sys     8       /* ƥॳ㳰 */
#define Bp      9       /* ֥쥤ݥ㳰 */
#define RI      10      /* ͽ̿㳰 */
#define CpU     11      /* ץåԲ㳰 */
#define Ov      12      /* 黻Сե㳰 */
#define Tr      13      /* ȥå㳰 */
/* 14 - ͽ */
#define FPE     15      /* ư㳰 */
/* 16-22 - ͽ */
#define WATCH   23      /* å㳰 */
/* 24-31 - ͽ */

/*  װֹ  */
#define INTNO_IP0               0
#define INTNO_IP1               1
#define INTNO_IP2               2
#define INTNO_IP3               3
#define INTNO_IP4               4
#define INTNO_IP5               5
#define INTNO_IP6               6
#define INTNO_IP7               7

/*  γߤܿʥեȥߤޤ */
#define TMAX_CORE_INTNO		8

/*
 *  MIPS3Υơ쥸ǽʺǹߵĥӥåȥѥ
 */
#define MAX_IPM  0xff

/*
 *  MIPS3ꤹߥޥΥå
 */
#define CHECK_CORE_IPM(ipm)  CHECK_PAR(0 <= (ipm) && (ipm) <= MAX_IPM)

/*
 *  CPU㳰μ
 */
#define TMAX_CORE_EXCNO	32u

/*
 *  ϻΥå¤
 *    cpu_config.hˤcpu_experrؿcpu_support.S򻲾ȤΤȡ
 */
#ifndef _MACRO_ONLY

typedef struct exc_stack {

	/*  쥸  */
	UW	sp;
	UW	at;
	UW	v0;
	UW	v1;
	UW	a0;
	UW	a1;
	UW	a2;
	UW	a3;
	UW	t0;
	UW	t1;
	UW	t2;
	UW	t3;
	UW	t4;
	UW	t5;
	UW	t6;
	UW	t7;
	UW	t8;
	UW	t9;
	UW	gp;
	UW	fp;
	UW	ra;

	UW	CP0_Status;
	UW	CP0_EPC;

	UW	hi;
	UW	lo;

} EXCSTACK;

#endif /* _MACRO_ONLY */

#endif /* _MIPS3_H_ */
