OUTPUT_FORMAT("elf32-littlemips","elf32-littlemips","elf32-littlemips")
OUTPUT_ARCH(mips)

MEMORY
{
	ROM0(rxai):ORIGIN = 0xa0000000, LENGTH =      0x700	/* kseg0 */
	ROM1(rxai):ORIGIN = 0xa0000700, LENGTH =   2M-0x700	/* kseg0 */
	RAM(wxai) :ORIGIN = 0xa0200000, LENGTH =  14M		/* kseg0 */
		/* SDRAM κǽ餫äƤʤΤϡǽ2MBʬ
		   ROM Υߥ顼Ѥ˳ݤ뤿 */
}

PROVIDE(_stack_top = 0);
PROVIDE(hardware_init_hook = 0);
PROVIDE(software_init_hook = 0);
PROVIDE(software_term_hook = 0);

SECTIONS
{
	_stack_top = 0xac03fffc;	/* = 0xac040000 - 0x4 (SRAM) ; kseg0 */

	.exce_vec_map :
	{
		*(.exce_vec_map)
	} > ROM0

	.reset 0xa0000400 :		/* åʤɤޤ */
	{
		*(.reset)
	} > ROM0

	.text :
	{
		_stext = . ;
		*(.text)
		_etext  = . ;
	} > ROM1

	.rodata :
	{
		*(.rodata)
	} > ROM1

	__idata_start = .;
	.data :
	AT ( __idata_start )
	{
		__data_start  = . ;
		*(.data)
	} > RAM

	/* ͳɤʬʤɤ⡢񤯤ΤŪ餷 */
	_gp = . + 0x8000;

	/* sdata  chk ǰäΤǡα
	   ѥˡ-G 0 ץ򤱤Ƥޤ */

	__isdata_start = .;
	.sdata :
	AT ( __isdata_start + SIZEOF(.data) )
	{
		*(.lit8) 
		*(.lit4) 
		*(.sdata) 
	} > RAM

	__idata_end = __idata_start + SIZEOF(.data) + SIZEOF(.sdata);

	__bss_start = .	;
	.sbss : 
	{
		_fbss = . ;
		*(.sbss)
		*(.scommon)
	} > RAM

	.bss : 
	{
		*(.bss)
		*(COMMON)
		__bss_end = .;
		_end = . ;
	} > RAM

	PROVIDE (end = .);

	.comment 	0 : { *(.comment) }
	.debug          0 : { *(.debug) }
	.line           0 : { *(.line) }
	.debug_srcinfo  0 : { *(.debug_srcinfo) }
	.debug_sfnames  0 : { *(.debug_sfnames) }
	.debug_aranges  0 : { *(.debug_aranges) }
	.debug_pubnames 0 : { *(.debug_pubnames) }
}

PROVIDE(memcpy = _dummy_memcpy);
