/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _VR4131_ICU_H_
#define _VR4131_ICU_H_

/*
 *  ߥȥ(ICU)ط
 */

/*  ֹ0-7֤ mips3.h ǻѡ8ְʹߤꤹ롣 */
/*  SYSINT1REG  */
#define INTNO_BAT        8	/*  Хåƥ  */
#define INTNO_POWER      9	/*  ѥå  */
#define INTNO_RTCL1     10	/*  RTCLong1  */
#define INTNO_ETIME     11	/*  ElipsedTime޳ */
#define INTNO_GIU       12	/*  GIU  */
#define INTNO_SIU       13	/*  SIU  */
#define INTNO_SOFTINT   14	/*  եȥ  */
#define INTNO_CLKRUN    15	/*  CLKRUN  */

/*  SYSINT2REG  */
#define INTNO_RTCL2     16	/*  RTCLong2  */
#define INTNO_LED       17	/*  LED  */
#define INTNO_TCLK      18	/*  TClock󥿳  */
#define INTNO_FIR       19	/*  FIR  */
#define INTNO_DSIU      20	/*  DSIU  */
#define INTNO_PCI       21	/*  PCI  */
#define INTNO_SCU       22	/*  SCU  */
#define INTNO_CSI       23	/*  CSI  */
#define INTNO_BCU       24	/*  BCU  */

/*  ߥȥ餬ߤܿ  */
#define TMAX_ICU_INTNO	17u

/*  ߥȥΥ쥸Υɥ쥹  */
/* ʲ xxx_asmxxx_offset ϡ֥ǤѸ */
#define ICU_BASE_ADDR		0x0f000000
#define ICU_BASE_ADDR_asm	ASM_SIL( ICU_BASE_ADDR )

#define SYSINT1_offset		0x80
#define MSYSINT1_offset		0x8c
#define MDSIUINT_offset		0x96
#define SYSINT2_offset		0xa0
#define MSYSINT2_offset		0xa6

#define MSYSINT1REG	(ICU_BASE_ADDR + MSYSINT1_offset)
				/* ƥߥޥ쥸1(٥1) */
#define MDSIUINTREG	(ICU_BASE_ADDR + MDSIUINT_offset)
				/* DSIUߥޥ쥸(٥2)  */
#define MSYSINT2REG	(ICU_BASE_ADDR + MSYSINT2_offset)
				/* ƥߥޥ쥸2(٥1) */

/*  װӥåȥѥ (֥ʬǤѤƤ롣) */
/* MSYSINT1REG / SYSINT1REG ط */
#define CLKRUNINTR	BIT12	/* CLKRUN  */
#define SOFTINTR	BIT11	/* եȥ */
#define SIUINTR		BIT9	/* SIU  */
#define	GIUINTR		BIT8	/* GIU()  */
#define	ETIMERINTR	BIT3	/* ElapsedTime  */
#define RTCL1INTR	BIT2	/* RTCLong1  */
#define POWERINTR	BIT1	/* ѥå */
#define BATINTR		BIT0	/* Хåƥ */

/* MSYSINT2REG / SYSINT2REG ط */
#define BCUINTR		BIT9	/* BCU  */
#define CSIINTR		BIT8	/* CSI  */
#define SCUINTR		BIT7	/* SCU  */
#define PCIINTR		BIT6	/* PCI  */
#define DSIUINTR	BIT5	/* DSIU  */
#define FIRINTR		BIT4	/* FIR  */
#define TCLKINTR	BIT3	/* VTClock  */
#define LEDINTR		BIT1	/* LED  */
#define RTCL2INTR	BIT0	/* RTCLong2  */

/* MDSIUINTREG ط */
#define INTDSIU  	BIT11	/* DSIUѲߵ */

/*
 *  ߥȥγߥޥط
 */

/*  ¤ICU_IPMΥեåȤ뤿Υޥmakeoffset.cѤ
    ʤΥޥͤϡäѤƤʤ*/
#define OFFSET_DEF_ICU_IPM	OFFSET_DEF(ICU_IPM, msysint2)

/*  MSYSINT1,2ꤷƤϤʤӥå  */
#define NG_BIT_MSYSINT1	(BIT4 | BIT5 | BIT6 | BIT7 | BIT10 | BIT13 |BIT14 | BIT15)
#define NG_BIT_MSYSINT2	(BIT2 | BIT10 | BIT11 | BIT12 | BIT13 | BIT14 | BIT15)

/*  ߥȥꤹߥޥΥå  */
#define CHECK_ICU_IPM(ipm)						\
		CHECK_PAR(!(ipm.msysint1 & NG_BIT_MSYSINT1));		\
		CHECK_PAR(!(ipm.msysint2 & NG_BIT_MSYSINT2))

#ifndef _MACRO_ONLY

/*  ߥȥФߥޥεơ֥  */
extern ICU_IPM icu_intmask_table[];

/*  ߥȥintmaskơ֥  */
Inline void icu_set_ilv(INTNO intno, ICU_IPM *ipm) {
	/* CHECK_ICU_IPM(ipm) ϡ̥롼Ǽ¹ԺѤ */
	icu_intmask_table[intno].msysint1 = ipm->msysint1;
	icu_intmask_table[intno].msysint2 = ipm->msysint2;
}

/*  ߥȥΥޥ  */
Inline void icu_set_ipm(ICU_IPM *ipm) {
	/* CHECK_ICU_IPM(ipm) ϡ̥롼Ǽ¹ԺѤ */
	vr4131_wrh_mem( (VP) MSYSINT1REG, ipm->msysint1 );
	vr4131_wrh_mem( (VP) MSYSINT2REG, ipm->msysint2 );
}

/*  ߥȥΥޥ  */
Inline void icu_get_ipm(ICU_IPM *ipm) {
	ipm->msysint1 = vr4131_reh_mem( (VP) MSYSINT1REG );
	ipm->msysint2 = vr4131_reh_mem( (VP) MSYSINT2REG );
}

#endif /* _MACRO_ONLY */

/*============================================================================*/
/*  ֥ط  */

/*  ߵĥӥåȤ  */
/*  ߥȥICUIPM򥹥å¸  */
#define PUSH_ICU_IPM						\
    li      t1, ICU_BASE_ADDR_asm;				\
    addi    sp, sp, -2*2;					\
    lh      t3, MSYSINT1_offset(t1);	/* t3 = MSYSINT1REG */	\
    lh      t4, MSYSINT2_offset(t1);	/* t4 = MSYSINT2REG */	\
    sh      t3, (sp);						\
    sh      t4, 2(sp)

/*  ߥȥICUIPM򥹥å  */
#define POP_ICU_IPM							      \
    li      t1, ICU_BASE_ADDR_asm;					      \
    lw      t3, (sp);			/* t3 = MSYSINT2REG:MSYSINT1REG */    \
					/* աȥ륨ǥ¸ */    \
    sh      t3, MSYSINT1_offset(t1);	/* MSYSINT1REG = t3β2Х*/    \
    srl     t4, t3, 16;							      \
    sh      t4, MSYSINT2_offset(t1);	/* MSYSINT2REG = t3ξ2Х*/    \
    addi    sp, sp, 2*2

/*  ߥȥICUIPM  */
/*      t0˳װֹ椬ä֤ǸƤФ  */
/*      t0ƤƤϤʤ  */
/*      t1˳׵᥯ꥢäƤΤ˲ƤϤʤʤ  */
#define SET_ICU_IPM							      \
    la      t4, icu_intmask_table;	/* ǡơ֥Ƭɥ쥹 */    \
    sll     t2, t0, 2;			/* եåȡװֹ4 */ \
    li      t3, ICU_BASE_ADDR_asm;					      \
    add     t4, t4, t2;			/* Ƭɥ쥹ܥեå */        \
    lw      t5, (t4);			/* t5 = MSYSINT2REG:MSYSINT1REG */    \
					/* աȥ륨ǥ¸ */    \
    sh      t5, MSYSINT1_offset(t3);	/* MSYSINT1REG = t5β2Х */   \
    srl     t6, t5, 16;							      \
    sh      t6, MSYSINT2_offset(t3)	/* MSYSINT2REG = t5ξ2Х */

/*  ǥХ̾̽Ÿޥ
      װ t0  proc_END   */
#define MAKE_PROC(device)	\
proc_##device:			\
    li      t0, INTNO_##device;	\
    j       proc_END;		\
    nop;

/*  װȽ  */
/*    ߥȥMIPS3Int0³ƤޥΥå */
#define PROC_INT0						\
/*  ޤα夲뤿ᡢSYSINT2REGĴ٤  */	\
    li      t1, ICU_BASE_ADDR_asm;				\
    lh      t3, SYSINT2_offset(t1);    /* t3 = SYSINT2REG */	\
    lh      t4, MSYSINT2_offset(t1);   /* t4 = MSYSINT2REG */	\
    and     t5, t3, t4;     /*  ׵ӥåȤ˥ޥ  */	\
    beq     t5, zero, proc_SYSINT1;				\
    andi    t6, t5, (BIT0 | BIT1 | BIT2 | BIT3 | BIT4 );	\
    beq     t6, zero, proc_SYSINT2_HIGH_5BIT;			\
								\
/*  SYSINT2REG (b0:4) ν  */				\
    andi    t7, t5, ( RTCL2INTR | LEDINTR );			\
    beq     t7, zero, proc_SYSINT2_BIT3_4;			\
    andi    t8, t5, LEDINTR;					\
    beq     t8, zero, proc_LED;					\
MAKE_PROC(RTCL2);						\
MAKE_PROC(LED);							\
								\
proc_SYSINT2_BIT3_4:						\
    andi    t1, t5, TCLKINTR;					\
    beq     t1, zero, proc_FIR;					\
MAKE_PROC(TCLK);						\
MAKE_PROC(FIR);							\
								\
/*  SYSINT2REG (b5:9) ν  */				\
proc_SYSINT2_HIGH_5BIT:						\
    andi    t7, t5, (DSIUINTR | PCIINTR);			\
    beq     t7, zero, proc_SYSINT2_BIT7_7;			\
    andi    t2, t5, DSIUINTR;					\
    beq     t2, zero, proc_PCI;					\
MAKE_PROC(DSIU);						\
MAKE_PROC(PCI);							\
								\
proc_SYSINT2_BIT7_7:						\
    andi    t3, t5, SCUINTR;					\
    beq     t3, zero, proc_SYSINT2_BIT8_9;			\
MAKE_PROC(SCU);							\
								\
proc_SYSINT2_BIT8_9:						\
    andi    t4, t5, CSIINTR;					\
    beq     t4, zero, proc_BCU;					\
MAKE_PROC(CSI);							\
MAKE_PROC(BCU);							\
								\
/*  SYSINT1REGΥå  */					\
/*  t1ICU_BASE_ADDRä֤Ǥ  */		\
proc_SYSINT1:							\
    lh      t3, SYSINT1_offset(t1);	/* t3 = SYSINT1REG */	\
    lh      t4, MSYSINT1_offset(t2);	/* t4 = MSYSINT1REG */	\
    and     t5, t3, t4;     /*  ׵ӥåȤ˥ޥ  */	\
    andi    t6, t5, 0xff;					\
    beq     t6, zero, proc_SYSINT1_HIGH_BYTE;			\
								\
/*  SYSINT1REG (̥Х) ν  */				\
    andi    t7, t5, (BATINTR | POWERINTR);			\
    beq     t7, zero, proc_SYSINT1_BIT2_3;			\
    andi    t8, t5, BATINTR;					\
    beq     t8, zero, proc_POWER;				\
MAKE_PROC(BAT);							\
MAKE_PROC(POWER);						\
								\
proc_SYSINT1_BIT2_3:						\
    andi    t1, t5, ETIMERINTR;					\
    beq     t1, zero, proc_ETIME;				\
MAKE_PROC(RTCL1);						\
MAKE_PROC(ETIME);						\
								\
/*  SYSINT1REG (̥Х) ν  */				\
proc_SYSINT1_HIGH_BYTE:						\
    andi    t8, t5, (GIUINTR | SIUINTR);			\
    beq     t8, zero, proc_SYSINT1_BIT11_12;			\
    andi    t9, t5, GIUINTR;					\
    beq     t9, zero, proc_SIU;					\
MAKE_PROC(GIU);							\
MAKE_PROC(SIU);							\
								\
proc_SYSINT1_BIT11_12:						\
    andi    t1, t5, SOFTINTR;					\
    beq     t1, zero, proc_CLKRUN;				\
MAKE_PROC(SOFTINT);						\
MAKE_PROC(CLKRUN);						\
								\
proc_END:

/*============================================================================*/

/* ߽˴ؤ롢װȽʬΥƥ¸ */

	/*  ƤӽФ줿Ȥ       */
	/*    a1˥ơ쥸 */
	/*    a2˸쥸       */
	/*  ͤäƤ         */

#define PROC_INTERRUPT_SYS							\
	and     t2, a2, a1;          /*  ׵ӥåȤ˥ޥ򤫤  */	\
	andi    t3, t2, Cause_IP0;   /*  IP0ӥåȼФ  */			\
	bne     t3, zero, proc_IP0;						\
	andi    t4, t2, Cause_IP1;   /*  IP1ӥåȼФ  */			\
	bne     t4, zero, proc_IP1;						\
	andi    t5, t2, Cause_IP2;   /*  IP2ӥåȼФ  */			\
	bne     t5, zero, proc_IP2;						\
	andi    t6, t2, Cause_IP3;   /*  IP3ӥåȼФ  */			\
	bne     t6, zero, proc_IP3;						\
	andi    t7, t2, Cause_IP4;   /*  IP4ӥåȼФ  */			\
	bne     t7, zero, proc_IP4;						\
	nop;									\
	/* VR4131ξ硢Cause_IP5Cause_IP6̤³ʤΤǾά */		\
	/*ʥϡɥp196ȡ*/						\
										\
	/* ʤ餫θʬǤʤ */					\
	j       join_interrupt_and_exception;					\
	nop;									\
										\
										\
/*  MIPS3٥ʬ٥Ǥν		*/			\
/*    װֹ t0 			*/			\
/*    ׵᥯ꥢΤ t1 	*/			\
/*    set_ICU_IPM 				*/			\
proc_IP7:   /*  װIP7ʥޡˤξ  */				\
	xori    t1, zero, Cause_IP7;						\
	j       set_ICU_IPM;							\
	ori     t0, zero, INTNO_IP7;						\
										\
proc_IP0:   /*  װIP0ʥեȥ0ˤξ  */			\
	xori    t1, zero, Cause_IP0;						\
	j       set_ICU_IPM;							\
	ori     t0, zero, INTNO_IP0;						\
										\
proc_IP1:   /*  װIP1ʥեȥ1ˤξ  */			\
	xori    t1, zero, Cause_IP1;						\
	j       set_ICU_IPM;							\
	ori     t0, zero, INTNO_IP1;						\
										\
proc_IP2:   /*  װIP2Int0ˤξ  */					\
            /*  ֤٤ƤγߡפΤ롣*/				\
	PROC_INT0;	/* ʬ vr4131_icu.h ǥޥƤ */	\
	xori    t1, zero, Cause_IP2;						\
	j       set_ICU_IPM;							\
	nop;									\
										\
proc_IP3:   /*  װIP3Int1ˤξ  */ 				\
            /*  rtc_long1_intrסʥ󥿡Х륿ޡˤΤ롣*/	\
	xori    t1, zero, Cause_IP3;						\
	j       set_ICU_IPM;							\
	ori     t0, zero, INTNO_IP3;						\
										\
proc_IP4:   /*  װIP4Int2ˤξ  */ 				\
            /*  rtc_long2_intrסʥ󥿡Х륿ޡˤΤ롣*/	\
	xori    t1, zero, Cause_IP4;						\
	j       set_ICU_IPM;							\
	ori     t0, zero, INTNO_IP4;						\
										\
/*  ߥȥ¸Υޥ  */					\
set_ICU_IPM:									\
										\
	SET_ICU_IPM;	/* ߥޥꤹޥ			    */	\
			/*   ԤȤˤϡˤt0t1Ѥ */	\
			/*   ˲ʤ褦ˡդʤФʤʤ   */	\
										\
/*  쥸IPӥåȤݻƤƼߤγ׵򥯥ꥢ롣	\
    t1ˤϡ׵ӥåȤȿžΤäƤ롣 */			\
										\
	mfc0    t8, Cause;							\
	and     t8, t8, t1;							\
	mtc0    t8, Cause;							\
										\
/*  ơ쥸ΥޥC롼ƤӽФ  */			\
/*    t0˳װֹ椬ꤵ줿֤Ǥ  */			\
	la      t3, int_table;   /* ٥ɥ쥹 */			\
	sll     t4, t0, 3;       /* װֹ8				\
				      INT_TABLEϡ				\
					ϥɥΥɥ쥹(4Х)		\
					MIPS3γߥޥ(4Х)	\
				      Ρ8Хȡ */			\
	add     t5, t3, t4;      /* ٥ɥ쥹򻻽 */			\
	lw      t6, INT_TABLE_intmask(t5);					\
           		    	/*  IPM(ߵĥӥå)ɤ߽Ф		\
				    ߥޥʳͤϡ			\
					IEӥåȤϥå			\
					EXLӥåȤϥꥻå			\
				    ֤ˤʤäƤ롣*/			\
	lw      t7, (t5);        /* C롼Ƭɥ쥹ɤ߽Ф  */	\
										\
	jalr    ra, t7;          /* C롼ƤӽФ  */			\
	mtc0    t6, Status;      /* ߵġơ쥸Υޥ*/\
										\
	mfc0    t0, Status;							\
	ori     t0, t0, SR_EXL;  /* ߶ػߡIEӥåȤͤݻʤФʤ\
						ʤΤEXLӥåȤѤ롣*/	\
	mtc0    t0, Status;							\
										\
	/*  CP0ϥɤΤλֲԤ  */					\
	NOP_FOR_CP0_HAZARD;

#endif /* _VR4131_ICU_H_ */
