/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _PIC_ICU_H_
#define _PIC_ICU_H_

#ifndef _MACRO_ONLY
#include <sil.h>
#endif /* _MACRO_ONLY */

#include <rte_vr5500_cb.h>	/* ICU_BASE_ADDR */

/*
 *  ߥȥ(Programable Interrupt Controler)ط
 */

/*  ֹ0-7mips3.hǻѡ8ʹߤꤹ롣 */
#define INTNO_TIMER0	 8	/*  ޣ      */
#define INTNO_SERIAL0	 9	/*  ꥢ룰    */
#define INTNO_GBUS	10	/*  GBUS-INT0-    */
#define	INTNO_BUS_ERR	11	/*  BUS_ERROR     */
#define	INTNO_TIMER1	12	/*  ޣ      */
#define INTNO_SERIAL1	13	/*  ꥢ룱    */
#define INTNO_PARALEL	14	/*  ѥ      */
#define INTNO_DMAC	15	/*  DMAC_INTREQ-  */

/*  ߥȥ餬ߤܿ  */
#define TMAX_ICU_INTNO	8u

/*  ߥȥΥ쥸Υɥ쥹  */
/* ʲxxx_offsetϡ֥ǻȤ */
#define INT0M_offset	0x00
#define INT1M_offset	0x10
#define INTR_offset	0x20
#define INTEN_offset	0x30

#define ICU_INT0M	INT0M_offset
#define ICU_INT1M	INT1M_offset
#define ICU_INTR	INTR_offset
#define ICU_INTEN	INTEN_offset

/*  װӥåȥѥ (֥ʬǤѤƤ롣) */
#define TIMER0		BIT0
#define SERIAL0		BIT1
#define GBUS		BIT2
#define	BUS_ERR		BIT3
#define	TIMER1		BIT4
#define SERIAL1		BIT5
#define PARALEL		BIT6
#define DMAC		BIT7

/* ICUΥ쥸Ѥδؿ  */
#define icu_reb( addr )		sil_reb_mem( (VP)(ICU_BASE_ADDR + addr) )
#define icu_wrb( addr, val )	sil_wrb_mem( (VP)(ICU_BASE_ADDR + addr), val )

#define icu_orb( mem, val )	icu_wrb( mem, icu_reb( mem ) | val )
#define icu_andb( mem, val )	icu_wrb( mem, icu_reb( mem ) & val )

/*
 *  ߥȥγߥޥط
 */

/*  ¤ICU_IPMΥեåȤ뤿Υޥmakeoffset.cѤ
    ʤΥޥͤϡäѤƤʤ*/
#define OFFSET_DEF_ICU_IPM	OFFSET_DEF(ICU_IPM, int1m)

/*  ߥȥǽʳߥޥӥåȥѥʺǹ͡*/
#define MAX_ICU_IPM  0xff

/*  ߥȥꤹߥޥΥå  */
#define CHECK_ICU_IPM(ipm)						       \
		CHECK_PAR( 0 < (ipm.int0m) && (ipm.int0m) <= MAX_ICU_IPM );    \
		CHECK_PAR( 0 < (ipm.int1m) && (ipm.int1m) <= MAX_ICU_IPM )

#ifndef _MACRO_ONLY

/*  ߥȥФߥޥεơ֥  */
extern ICU_IPM icu_intmask_table[];

/*  ߥȥintmaskơ֥  */
Inline void icu_set_ilv(INTNO intno, ICU_IPM *ipm) {
	/* CHECK_ICU_IPM(ipm) ϡ̥롼Ǽ¹ԺѤ */
	icu_intmask_table[intno].int0m = ipm->int0m;
	icu_intmask_table[intno].int1m = ipm->int1m;
}

/*  ߥȥΥޥ  */
Inline void icu_set_ipm(ICU_IPM *ipm) {
	/* CHECK_ICU_IPM(ipm) ϡ̥롼Ǽ¹ԺѤ */
	icu_wrb( (VP) ICU_INT0M, ipm->int0m );
	icu_wrb( (VP) ICU_INT1M, ipm->int1m );
}

/*  ߥȥΥޥ  */
Inline void icu_get_ipm(ICU_IPM *ipm) {
	ipm->int0m = icu_reb( (VP) ICU_INT0M );
	ipm->int1m = icu_reb( (VP) ICU_INT1M );
}

#endif /* _MACRO_ONLY */

/*============================================================================*/
/*  ֥ط  */

/*  ߵĥӥåȤ  */
/*  ߥȥICUIPM򥹥å¸  */
/*  ɶδطǡ1ХȤΥޥǤϤ뤱ɤ⡢
    ɶΤ2Хñ̤ǰɬפ롣 */
#define PUSH_ICU_IPM						\
	li	t1, ICU_BASE_ADDR;				\
	addi	sp, sp, -2*2;					\
	lb	t3, INT0M_offset(t1);	/* t3 = INT0M */	\
	lb	t4, INT1M_offset(t1);	/* t4 = INT1M */	\
	sh	t3, (sp);					\
	sh	t4, 2(sp)

/*  ߥȥICUIPM򥹥å  */
#define POP_ICU_IPM						\
	li	t1, ICU_BASE_ADDR;				\
	lh	t3, (sp);					\
	lh	t4, 2(sp);					\
	sb	t3, INT0M_offset(t1);	/* INT0M = t3 */	\
	sb	t4, INT1M_offset(t1);	/* INT1M = t4 */	\
	addi	sp, sp, 2*2

/*  ߥȥICUIPM  */
/*      t0˳װֹ椬ä֤ǸƤФ  */
/*      t0ƤƤϤʤ  */
/*      t1˳׵᥯ꥢäƤΤ˲ƤϤʤʤ  */
#define SET_ICU_IPM								\
	la	t4, icu_intmask_table;	/*  ǡơ֥Ƭɥ쥹  */	\
	sll	t2, t0, 1;		/*  եåȡװֹ2	\
						(ޥϡ2Х)  */		\
	li	t3, ICU_BASE_ADDR;						\
	add	t4, t4, t2;		/*  Ƭɥ쥹ܥեå  */	\
	lh	t5, (t4);		/*  t5 = INT0M:INT1M  */		\
					/*  աȥ륨ǥ¸  */	\
	sb	t5, INT0M_offset(t3);	/*  INT0M=t5β1Х  */		\
	srl	t6, t5, 8;							\
	sb	t6, INT1M_offset(t3);	/*  INT1M=t5ξ1Х  */

/*  ǥХ̾̽Ÿޥ  */
/*    װt0 proc_END   */
#define MAKE_PROC(device)		\
proc_##device:				\
	li	t0, INTNO_##device;	\
 	j	proc_END;		\
	nop;

/*  װȽ  */
/*    ߥȥMIPS3Int0³Ƥ  */
/*    ޥΥå*/
#define PROC_INT0				\
	li      t2, ICU_BASE_ADDR;		\
	lb      t3, INTR_offset(t2);		\
	lb	t4, INT0M_offset(t2);		\
	and	t5, t3, t4;		/* INT0M ȥޥ */	\
	beq	t5, zero, proc_END;		\
	nop;					\
						\
proc_BIT0:					\
	andi	t4, t3, TIMER0;			\
	beq	t4, zero, proc_BIT1;		\
	nop;					\
MAKE_PROC(TIMER0)				\
						\
proc_BIT1:					\
	andi	t4, t3, SERIAL0;		\
	beq	t4, zero, proc_BIT2;		\
	nop;					\
MAKE_PROC(SERIAL0)				\
						\
proc_BIT2:					\
	andi	t4, t3, GBUS;			\
	beq	t4, zero, proc_BIT3;		\
	nop;					\
MAKE_PROC(GBUS)					\
						\
proc_BIT3:					\
	andi	t4, t3, BUS_ERR;		\
	beq	t4, zero, proc_BIT4;		\
	nop;					\
MAKE_PROC(BUS_ERR)				\
						\
proc_BIT4:					\
	andi	t4, t3, TIMER1;			\
	beq	t4, zero, proc_BIT5;		\
	nop;					\
MAKE_PROC(TIMER1)				\
						\
proc_BIT5:					\
	andi	t4, t3, SERIAL1;		\
	beq	t4, zero, proc_BIT6;		\
	nop;					\
MAKE_PROC(SERIAL1)				\
						\
proc_BIT6:					\
	andi	t4, t3, PARALEL;		\
	beq	t4, zero, proc_BIT7;		\
	nop;					\
MAKE_PROC(PARALEL)				\
						\
proc_BIT7:					\
	andi	t4, t3, DMAC;			\
	beq	t4, zero, proc_END;		\
	nop;					\
MAKE_PROC(DMAC)					\
						\
proc_END:

#endif /* _PIC_ICU_H_ */
