/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 */

#ifndef _UPD71054_H_
#define _UPD71054_H_

#include <s_services.h>

/*
 *   uPD71054(NEC) Ϣ
 */

/* uPD71054Υ쥸Υɥ쥹 */
#define PCNT0		0x00
#define PCNT1		0x10
#define PCNT2		0x20
#define PCNTL		0x30

/* control word foemat */
#define BINARY			0u	/* BIT0 */
#define BCD			BIT0

#define MODE_0			0u	/* BIT1, 2, 3 */
#define MODE_1			BIT1
#define MODE_2			BIT2
#define MODE_3			(BIT2 | BIT1)
#define MODE_4			BIT3
#define MODE_5			(BIT3 | BIT1)

#define COUNT_LATCH_COMM	0u	/* BIT5, 4 */
#define LOWER_BYTE		BIT4
#define HIGH_BYTE		BIT5
#define LOW_HIGH_BYTE		(BIT5 | BIT4)

#define COUNTER_0		0u	/* BIT6, 7 */
#define COUNTER_1		BIT6
#define COUNTER_2		BIT7
#define MULT_LATCH_COMM		(BIT7 | BIT6)

/* multiple latch command format */
#define SEL_COUNTER_0		BIT1
#define SEL_COUNTER_1		BIT2
#define SEL_COUNTER_2		BIT3
#define DO_NOT_LATCH_STATUS	BIT4
#define LATCH_STATUS		0u	/* BIT4 */
#define DO_NOT_LATCH_COUNT	BIT5
#define LATCH_COUNT		0u	/* BIT5 */

/*
 *  ޤΥ쥸ؤΥؿ
 */
#define upd71054_reb( addr )		sil_reb_mem( (VP)(TIMER_BASE_ADDR + addr) )
#define upd71054_wrb( addr, val )	sil_wrb_mem( (VP)(TIMER_BASE_ADDR + addr), val )

#endif /* _UPD71054_H_ */
