/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2005 by Embedded and Real-Time Systems Laboratory
 *              Graduate School of Information Science, Nagoya Univ., JAPAN    
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: nios2.h,v 1.5 2005/03/11 07:37:57 honda Exp $
 */

#ifndef _NIOSII_H_
#define _NIOSII_H_

#ifndef _MACRO_ONLY
#include <itron.h>
#endif /* _MACRO_ONLY */

/*
 *  ߥӥå
 */
#define STATUS_U   0x02
#define STATUS_PIE 0x01

/*
 * ߤο
 */
#define MAX_INT_NUM 32

/*
 * 㳰θĿ
 */
#define MAX_EXC_NUM 32


/*
 *  Timer
 *  Full-featuredݡ 
 */

/*
 * եå
 */
#define TIM_STATUS_OFFSET  0x00
#define TIM_CONTROL_OFFSET 0x04
#define TIM_PERIODL_OFFSET 0x08
#define TIM_PERIODH_OFFSET 0x0C
#define TIM_SNAPL_OFFSET 0x10
#define TIM_SNAPH_OFFSET 0x14

#define TIM_STATUS_RUN 0x02
#define TIM_STATUS_TO  0x01

#define TIM_CONTROL_STOP  0x08
#define TIM_CONTROL_START 0x04
#define TIM_CONTROL_COUNT 0x02
#define TIM_CONTROL_ITO   0x01

/*
 *
 */
#define TIM_STATUS  (TIM_BASE + TIM_STATUS_OFFSET)
#define TIM_CONTROL (TIM_BASE + TIM_CONTROL_OFFSET)
#define TIM_PERIODL (TIM_BASE + TIM_PERIODL_OFFSET)
#define TIM_PERIODH (TIM_BASE + TIM_PERIODH_OFFSET)
#define TIM_SNAPL   (TIM_BASE + TIM_SNAPL_OFFSET)
#define TIM_SNAPH   (TIM_BASE + TIM_SNAPH_OFFSET)


/*
 * UART
 */
#define UART_RXDATA_OFFSET  0x00
#define UART_TXDATA_OFFSET  0x04
#define UART_STATUS_OFFSET  0x08
#define UART_CONTROL_OFFSET 0x0C
#define UART_DIVISOR_OFFSET 0x10
#define UART_ENDOFPACKET_OFFSET 0x1C

#define UART_STATUS_EOP   0x1000
#define UART_STATUS_CTS   0x0800
#define UART_STATUS_DCTS  0x0400
#define UART_STATUS_E     0x0100
#define UART_STATUS_RRDY  0x0080
#define UART_STATUS_TRDY  0x0040
#define UART_STATUS_TMT   0x0020
#define UART_STATUS_TOE   0x0010
#define UART_STATUS_ROE   0x0008
#define UART_STATUS_BRK   0x0004
#define UART_STATUS_FE    0x0002
#define UART_STATUS_PE    0x0001

#define UART_CONTROL_IEOP  0x1000
#define UART_CONTROL_RTS   0x0800
#define UART_CONTROL_IDCTS 0x0400
#define UART_CONTROL_TRDK  0x0200
#define UART_CONTROL_IE    0x0100
#define UART_CONTROL_IRRDY 0x0080
#define UART_CONTROL_ITRD  0x0040
#define UART_CONTROL_ITMT  0x0020
#define UART_CONTROL_ITOE  0x0010
#define UART_CONTROL_IROE  0x0008
#define UART_CONTROL_IBRK  0x0004
#define UART_CONTROL_IFE   0x0002
#define UART_CONTROL_IPE   0x0001

#define UART_RXDATA  (UART_BASE + UART_RXDATA_OFFSET)
#define UART_TXDATA  (UART_BASE + UART_TXDATA_OFFSET)
#define UART_STATUS  (UART_BASE + UART_STATUS_OFFSET)
#define UART_CONTROL (UART_BASE + UART_CONTROL_OFFSET)
#define UART_DIVISOR (UART_BASE + UART_DIVISOR_OFFSET)
#define UART_ENDOFPACKET (UART_BASE + UART_ENDOFPACKET_OFFSET)


/*
 * JTAG UARTϢ
 */ 
#define JTAG_UART_DATA_OFFSET    0x00
#define JTAG_UART_CONTROL_OFFSET 0x04

#define JTAG_UART_DATA_RVALID 0x8000

#define JTAG_UART_CONTROL_RIE 0x01
#define JTAG_UART_CONTROL_WIE 0x02
#define JTAG_UART_CONTROL_RIP 0x04
#define JTAG_UART_CONTROL_WIP 0x08
#define JTAG_UART_CONTROL_WSAPCE 0x0ffff0000

#define JTAG_UART_DATA    (UART_BASE + JTAG_UART_DATA_OFFSET)
#define JTAG_UART_CONTROL (UART_BASE + JTAG_UART_CONTROL_OFFSET)


#ifndef _MACRO_ONLY

/*                                                                          
 * ¢UART ʰSIOɥ饤                                                 
 */

/*                                                                            
 *  ꥢI/OݡȽ֥å                                         
 */
typedef struct sio_port_initialization_block {

} SIOPINIB;

/*                                                                            
 *  ꥢI/Oݡȴ֥å                                            
 */
typedef struct sio_port_control_block {
    const SIOPINIB  *siopinib;  /* ꥢI/OݡȽ֥å */
    VP_INT          exinf;      /* ĥ */
    BOOL    openflag;           /* ץѤߥե饰 */
    BOOL    sendflag;           /* ߥ֥͡ե饰 */
    BOOL    getready;           /* ʸ */
    BOOL    putready;           /* ʸǤ */
} SIOPCB;

extern SIOPCB   siopcb_table[];

#define uart_openflag   (siopcb_table[0].openflag)

Inline void
uart_putc(unsigned char c){
#ifndef USE_JTAG_UART	
	while(!(sil_rew_mem((VP)UART_STATUS) & UART_STATUS_TRDY));
	sil_wrw_mem((VP)UART_TXDATA, c);
#else
	while(!((sil_rew_mem((VP)JTAG_UART_CONTROL) & JTAG_UART_CONTROL_WSAPCE) > 0));
	sil_wrw_mem((VP)JTAG_UART_DATA, c);	
#endif /* USE_JTAG_UART	*/	
}

Inline unsigned char
uart_getc(void){
#ifndef USE_JTAG_UART	
	while(!(sil_rew_mem((VP)UART_STATUS) & UART_STATUS_RRDY));
	return (char)(sil_rew_mem((VP)UART_RXDATA));
#else
	int tmp;
	do{
		tmp = sil_rew_mem((VP)JTAG_UART_DATA);
	}while((tmp &JTAG_UART_DATA_RVALID) == 0);

	return (char)tmp;
#endif /* USE_JTAG_UART	*/			
}

/*
 *  Хå롼μֹ
 *  OPB_UARTLITE ϡߤʬƤʤᡤ̣Ϥʤ
 */
#define SIO_ERDY_SND    1u              /* ǽХå */
#define SIO_ERDY_RCV    2u              /* ΥХå */


/*                                                                           
 *  SIOɥ饤Фν롼                                                
 */
extern void uart_initialize(void);


/*                                                                           
 *  ꥢI/OݡȤΥץ                                              
 */
extern SIOPCB   *uart_opn_por(ID siopid, VP_INT exinf);

/*                                                                         
 *  ꥢI/OݡȤΥ                                             
 */
extern void uart_cls_por(SIOPCB *siopcb);

/*                                                                            
 *  ꥢI/OݡȤؤʸ                                            
 */
extern BOOL uart_snd_chr(SIOPCB *siopcb, INT chr);

/*
 *  ꥢI/OݡȤʸ
 */
extern INT  uart_rcv_chr(SIOPCB *siopcb);


/*
 *  ꥢI/OݡȤΥХåε
 */
extern void uart_ena_cbr(SIOPCB *siopcb, UINT cbrtn);


/*
 *  ꥢI/OݡȤΥХåζػ
 */
extern void uart_dis_cbr(SIOPCB *siopcb, UINT cbrtn);


/*                                                                            
 *  SIOγߥӥ롼                                              
 */
extern void uart_isr(void);


/*
 *  ꥢI/OݡȤǽХå
 */
extern void uart_ierdy_snd(VP_INT exinf);


/*
 *  ꥢI/OݡȤμΥХå
 */
extern void uart_ierdy_rcv(VP_INT exinf);

#endif  /* _MACRO_ONLY */

#endif /* _NIOSII_H_ */

