/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.c,v 1.2 2004/10/07 17:10:56 honda Exp $
 */

/*
 *	ץå¸⥸塼PowerPCѡ
 *ͥǻѤ
 *Cؿμ
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"
#include <sil.h>


/*
 *  ߥϥɥ顿ߥޥεơ֥
 */
FP int_table[TMAX_INTNO];


/*
 *  㳰٥εơ֥
 */
FP exc_table[TMAX_EXCNO];

/*
 *  顼åΥǡơ֥
 *
 *  ץơͭ㳰0x1000ϥͥ뤬Ѱդ
 *  ͳʤΤǡΥơ֥0x10ܤѤ
 *  ȤϤʤ
 */
static const char *(exe_list[]) = {
	"",				/*  0x0  */
	"System Reset",			/*  0x1  */
	"Machine Check",		/*  0x2  */
	"DSI",				/*  0x3  */
	"ISI",				/*  0x4  */
	"External Interrupt",		/*  0x5  */
	"Alignment",			/*  0x6  */
	"Program",			/*  0x7  */
	"Floating Point Unavailable",	/*  0x8  */
	"Decrementer",			/*  0x9  */
	"Implement Exception 0xa00",	/*  0xa  */
	"",				/*  0xb  */
	"System Call",			/*  0xc  */
	"Trace",			/*  0xd  */
	"Floating Point Assist",	/*  0xe  */
};


/*
 *  ץå¸ν
 */
void
cpu_initialize()
{
    	INHNO i;
    	EXCNO j;

    	/* 
    	 * ߵ٥ơ֥
    	 *
    	 *0ǽ̤ϿˤƤΤǡ
    	 *߽ICU¸ʬPROC_ICUǤϡ
    	 *̤ϿξνƤ
         */
    	for( i = 0; i < TMAX_INTNO; i++ ) {
        	define_inh( i, (FP)0 );
    	}

    	/* CPU㳰٥ơ֥ */
    	for( j = 0; j < TMAX_EXCNO; j++ ) {
        	define_exc( j, (FP)&no_reg_exception );
    	}
}

/*
 *  ץå¸νλ
 */
void
cpu_terminate()
{
}

#ifdef SUPPORT_CHG_IPM

/*
 *  ߥޥѹ
 *
 *  PowerPCˤIPMʤߥȥIPMΤ߰ä
 *  
 *
 *  chg_ipm Ȥä NMIʳΤ٤ƤγߤػߤǤ뤫ɤ
 *  ϳߥȥ˰¸롣
 *  NMIʳΤ٤Ƥγߤػߤˤϡloc_cpuˤCPU
 *  å֤ˤФ褤
 *  IPMˤäưγߤޥƤˤ⡤ǥ
 *  ѥåαʤIPMϡǥѥåˤäơ
 *  ¹Ծ֤ˤʤäذѤ롥Τᡤ
 *  ˡ̤Υˤä IPMѹ礬롥JSP
 *  ͥǤϡIPMѹϥ㳰롼ˤäƤⵯ뤬
 *  ˤäư񤷤ʤϾʤȻפ롥IPM 
 *  ˤäƥǥѥåػߤˤϡdis_dspʻ
 *  Ф褤
 */
SYSCALL ER
chg_ipm(IPM ipm)
{
	ER	ercd;

	LOG_CHG_IPM_ENTER(ipm);	/*  ICU¸  */
	CHECK_TSKCTX_UNL();
	CHECK_IPM(ipm);		/*  ICU¸  */

	t_lock_cpu();
	CHG_IPM(ipm);		/*  ICU¸  */
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_CHG_IPM_LEAVE(ercd);
	return(ercd);
}

/*
 *  ߥޥλ
 */
SYSCALL ER
get_ipm(IPM *p_ipm)
{
	ER	ercd;

	LOG_GET_IPM_ENTER(p_ipm);		/*  ICU¸  */
	CHECK_TSKCTX_UNL();

	t_lock_cpu();
	GET_IPM(p_ipm);				/*  ICU¸  */
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_GET_IPM_LEAVE(ercd, *p_ipm);	/*  ICU¸  */
	return(ercd);
}

#endif /* SUPPORT_CHG_IPM */


/*  CPU㳰ȯΥåΥǡɽ  */
void syslog_data_on_stack(EXCSTACK *sp)
{
    syslog(LOG_EMERG, "PC = 0x%08x SR = 0x%08x",
    			sp->srr0, sp->srr1);

    syslog(LOG_EMERG, "r0 = 0x%08x ", sp->r0);
    syslog(LOG_EMERG, "r3 = 0x%08x r4 = 0x%08x r5 = 0x%08x",
    			sp->r3, sp->r4, sp->r5);
    syslog(LOG_EMERG, "r6 = 0x%08x r7 = 0x%08x r8 = 0x%08x",
    			sp->r6, sp->r7, sp->r8);
    syslog(LOG_EMERG, "r9 = 0x%08x r10 = 0x%08x r11 = 0x%08x",
    			sp->r9, sp->r10, sp->r11);
    syslog(LOG_EMERG, "r12 = 0x%08x ", sp->r12);


    syslog(LOG_EMERG, "LR = 0x%08x CTR = 0x%08x",
    			sp->lr, sp->ctr );
    syslog(LOG_EMERG, "CR = 0x%08x XER = 0x%08x",
    			sp->cr, sp->xer );
}


/*
 * ϿƤʤ㳰ȯȸƤӽФ
 */

void no_reg_exception(EXCSTACK *sp)
{
    syslog(LOG_EMERG, "Exception error occurs.");
    syslog(LOG_EMERG, " [0x%02x]: %s", 
    	   sp->exc_no, exe_list[sp->exc_no]);

    /*  åΥǡɽ  */
    syslog_data_on_stack(sp);

    while(1);
}


/*
 *  ֥å饤֥
 *	(ItIsή)
 *
 *  ؿλͤϡANSI C 饤֥λͤƱɸ饤֥ΤΤ
 *  ȤäΨɤǽ롥
 *
 */
VP
_dummy_memcpy(VP dest, VP src, UINT len)
{
	VB *d = (VB *)dest;
	VB *s = (VB *)src;

	while (len-- > 0) {
		*d++ = *s++;
	}
	return(dest);
}

/*  end of file  */
