/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_insn.h,v 1.2 2015/06/27 10:48:27 ssuzuki Exp $
 */

/*
 *	ץåü̿Υ饤ؿRXѡ
 */

#ifndef	_CPU_INSN_H_
#define	_CPU_INSN_H_

/*
 *  ץåơɡPSWˤθͤɽФ
 */
Inline UW
current_psw()
{
	UW	psw;

	Asm("mvfc psw, %0" : "=g"(psw));
	return(psw);
}

/*
 *  ץåơɡPSWˤθͤѹ
 */
Inline void
set_psw(UW psw)
{
	Asm("mvtc %0, psw" : : "g"(psw));
}

/*
 *  ߤػ
 */
Inline void
disint()
{
	Asm("clrpsw i");
}

/*
 *  ٤Ƥγߤ
 */
Inline void
enaint()
{
	Asm("setpsw i");
}

/*
 *  ߥơ֥쥸INTBˤθͤɽФ
 */
Inline VP
current_intb()
{
	VP	intb;

	Asm("mvfc intb, %0" : "=r"(intb));
	return(intb);
}

/*
 *  ߥơ֥쥸INTBˤ
 */
Inline void
set_intb(VP intb)
{
	Asm("mvtc %0, intb" : : "r"(intb));
}

/*
 * ӥåȤ򥯥ꥢ
 */
Inline void
bitclr (UB *addr, UB bit)
{
	Asm("bclr %1, [%0].b" : : "r"(addr), "r"(bit));
}

/*
 * ӥåȤ򥻥å
 */
Inline void
bitset (UB *addr, UB bit)
{
	Asm("bset %1, [%0].b" : : "r"(addr), "r"(bit));
}


/*
 *  ǥ塼ΤΥӥåȥޥåץؿ
 *
 *¸ѰդؿѤΤ
 *CPU_BITMAP_SEARCHޥʤ
 */

#endif /* _CPU_INSN_H_ */
