/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_timer.h,v 1.4 2015/06/28 16:45:56 ssuzuki Exp $
 */

#ifndef _HW_TIMER_H_
#define _HW_TIMER_H_

#include <s_services.h>
#include <rx63n.h>

/*
 *  ޳ߥϥɥΥ٥ֹ
 */
#define	INHNO_TIMER	28

#ifndef _MACRO_ONLY

/*
 *  ͤɽη
 */
typedef UW	CLOCK;


/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
hw_timer_initialize()
{
	/* CMT0 ߾֤ */
	sil_wrh_mem((VP) RX63N_PRCR, 0xa502);
	sil_wrw_mem((VP) RX63N_MSTPCRA,
			sil_rew_mem((VP) RX63N_MSTPCRA) & ~(0x00000001 << 15));
	sil_wrh_mem((VP) RX63N_PRCR, 0xa500);

	/*
	 *  ޤʬ椪Ӽꤹ롥
	 *  ʬ=8=1ms
	 */
	sil_wrh_mem((VP) RX63N_CMT0_CMCOR, (((PCLK / 8) / 1000) - 1));
	sil_wrh_mem((VP) RX63N_CMT0_CMCR, 0x0040);

	/*
	 *  ޳ߤγߥ٥ꤷ
	 *  ޥ롥
	 */
	sil_wrb_mem((VP) RX63N_IPR004, 0x02);
	bitset((VP) RX63N_IER03, 4);

	/*
	 *  ޤư򳫻Ϥ롥
	 */
	sil_wrh_mem((VP) RX63N_CMT0_CMCNT, 0x000);
	sil_wrh_mem((VP) RX63N_CMSTR0, 0x0001);
}

/*
 *  ޳׵Υꥢ
 */
Inline void
hw_timer_int_clear()
{
	/*
	 * CMI0 ߤϥåߤʤΤǡ
	 * ׵դ׵ϥꥢ롣
	 */
}

/*
 *  ޤ߽
 */
Inline void
hw_timer_terminate()
{
	/*
	 *  ޤưߤ롥
	 */
	sil_wrh_mem((VP) RX63N_CMSTR0, 0x0000);

	/*
	 *  ޳ߤγߥ٥ꤷ׵򥯥ꥢ塤
	 *  ޥ롥
	 */
	sil_wrb_mem((VP) RX63N_IPR004, 0x00);
	bitclr((VP) RX63N_IER03, 4);
}

/*
 *  ޤθͤɤߤ
 *
 *  ߶ػ߶ǸƤӽФȡ
 */
Inline CLOCK
hw_timer_get_current(void)
{
	return sil_reh_mem((VP) RX63N_CMT0_CMCNT);
}

/*
 *  ޳׵Υå
 */
Inline BOOL
hw_timer_fetch_interrupt(void)
{
	return(sil_reh_mem((VP) RX63N_IR28) != 0);
}

#endif /* _MACRO_ONLY */
#endif /* _HW_TIMER_H_ */
