/*
 *  @(#) $Id: rxelf.ld,v 1.2 2015/06/28 10:54:19 ssuzuki Exp $
 */

OUTPUT_FORMAT("elf32-rx-le","elf32-rx-le","elf32-rx-le")
OUTPUT_ARCH(rx)

MEMORY
{
        ROM       : ORIGIN = 0xffff0000, LENGTH = 0x0000ffd0
        FIXEDVECT : ORIGIN = 0xffffffd0, LENGTH = 0x00000030
	RAM       : ORIGIN = 0x00000000, LENGTH = 0x00010000
}

PROVIDE (__stack = 0) ;
PROVIDE (_hardware_init_hook = 0) ;
PROVIDE (_software_init_hook = 0) ;
PROVIDE (_software_term_hook = 0) ;
SECTIONS
{
    .init :
    {
        KEEP (*(.init))
    } > ROM
    .text :
    {
        __text = . ;
        *(P .text .stub .text.* .gnu.linkonce.t.*)

    } > ROM
    .fini :
    {
        KEEP (*(.fini))
    } > ROM
    _etext = . ;
    PROVIDE (etext = .) ;
    .rodata :
    {
        *(C_1 C_2 C .rodata .rodata.* .gnu.linkonce.r.*)
    } > ROM
    . = ALIGN(4) ;
    __idata_start = . ;
    __idata_end = __idata_start + SIZEOF(.data) ;
    . = ALIGN(__idata_end, 4);
    .fixedvect :
    {
	*(.fixedvect)
    } > FIXEDVECT
    .eh_frame : { KEEP (*(.eh_frame)) }
    .gcc_except_table : { *(.gcc_except_table) }
    .ctors :
    {
        KEEP (*crtbegin.o(.ctors))
        KEEP (*(EXCLUDE_FILE (*crtend.o ) .ctors))
        KEEP (*(SORT(.ctors.*)))
        KEEP (*(.ctors))
    }
    .dtors :
    {
        KEEP (*crtbegin.o(.dtors))
        KEEP (*(EXCLUDE_FILE (*crtend.o ) .dtors))
        KEEP (*(SORT(.dtors.*)))
        KEEP (*(.dtors))
    }
    _edata  = . ;
    PROVIDE (edata = .) ;
    .data : AT(__idata_start) 
    {
        __data_start = . ;
        *(D_1 D_2 D .data)
    } > RAM
    . = ALIGN(4) ;
    __bss_start = . ;
    .bss :
    {
        *(B_1 B_2 B .bss COMMON)
    } > RAM
    _end = . ;
    __bss_end = . ;
    PROVIDE (end = .) ;
    .comment        0 : { *(.comment) }
    .debug          0 : { *(.debug) }
    .line           0 : { *(.line) }
    .debug_srcinfo  0 : { *(.debug_srcinfo) }
    .debug_sfnames  0 : { *(.debug_sfnames) }
    .debug_aranges  0 : { *(.debug_aranges) }
    .debug_pubnames 0 : { *(.debug_pubnames) }
}
