/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  Copyright (C) 2004 by SEIKO EPSON Corp, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 */

/*
 *  ץå¸⥸塼(S1C33)
 */


#ifndef _CPU_CONFIG_H_
#define _CPU_CONFIG_H_

/*
 *  ͥ̾Υ͡
 */
#include "cpu_rename.h"


/*
 *  ǽʺǹͥ
 */
#define	TPS_INTLEV_MAX	(0x04)
#define	TPS_CPULOCK_LEV	(TPS_INTLEV_MAX + 1)

/*
 *  TCB ΥեɤΥӥå
 */
#define	TBIT_TCB_PRIORITY	8	/* priority եɤΥӥå */
#define	TBIT_TCB_TSTAT		8	/* tstat եɤΥӥå	 */


#ifndef _MACRO_ONLY
/*
 *  TCB Ϣ
 *  cpu_context.h 쥬ȤȤΰ¸δطǡ
 *  cpu_context.h ˤʤ
 */
/*
 *  ƥȥ֥å
 *  Task context block.
 */
typedef struct task_context_block {
	VP sp;				/* åݥ	*/
	FP pc;				/* ץ५	*/
} CTXB;


/*
 *  ǹ̥ͥؤΥǥѥå(cpu_config.c)
 *
 *  dispatch ϡƥȤƤӽФ줿ӥ
 *  ǡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void dispatch(void);

/*
 *  ߤΥƥȤΤƤƥǥѥå(cpu_config.c)
 *
 *  exit_and_dispatch ϡCPUå֤ǸƤӽФʤФʤʤ
 */
extern void exit_and_dispatch(void);

/*
 *  ץå¸ν
 */
extern void	cpu_initialize(void);

/*
 *  ץå¸νλ
 */
extern void	cpu_terminate(void);

/*
 *  CPUåߥ٥
 */
extern UINT	tps_OrgIntLevel;

/*
 *  ߥͥȥ
 */
extern UINT	tps_IntNestCnt;

/*
 *  ӥåȥޥѤ
 */
#ifndef __c33pe
#define CPU_BITMAP_SEARCH
#endif  /* __c33pe */

/*
 *  ץåü̿Υ饤ؿ
 */
#include "cpu_insn.h"

/*
 * ƥֻȴؿ̾
 */
#define t_sense_lock	sense_lock
#define i_sense_lock	sense_lock
#define	t_lock_cpu	lock_cpu
#define	i_lock_cpu	lock_cpu
#define	t_unlock_cpu	unlock_cpu
#define	i_unlock_cpu	unlock_cpu

/*
 *  ߤΥƥȾ֤򻲾
 */
Inline BOOL
sense_context()
{
	return ((tps_IntNestCnt) ? TRUE : FALSE);
}

/*
 *  ߤCPUå֤򻲾
 */
Inline BOOL
sense_lock()
{
	UW	ulIntLevel;

	ulIntLevel = get_psr();

	ulIntLevel = (ulIntLevel & S1C33_PSR_MASK_IL);
	return ((ulIntLevel < (TPS_CPULOCK_LEV << 8)) ? FALSE : TRUE);
}

/*
 * CPUå
 */
Inline void
lock_cpu()
{
	UW	ulPsr, ulIntLevel;

	ulPsr = get_psr();
	ulIntLevel = (ulPsr & S1C33_PSR_MASK_IL);

	if(ulIntLevel < (TPS_CPULOCK_LEV << 8)){
		ulPsr &= ~S1C33_PSR_MASK_IL;
		set_psr(ulPsr | (TPS_CPULOCK_LEV << 8));
		tps_OrgIntLevel = ulIntLevel;
	}
}

Inline void
unlock_cpu()
{
	UW	ulPsr;

	ulPsr = get_psr();
	ulPsr &= ~S1C33_PSR_MASK_IL;
	ulPsr |= tps_OrgIntLevel;
	tps_OrgIntLevel = (TPS_INIT_INTLEVEL << 8);

	set_psr(ulPsr);
}

/*
 *  CPU㳰ȯΥƥ֤λ
 */
/*
 *  CPU㳰ȯΥƥȤλ
 */
Inline BOOL
exc_sense_context(VP p_excinf)
{
	return ((tps_IntNestCnt > 1) ? TRUE : FALSE);
}

/*
 *  CPU㳰ȯCPUå֤λ
 */
Inline BOOL
exc_sense_lock(VP p_excinf)
{
	UW	ulPsr;

	ulPsr = ((*((UW *)p_excinf) & S1C33_PSR_MASK_IL) >> 8);
	return (ulPsr == TPS_CPULOCK_LEV) ? TRUE : FALSE;
}

/*
 *  㳰٥ơ֥ι¤
 */
typedef struct exc_vector_entry {
	FP exchdr;				/* 㳰ϥɥεư */
} EXCVE;

/*
 *  CPU㳰ϥɥ
 */
#define	define_exc	define_inh

/*
 *  ߥϥɥ
 */
Inline void
define_inh(INHNO inhno, FP inthdr)
{
	EXCVE	*excvt;

	excvt = (EXCVE *) get_ttbr();
	excvt[inhno].exchdr = inthdr;
}

/*
 *  ߥϥɥνޥ
 */
#define INTHDR_ENTRY(inthdr)	void inthdr##_entry(void) { tpsIntPreWrap(); asm("xcall " #inthdr); tpsIntPostWrap(); }
#define	INT_ENTRY(inthdr)	inthdr##_entry

/*
 *  CPU㳰ϥɥνޥ
 */
#define EXCHDR_ENTRY(exchdr)	INTHDR_ENTRY(exchdr)
#define	EXC_ENTRY(exchdr)	exchdr##_entry

/*
 *  /CPU㳰ϥɥν
 *
 *  idleϳޤ줿å==stacktopʤΤǡ
 *  idle롼ˤretiǤ֤˳ߥåꤷƤ
 */
Inline void
tpsIntPreWrap(void)
{
#if TPS_DAREA_CNT == 4			/* ǡꥢ˱	*/
	Asm("pushn %r11");		/* 쥸ѹ롣	*/
#elif TPS_DAREA_CNT == 3
	Asm("pushn %r12");
#elif TPS_DAREA_CNT == 2
	Asm("pushn %r13");
#elif TPS_DAREA_CNT == 1
	Asm("pushn %r14");
#else
	Asm("pushn %r15");
#endif /* TPS_DAREA */

#ifdef	__c33adv
	Asm("pushs 	%sor				");
#else	/* __c33adv */
	Asm("ld.w	%r0, %ahr			");
	Asm("ld.w	%r1, %alr			");
#endif	/* __c33adv */

	Asm("ld.w	%r2, %sp			");	/* åڤؤ		*/
	Asm("xld.w	%r3, _kernel_tps_IntNestCnt	");	/* ߥ󥿤ι	*/
	Asm("ld.w	%r5, [%r3]			");	/* ¿ųߤεĤԤ	*/
	Asm("xld.w	%%r4, %0 - 8  " : : "g"(STACKTOP));
	Asm("cmp	%r5, 0x00			");
	Asm("jrne	0f				");
	Asm("ld.w	%sp, %r4			");
	Asm("0:						");
	Asm("add	%r5, 1				");
	Asm("ld.w	[%r3], %r5			");
	Asm("ld.w	%r4, %psr			");
	Asm("or		%r4, 0x10			");
	Asm("ld.w	%psr, %r4			");
	Asm("ld.w	%r6, %r2			");

#ifdef	__c33adv						/* pushs̿ˤ륹å	*/
	Asm("add	%r6, 24");				/* û		*/
#endif	/* __c33adv */
	
#if TPS_DAREA_CNT == 4
	Asm("add	%r6, 48");
#elif TPS_DAREA_CNT == 3
	Asm("add	%r6, 52");
#elif TPS_DAREA_CNT == 2
	Asm("add	%r6, 56");
#elif TPS_DAREA_CNT == 1
	Asm("add	%r6, 60");
#else
	Asm("ext	0x0001");
	Asm("add	%r6, 0x00");
#endif /* TPS_DAREA */
}

Inline void
tpsIntPostWrap(void)
{
	Asm("ld.w	%r4, %psr		");	/* ߤǥ֥뤹	*/
	Asm("xand	%r4, 0xfffff0ff		");
	Asm("xld.w	%%r5, %0"
		: : "g"(TPS_CPULOCK_LEV << 8));
	Asm("or		%r4, %r5		");
	Asm("ld.w	%psr, %r4		");

	Asm("ld.w	%r4, [%r3]		");	/* tps_IntNestCnt򹹿	*/
	Asm("sub	%r4, 1			");
	Asm("ld.w	[%r3], %r4		");

	Asm("ld.w	%sp, %r2		");	/* åΰ	*/

	Asm("cmp	%r4, 0x00		");
	Asm("xjrne	0f			");
	Asm("xld.w	%r3, _kernel_reqflg	");
	Asm("ld.w	%r3, [%r3]		");
	Asm("cmp	%r3, 1			");	/* tps_IntNestCnt== 0ǥǥ	  */
	Asm("xjreq	_kernel_ret_int		");	/* ѥåȯƤХ */
	Asm("0:					");	/* 				  */

#ifdef	__c33adv					/* 򤷤ü쥸 */
	Asm("pops	%sor			");
#else	/* __c33adv */
	Asm("ld.w	%alr, %r1		");
	Asm("ld.w	%ahr, %r0		");
#endif	/* __c33adv */

#if TPS_DAREA_CNT == 4
	Asm("popn %r11");
#elif TPS_DAREA_CNT == 3
	Asm("popn %r12");
#elif TPS_DAREA_CNT == 2
	Asm("popn %r13");
#elif TPS_DAREA_CNT == 1
	Asm("popn %r14");
#else
	Asm("popn %r15");
#endif /* TPS_DAREA */

	Asm("reti");
}

#endif /* _MACRO_ONLY */
#endif /* _CPU_CONFIG_H_ */
