/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  Copyright (C) 2004 by SEIKO EPSON Corp, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 */

/*
 *  åȥƥ¸⥸塼(DMT33209)
 */

#ifndef _SYS_CONFIG_H_
#define _SYS_CONFIG_H_

/*
 *  ͥ̾Υ͡
 */

#include "sys_rename.h"

/*
 *  ¬ѥӥ򥵥ݡȤʤ
 */
#define OMIT_VGET_TIM

/*
 *  ưåΥå̾
 */
#define TARGET_NAME	"EPSON S1C33 Standard Macro"

/*
 *  ݡȤ륷ꥢǥХοϺ 1
 */
#define TNUM_PORT		1
#define LOGTASK_PORTID		1

/*
 *  ꥢߤ/Ϥǰۤʤ뤫ɤ
 */
#define SEPARATE_SIO_INT

#include "s1c33.h"
#include "dmt33209.h"

#ifndef _MACRO_ONLY

/*
 *  åȥƥ¸ν
 */
extern void sys_initialize(void);

/*
 *  åȥƥνλ
 *
 *  ƥλ˻Ȥ
 */
extern void sys_exit(void);

/*
 *  åȥƥʸ
 *
 *  ƥ٥ʸϥ롼
 *
 */
extern void sys_putc(char c);

/*
 *  쥸ΥեåȰּ
 */
/*
 *  ߥץ饤ƥ쥸
 */
Inline ER
get_Offset(INTNO intno)
{
	INT		iOffset;
	switch(intno)
	{
		case S1C33_INHNO_PINT0:			/* Key, Port0-3 group */
		case S1C33_INHNO_PINT1:
		case S1C33_INHNO_PINT2:
		case S1C33_INHNO_PINT3:
		case S1C33_INHNO_KINT0:
		case S1C33_INHNO_KINT1:
			iOffset = 0;
			break;

		case S1C33_INHNO_HSDMA0:		/* DMA group */
		case S1C33_INHNO_HSDMA1:
		case S1C33_INHNO_HSDMA2:
		case S1C33_INHNO_HSDMA3:
		case S1C33_INHNO_IDMA:
			iOffset = 1;
			break;

		case S1C33_INHNO_P16TIMER0B:		/* 16bit timer0/1 group */
		case S1C33_INHNO_P16TIMER0A:
		case S1C33_INHNO_P16TIMER1B:
		case S1C33_INHNO_P16TIMER1A:
			iOffset = 2;
			break;

		case S1C33_INHNO_P16TIMER2B:		/* 16bit timer2/3 group */
		case S1C33_INHNO_P16TIMER2A:
		case S1C33_INHNO_P16TIMER3B:
		case S1C33_INHNO_P16TIMER3A:
			iOffset = 3;
			break;

		case S1C33_INHNO_P16TIMER4B:		/* 16bit timer4/5 group */
		case S1C33_INHNO_P16TIMER4A:
		case S1C33_INHNO_P16TIMER5B:
		case S1C33_INHNO_P16TIMER5A:
			iOffset = 4;
			break;

		case S1C33_INHNO_P8TIMER0:		/* 8bit timer group */
		case S1C33_INHNO_P8TIMER1:
		case S1C33_INHNO_P8TIMER2:
		case S1C33_INHNO_P8TIMER3:
			iOffset = 5;
			break;

		case S1C33_INHNO_SERIAL0ERR:		/* Serial I/O group */
		case S1C33_INHNO_SERIAL0RX:
		case S1C33_INHNO_SERIAL0TX:
		case S1C33_INHNO_SERIAL1ERR:
		case S1C33_INHNO_SERIAL1RX:
		case S1C33_INHNO_SERIAL1TX:
			iOffset = 6;
			break;

		case S1C33_INHNO_AD:			/* A/DConv, clocktimer, */
		case S1C33_INHNO_CLKTIMER:		/* Port 4-7 group	*/
		case S1C33_INHNO_PINT4:
		case S1C33_INHNO_PINT5:
		case S1C33_INHNO_PINT6:
		case S1C33_INHNO_PINT7:
			iOffset = 7;
			break;

		default:
			iOffset = E_PAR;
	}

	return (iOffset);
}

/*
 *  ӥåȰ
 */
Inline ER
get_BitFlag(INTNO intno)
{
	INT	iBitFlag;

	switch(intno)
	{
		case S1C33_INHNO_PINT0:			/* D0 group*/
		case S1C33_INHNO_HSDMA0:
		case S1C33_INHNO_P8TIMER0:
		case S1C33_INHNO_SERIAL0ERR:
		case S1C33_INHNO_AD:
			iBitFlag = 0x01;
			break;

		case S1C33_INHNO_PINT1:			/* D1 group*/
		case S1C33_INHNO_HSDMA1:
		case S1C33_INHNO_P8TIMER1:
		case S1C33_INHNO_SERIAL0RX:
		case S1C33_INHNO_CLKTIMER:
			iBitFlag = 0x02;
			break;

		case S1C33_INHNO_PINT2:			/* D2 group*/
		case S1C33_INHNO_HSDMA2:
		case S1C33_INHNO_P16TIMER0B:
		case S1C33_INHNO_P16TIMER2B:
		case S1C33_INHNO_P16TIMER4B:
		case S1C33_INHNO_P8TIMER2:
		case S1C33_INHNO_SERIAL0TX:
		case S1C33_INHNO_PINT4:
			iBitFlag = 0x04;
			break;

		case S1C33_INHNO_PINT3:			/* D3 group*/
		case S1C33_INHNO_HSDMA3:
		case S1C33_INHNO_P16TIMER0A:
		case S1C33_INHNO_P16TIMER2A:
		case S1C33_INHNO_P16TIMER4A:
		case S1C33_INHNO_P8TIMER3:
		case S1C33_INHNO_SERIAL1ERR:
		case S1C33_INHNO_PINT5:
			iBitFlag = 0x08;
			break;

		case S1C33_INHNO_KINT0:			/* D4 group*/
		case S1C33_INHNO_IDMA:
		case S1C33_INHNO_SERIAL1RX:
		case S1C33_INHNO_PINT6:
			iBitFlag = 0x10;
			break;

		case S1C33_INHNO_KINT1:			/* D5 group*/
		case S1C33_INHNO_SERIAL1TX:
		case S1C33_INHNO_PINT7:
			iBitFlag = 0x20;
			break;

		case S1C33_INHNO_P16TIMER1B:		/* D6 group*/
		case S1C33_INHNO_P16TIMER3B:
		case S1C33_INHNO_P16TIMER5B:
			iBitFlag = 0x40;
			break;

		case S1C33_INHNO_P16TIMER1A:		/* D7 group*/
		case S1C33_INHNO_P16TIMER3A:
		case S1C33_INHNO_P16TIMER5A:
			iBitFlag = 0x80;
			break;

		default:
			iBitFlag = E_PAR;
	}

	return (iBitFlag);
}

#endif /* _MACRO_ONLY */
#endif /* _SYS_CONFIG_H_ */
