/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_support.S,v 1.15 2005/11/07 01:15:43 honda Exp $
 */

/*
 *	ץå¸⥸塼 ֥SH1ѡ
 *ͥǻѤ
 */

#define	_MACRO_ONLY
#include "jsp_kernel.h"
#include "offset.h"

/*
 * ȥ֥åTCBsp,pcƬ60ХȤ
 * ϰˤꡢ饤Ȥ4ХȶˤʤäƤС
 * ߥǥХɥå󥰤ǥǤ
 * TCB_pc,TCB_spoffset.hƤ
 * (make
 */

/*  ߥǥХɥå󥰤ǽå  */
#define CHECK_IMMEDIATE_ADDRESSING(dst)			\
			((dst <= 60) && ((dst % 4) == 0))

#if CHECK_IMMEDIATE_ADDRESSING(TCB_pc) && 		\
	CHECK_IMMEDIATE_ADDRESSING(TCB_sp)
#define TCB_SHORT
#endif

/*
 * ȥ֥åTCBsp,pcƬ128Х
 * ʹߤ֤Ƥ
 * mov    #TCB_sp,r9
 * ĥޤ̿ϴ̤ưʤ
 */
#if (TCB_pc > 127) || (TCB_sp > 127)
#error TCB offset is limited 127.
#endif

#if !CHECK_IMMEDIATE_ADDRESSING(TCB_texptn)
#error immediate addressing TCB_texptn.
#endif

/*
 * ¾ΥեåͤˤĤ
 * 
 * (1) TCB_enatex
 *    mov.b @(#TCB_enatex,rx),r0̿¨ͤϥĥΤ
 *    TCB_enatex˴ؤƤϥåɬפʤ
 *    ʥǤϰ15ХȤĶȡ֥륨顼ˤʤ
 * 
 * (2) TCB_enatex_mask
 *    and  #TCB_enatex_mask,r0̿¨ͤϥĥΤ
 *    TCB_enatex_mask˴ؤƤϥåɬפʤ
 */


/*
 *  ǥѥå
 *
 *    dispatch ϡߡCPU㳰ͥȥ = 0,߶ػ߾
 *    ǸƤӽФʤФʤʤexit_and_dispatch ⡤ߥͥ
 *     = 0߶ػ߾֤ǸƤӽФΤ§Ǥ뤬ͥ
 *    ưб뤿ᡤߥͥȥ = 1ǸƤӽФ
 *    бƤ롥
 */

	.text
	.align 2
	.global _dispatch
_dispatch:
				/* pr,r8r15 򥹥å¸           */
	mov.l  r8, @-r15       	/* r0r7ϸƤӽФ¸Ƥ뤿  */
	mov.l  r9, @-r15        /* ¸ɬפ̵                    */
	mov.l  r10,@-r15
	mov.l  r11,@-r15
	mov.l  r12,@-r15
	mov.l  r13,@-r15
	mov.l  r14,@-r15
	sts.l  pr,@-r15
#ifdef SAVE_MACL_IN_DISPATCH
	sts.l  mach,@-r15
	sts.l  macl,@-r15
#endif /*  SAVE_MACL_IN_DISPATCH  */
	mov.l  _runtsk_dis,r2   /* r0 <- runtsk                          */
	mov.l  @r2,r0
	/*
	 * ȥ֥åTCBsp,pcƬ60ХȤ
	 * ϰˤꡢ饤Ȥ4ХȶˤʤäƤС
	 * ߥǥХɥå󥰤ǥǤ
	 */
#ifdef TCB_SHORT
				/*  åݥ󥿤¸ 	*/
	mov.l	r15,@(TCB_sp, r0)
	mov.l   dispatch_r_k,r1  /* ¹ԺƳ	                */
	bra     dispatcher
	mov.l	r1,@(TCB_pc, r0)	/*  ٱ䥹å   		*/
#else	/*  TCB_SHORT  */
	mov    #TCB_sp,r9
	mov.l  r15,@(r0,r9)     /* å¸                 */
	mov    #TCB_pc,r8
	mov.l  dispatch_r_k,r1  /* ¹ԺƳϤ¸                   */
	bra    dispatcher
	mov.l  r1,@(r0,r8)	/*  ٱ䥹å  			*/
#endif	/* TCB_SHORT */

	/*
	 * dispatch_r:
	 * ȥƥȤǥǥѥåƤӽФ򤷤
	 * ¹ԺƳ
	 * dispatcherƤФΤǡr7runtskƤ
	 * 
	 * 쥸
	 * r7 runtsk
	 * r0 runtsk->enatex
	 *      mov.b @(imm, r),r0̿ϥڥɤr0
	 *      ꤵƤ
	 * r1 runtsk->texptn
	 * r2 call_texrtn()Ƭɥ쥹
	 * 
	 */
dispatch_r:
					/* 쥸               */
#ifdef SAVE_MACL_IN_DISPATCH
	lds.l  @r15+,macl
	lds.l  @r15+,mach
#endif /*  SAVE_MACL_IN_DISPATCH  */
	lds.l  @r15+,pr
	mov.l  @r15+,r14
	mov.l  @r15+,r13
	mov.l  @r15+,r12
	mov.l  @r15+,r11
	mov.l  @r15+,r10
	mov.l  @r15+,r9
	mov.l  @r15+,r8
	mov.b  @(TCB_enatex,r7),r0	/*  ڥɤr0˸ (c)  */
	mov.l  @(TCB_texptn,r7),r1
	and    #TCB_enatex_mask,r0
	tst    r0,r0			/*  runtsk->enatexΥå 	*/
	bt     _dispatch_r_1
	/*  ٱ䥹åȤʤ  */
	tst    r1,r1			/*  runtsk->texptnΥå  	*/
	bt     _dispatch_r_1
	/*  ٱ䥹åȤʤ  */
	mov.l  _call_texrtn_dis,r2 /* 㳰롼ư	*/
	jmp    @r2		/*dispatch()ƤӽФ˥꥿󤹤*/
	nop			/*  ٱ䥹åȡ			*/
_dispatch_r_1:
	rts			/*  dispatch()ƤӽФؤΥ꥿  	*/
	nop			/*  ٱ䥹åȡ			*/


	.global _exit_and_dispatch
_exit_and_dispatch:
				/*  ߥͥȥ󥿤򥯥ꥢ  	*/
	mov.l  _intnest_dis, r1
	mov    #0,r0
	mov.l  r0,@r1

/*
 *  ǥѥå
 *  
 */
dispatcher:
	/*
	 * ˤϳ߶ػߤ뤳
	 */
	mov.l  _schedtsk_dis,r1
	mov.l  _runtsk_dis,r2
	mov.l  @r1,r7		/* r7 <- schedtsk  */
	mov    #0, r0		/* (b) */

	/*
	 * runtskschedtskΤϣĤΰ̣롣
	 * (1) schedtsk != NULLξ
	 * ̾ΥڤؤԤ
	 * (2) schedtsk == NULLξ
	 * runtskNULLƤ
	 * dispatcher_1ʹߤγԤǳߤꡢ
	 * iget_tid()뤵줿ȤTSK_NONE֤
	 * ˤϡ¹Ծ֤ΥʤˡruntskNULLˤ
	 * ɬפ롣
	 */
	mov.l  r7,@r2               /* runtskschedtsk               */

	cmp/eq r7,r0                /* schedtsk 뤫 (a)  */
	bt     dispatcher_1         /* ̵Х                 */
	/*  ٱ䥹åȤʤ  */

	/*
	 * ȥ֥åTCB¹ԺƳϤФ
	 * ʬ롣
	 * ʬϰʲ3
	 * dispatch_rƥȤΥǥѥåƤӽФ
	 * ret_int_r ߤνи
	 * activate_rưľ
	 * 
	 * ʬǤr7runtsk(=schedtsk)ɤƤȤ
	 * Ѥɤ
	 */
#ifdef TCB_SHORT
	/*
	 * ȥ֥åTCBsp,pcƬ60ХȤ
	 * ϰˤꡢ饤Ȥ4ХȶˤʤäƤС
	 * ߥǥХɥå󥰤ǥǤ
	 */
					/* ¹ԺƳϤ           */
	mov.l	@(TCB_pc, r7),r1
	jmp     @r1
	mov.l	@(TCB_sp, r7),r15      /*  ٱ䥹å		*/
					/* åݥ󥿤 */
#else	/*  TCB_SHORT  */
	mov    #TCB_pc,r8
	mov.l  @(r7,r8),r1          	/* ¹ԺƳϤ		*/
	mov    #TCB_sp,r9
	jmp    @r1
	mov.l  @(r7,r9),r15         	/* ٱ䥹å			*/
					/* åݥ󥿤 */
#endif	/* TCB_SHORT */


dispatcher_1:
	/*
	 *  ǳߥ⡼ɤڤ괹Τϡȯ߽
	 *  ˤɤΥåȤȤβȡߥϥɥ
	 *  ΥǥѥåɻߤȤĤΰ̣롥
	 */


	/* ߥǥͤɤ߹ΤϸΨΤǻѰդ
	 * 	r0  : 0x00
	 * 	r1  : 0x01
	 * 	r8  : ߶ػSR   
	 * 	r9  : ߵSR
	 * 	r10 : reqflg
	 * 	r11 : ߥͥȥintnest       
	 */
	mov    #0,r0
	mov    #1,r1
	mov.l  _mask_ipm_dis,r8

#ifdef SUPPORT_CHG_IPM
	mov.l  _task_intmask_dis,r2  /*  ƥȤIPM  */
	mov.l  @r2,r9
#else /* SUPPORT_CHG_IPM */
	mov    #0,r9
#endif /* SUPPORT_CHG_IPM */

	mov.l  _reqflg_dis,r10
	mov.l  _intnest_dis,r11
	    			
	mov.l  _stacktop_dis,r15  /* åߥåؤ */
	mov.l  r1,@r11		  /* ߥͥȥ󥿤򣱤ˤ   */
dispatcher_2:
	ldc    r9,sr		  /* ߵ                     */

	/*
	 *Relase1.4.1ǲ褵줿»
	 *
	 *ǥѥåνиǼ¹Ԥ٤ʤ(schedtsk==
	 *NULL˾ϡsleep̿ˤäƥץåϥ⡼ɤ
	 *ؤƳԤ򤷤Ƥ롣
	 *
	 *ߵĸsleep̿¹ԤƤ뤿ᡢߵ̿
	 *¹˳׵᤬äƤʤ뤤ϳߵľ塢
	 *sleep̿¹˳׵᤬äˡߵ̿
	 *¹Ԥȶ˳ߤդ졢sleepޤޤ
	 *ʤꡢreqflgΥå˿ʤޤʤ
	 *1msec˥޳ߤ뤿ᡢºݤˤsleepޤޤ
	 *ȤϤʤ
	 *
	 *ϡߤεĤsleep֤ؤΰܹԤȥߥå˼
	 *ԤǤʤȤ˵롣SH3ʹߤǤIPMȤ̤SRBLӥå
	 *ȤäƳߤζػ/Ĥ椹뤳Ȥˤꡢ
	 *Ǥ뤬SH1/2ǤIPMꤹʳ˳ߤػߡĤ
	 *ˡʤߵġʳԤIPMˤsleep򥢥
	 *ߥå˹Ԥˡʤ
	 *SH1¸Ǥϡ߼ջ˥åѤޤ줿
	 *Ϥ¿ųߤνиǥåϤ嵭sleep
	 *̿˳Ϥ1̿ʬ2Хȡ˿ʤ뤳Ȥ
	 *ꤳ򤷤Ƥ롣
	 *ˡǤ¿ųߤνи˿̿ΥС
	 *إåɤ롣
	 *OMIT_POWER_CONTROLޥ뤳Ȥsleep̿
	 *nop̿᤬졢¿ųߤνиǤΥå롼
	 *Ͼά롣ʤξϾϤˤʤ롣
	 */
#ifndef OMIT_POWER_CONTROL
_waiting_interrupt:
	sleep    		    /* Ԥ                       */
#else	/*  OMIT_POWER_CONTROL  */
	nop
#endif	/*  OMIT_POWER_CONTROL  */
	ldc    r8,sr		    /* ߶ػ                     */
	mov.l  @r10,r2		    /* reqflgΥå   		*/
	tst    r2,r2		    /* FALSEʤС⤦1ٳԤ  */
	bt     dispatcher_2
	/*  ٱ䥹åȤʤ  */
	mov.l  r0,@r10		    /* reqflgΥꥢ   		*/
	bra    dispatcher
	mov.l  r0,@r11		    /*  ٱ䥹å  */
				    /*  ߥͥȥ󥿤򥯥ꥢ 	*/

	/*
	 *Ԥľ˹ԤäåؤᤷԤäƤʤ
	 *ǥѥåνиTCBФͤ򥹥åݥ
	 *ꤹΤʤ
	 */


	.align 2
_runtsk_dis:
	.long _runtsk
_schedtsk_dis:
	.long _schedtsk
_call_texrtn_dis:
	.long _call_texrtn
_mask_ipm_dis:
	.long MAX_IPM << 4	/* ߶ػ߻SR  		*/
dispatch_r_k:
	.long dispatch_r
_stacktop_dis:
	.long STACKTOP		/* ΩΥåν	*/

_intnest_dis:	  		/* ߡCPU㳰ͥȥ  	*/
	.long _intnest
_reqflg_dis:
	.long _reqflg

#ifdef SUPPORT_CHG_IPM
_task_intmask_dis:		/* ƥȤγߥޥ   	*/
	.long _task_intmask
#endif /* SUPPORT_CHG_IPM */


/*
 *  ߡCPU㳰
 */

/*
 *  gccΥ᥸㡼Сˤư
 *
 *gcc2.xߤνиǥåȤΤߡ
 *mac쥸¸򤹤
 *gcc3.xʹߡߤνmac쥸¸򤹤
 *ʥå̵ͭ˰ͤʤ
 *
 *ˤꡢåƬPC,SRؤΥեåȤۤʤΤ
 *ա
 */
#if defined(__GNUC__) && (__GNUC__  > 2)
#define SAVE_MACL_BEFORE_INTERRUPT_HANDLER
#define SAVE_MACL_IN_DISPATCH
#endif 	/*  __GNUC__  */

/*
 *  ߡCPU㳰κݤΥåݥ󥿤ؤ֤
 *SR,PCΥԡޤǤΥեå
 *
 *Ǥåݥ󥿤ȤϳߡCPU㳰
 *ץ쥸PR򤬽äḷ̌ͤ롣
 *SRϥåƬ40ХȲˡPC36ХȲѤޤ
 *롣ret_int_3򻲾ȡ
 */
#ifdef SAVE_MACL_BEFORE_INTERRUPT_HANDLER
#define	SP_SR_OFFSET	(40+8)
#define	SP_PC_OFFSET	(36+8)
#else /*  SAVE_MACL_BEFORE_INTERRUPT_HANDLER  */
#define	SP_SR_OFFSET	40
#define	SP_PC_OFFSET	36
#endif /*  SAVE_MACL_BEFORE_INTERRUPT_HANDLER  */

/*
 *  CPU㳰³
 *
 *  CPU㳰ϥɥϡ󥿥ƥȤǼ¹Ԥ롥ΤᡤCPU
 *  ϥɥƤӽФ˳ߥ⡼ɤ˰ܹԤ꥿󤷤Ƥ
 *  Υ⡼ɤ᤹Υ⡼ɤ᤹ˡߥ⡼ɤ˰ܹԤ
 *   SR ߥå¸롥CPU㳰ƥȤ
 *  ȯreqflg  TRUE ˤʤäˡret_exc ʬ롥
 *  reqflg å˳ߤػߤʤȡreqflg å
 *  ˵ư줿ߥϥɥǥǥѥå׵ᤵ줿ˡǥ
 *  ѥåʤ
 *  
 *  ̿ξϤ2Хȿʤɬפ뤬
 *  бƤʤ
 *  GDB stub֥졼ݥȤȤƻѤ롣
 *  
 * CPU㳰װŸ롼r0,r1¸
 * ߶ػߤˤ塢
 *r1߼ľSRΥԡ
 *r2C롼Ƭɥ쥹
 * ξ֤Ǥ롣
 * 
 * 쥸
 * r4C롼ΰ
 * åѤޤ줿SRΥɥ쥹
 * r7åݥ
 */
	.text
	.align 2
	.globl _cpu_exception_entry
_cpu_exception_entry:
			/*  ĤΥå쥸򥹥åѤࡡ	*/
	mov.l	r3,@-r15
	mov.l	r4,@-r15
	mov.l	r5,@-r15
	mov.l	r6,@-r15
	mov.l	r7,@-r15
	sts.l	pr,@-r15
	mov	r15,r4		/*  C롼ΰ  		*/
	add	#SP_SR_OFFSET, r4
			/*  ߡCPU㳰ͥȥ󥿤Υå 	*/
	mov.l	_intnest_int, r5
	mov.l	@r5,r6
	tst     r6,r6   	/* CPU㳰ȯΥƥȤȽ  	*/
	add	#0x1,r6		/* ߥͥȥ󥿤򥤥󥯥 */
				/*  add̿ǤsrTӥåȤѲʤ	*/
	mov.l	r6,@r5
				/* ¿㳰ʤ饸   		*/
	bf	_exc_from_int
	/*  ٱ䥹åȤʤ  */					
									
/* 	ʤCPU㳰ξ 						*/
				/* åؤ			*/
				/* åݥ󥿤¸        	*/
	mov     r15,r7
				/* ߥåڤؤ		*/
	mov.l   _stacktop_int,r15
	ldc  	r1,sr		/*  ߵ  */			
	jsr	@r2		/* C롼ƤӽФ		*/
	mov.l	r7,@-r15 	/*  ٱ䥹åȡ  			*/
				/*    åݥ󥿤		*/
				/*    ߥåѤ  		*/
									
				/*  ߶ػ		*/		
	mov.l	_mask_ipm_int,r0
	ldc	r0,sr
				/* /CPU㳰ͥȥ󥿤򥯥ꥢ */
	mov.l	_intnest_int,r0
	mov	#0x0,r1
	mov.l	r1,@r0
	mov.l	@r15,r15	/* åؤ  			*/
				/* reqflgΥå                    	*/
	mov.l	_reqflg_int,r4
        mov.l	@r4,r5
	tst	r5,r5
	bt   	1f		/*  reqflg=FALSEξret_to_task_exc */
	/*  ٱ䥹åȤʤ  */					
	bra	ret_exc		/*  reqflg=TRUEξret_exc	*/
	nop			/*  ٱ䥹å 			*/

	/*
	 *bt̿Ǥret_to_task_excϤʤΤǡbra̿򣱥å
	 *롣
	 */
1:									
	bra	ret_to_task_exc	/*  reqflg=FALSEξ			*/
	nop			/*  ٱ䥹å 			*/


/* ¿CPU㳰ξ 							*/
/* 	CPU㳰ȯΥƥȤȽ̸塢 				*/
/*   		߶ػ 						*/
/*   		r1߼ջsrΥԡ 				*/
/*   		r2C롼Ƭɥ쥹				*/
/*   		r4C롼ΰ					*/
/* 	ξ֤ǤǤ 					*/
/* 	C롼ΰȳߥͥȥ󥿤 		*/
/* 	󥯥ȤϺѤǤ 					*/
									
_exc_from_int:
	jsr	@r2			/*  C롼ƤӽФ 	*/
	ldc	r1,sr			/*  ߵġٱ䥹åȡ	*/
									
	mov.l	_mask_ipm_int,r0	/*  ߶ػ			*/
	ldc	r0,sr
		/* ߡCPU㳰ͥȥ󥿤ǥ	*/
	mov.l	_intnest_int,r3
	mov.l	@r3,r4
	add	#-1,r4
	bra	_ret_to_exc
	mov.l	r4,@r3		/*  ٱ䥹å 			*/


/*
 *  ߤθ³
 *
 * װŸ롼r0,r1¸
 * ߶ػߤˤ塢
 *r1߼ľSRΥԡ
 *r2C롼Ƭɥ쥹
 * ξ֤Ǥ롣
 * 
 * 쥸
 * r7åݥ
 */
	.text
	.align 2
	.globl _interrupt_entry
_interrupt_entry:
			/*  ĤΥå쥸򥹥åѤࡡ	*/
	mov.l	r3,@-r15
	mov.l	r4,@-r15
	mov.l	r5,@-r15
	mov.l	r6,@-r15
	mov.l	r7,@-r15
	sts.l	pr,@-r15
#ifdef SAVE_MACL_BEFORE_INTERRUPT_HANDLER
	sts.l  mach,@-r15
	sts.l  macl,@-r15
#endif 	/*  SAVE_MACL_BEFORE_INTERRUPT_HANDLER  */

			/*  ߡCPU㳰ͥȥ󥿤Υå 	*/
	mov.l	_intnest_int, r5
	mov.l	@r5,r6
	tst     r6,r6   	/* ȯΥƥȤȽ  	*/
	add	#0x1,r6		/* ߥͥȥ󥿤򥤥󥯥 */
				/*  add̿ǤsrTӥåȤѲʤ	*/
	mov.l	r6,@r5
				/* ¿ųߤʤ饸   		*/
	bf	_interrupt_from_int
	/*  ٱ䥹åȤʤ  */					
									
/* 	ʤγߤξ 						*/
				/* åؤ			*/
				/* åݥ󥿤¸        	*/
	mov     r15,r7
				/* ߥåڤؤ		*/
	mov.l   _stacktop_int,r15
	ldc  	r1,sr		/*  ߵ  */			
	jsr	@r2		/* C롼ƤӽФ		*/
	mov.l	r7,@-r15 	/*  ٱ䥹åȡ  			*/
				/*    åݥ󥿤		*/
				/*    ߥåѤ  		*/
									
				/*  ߶ػ		*/		
	mov.l	_mask_ipm_int,r0
	ldc	r0,sr
				/* ߡCPU㳰ͥȥ󥿤򥯥ꥢ*/
	mov.l	_intnest_int,r0
	mov	#0x0,r1
	mov.l	r1,@r0
	mov.l	@r15,r15	/* åؤ  			*/
				/* reqflgΥå                    	*/
	mov.l	_reqflg_int,r4
        mov.l	@r4,r5
	tst	r5,r5
	bt   	ret_to_task_int	/*  reqflg=FALSEξ 			*/
	/*  ٱ䥹åȤʤ  */					
	bra	ret_int		/*  reqflg=TRUEξ			*/
	nop			/*  ٱ䥹å 			*/

										
/* ¿ųߤξ 							*/
/* 	ȯΥƥȤȽ̸塢 				*/
/*   		߶ػ 						*/
/*   		r1߼ջsrΥԡ 				*/
/*   		r2C롼Ƭɥ쥹				*/
/* 	ξ֤ǤǤ 					*/
/* 	ʳߥͥȥ󥿤Υ󥯥ȤϺѤǤ 		*/
									
_interrupt_from_int:
	jsr	@r2			/*  C롼ƤӽФ 	*/
	ldc	r1,sr			/*  ߵġٱ䥹åȡ	*/
									
	mov.l	_mask_ipm_int,r0	/*  ߶ػ			*/
	ldc	r0,sr
		/* ߡCPU㳰ͥȥ󥿤ǥ	*/
	mov.l	_intnest_int,r3
	mov.l	@r3,r4
	add	#-1,r4
	mov.l	r4,@r3


/*   ¿ųߡCPU㳰
 *
 *   	ǥѥå⥿㳰ɬפʤ
 * 	chg_ipm()νɬפʤ
 * 	󥿥ƥȤǤϡchg_ipm()ϻԲġ
 *
 *
 *    ǥѥåνиǼ¹Ԥ٤ʤ(schedtsk==NULL˾
 *    ϡsleep̿ˤäƥץåϥ⡼ɤڤؤƳ
 *    򤷤Ƥ롣dispatcher_2ն򻲾ȡ
 *    
 *    ߵĸsleep̿¹ԤƤ뤿ᡢߵ̿μ¹
 *    ˳׵᤬äƤʤ뤤ϳߵľ塢sleep̿
 *    ˳׵᤬äˡߵ̿μ¹Ԥȶ˳ߤ
 *    դ졢sleepޤޤˤʤäƤޤ
 *    reqflgΥå˿ʤޤʤˤϡߤεĤsleep 
 *    ֤ؤΰܹԤȥߥå˼¹ԤǤʤȤ˵롣
 *    ɤᡢߤνи襢ɥ쥹sleep̿Ǥ
 *    硢Ϥ1̿ʬʤ򤷤Ƥ롣ʼ¹Ԥ٤
 *    ʤǥѥåƥǳԤ˳ߤդϡ
 *    ǥѥåŸƤӽФ򤱤뤿ᡢ¿ųߤȤƽ
 *    뤿ᡢ_ret_to_int̲᤹롣
 */
_ret_to_int:
_ret_to_exc:

#ifndef OMIT_POWER_CONTROL
				/*  r4åѤޤ줿	*/
	mov.l	@(SP_PC_OFFSET, r15), r4
	mov.l	_waiting_interrupt_int, r5
	cmp/eq	r4, r5
	bf	_ret_to_int_1
	add	#2, r4
	mov.l	r4, @(SP_PC_OFFSET, r15)
#endif	/*  OMIT_POWER_CONTROL  */

_ret_to_int_1:
				/*  쥸  			*/
#ifdef SAVE_MACL_BEFORE_INTERRUPT_HANDLER
	lds.l  @r15+,macl
	lds.l  @r15+,mach
#endif 	/*  SAVE_MACL_BEFORE_INTERRUPT_HANDLER  */
	lds.l	@r15+,pr
	mov.l	@r15+,r7
	mov.l	@r15+,r6
	mov.l	@r15+,r5
	mov.l	@r15+,r4
	mov.l	@r15+,r3
	mov.l	@r15+,r2
	mov.l	@r15+,r1
	mov.l	@r15+,r0
	rte		    	/*  ߸  			*/
	nop
									
	.align 2
_stacktop_int:			/* ΩΥåν  	*/
	.long  STACKTOP
_intnest_int:	    		/*  ߡCPU㳰ͥȥ  	*/
	.long  _intnest
_reqflg_int:
	.long  _reqflg
_mask_ipm_int:	    		/*  ߶ػѥޥ  		*/
	.long  MAX_IPM << 4	/*  ipmʳΥӥåȤϥɤ	*/

#ifndef OMIT_POWER_CONTROL
_waiting_interrupt_int:
	.long  _waiting_interrupt
#endif	/*  OMIT_POWER_CONTROL  */

/*
 *  ߥϥɥ/CPU㳰ϥɥи
 *
 * 褬reqflgåȤƤΤߤˤ롣
 * ߥͥȥ = 0,߶ػ߾,å쥸
 * ¸֤ǸƤӽФȡ
 *
 * r4ˤѿreqflgΥɥ쥹줿֤Ǥ롣
 *
 */
	.text
	.align 2
ret_int:
ret_exc:
	/*
	 *褬ߤݤȽ
	 *
	 *SH1Ǥϳ߼ľ˳߶ػߤˤʤäƤʤᡢA
	 *̤γBǽ롣ʤϥϡ
	 *Υƥ򤱤褦ʤ˳ߥϥɥB
	 *ǥڤؤ򵯤褦ʥӥƤ֤ȳB
	 *νи̤Υ˥ǥѥåƤޤ2
	 *ΥäƤޤǡAν٤Ƥޤ
	 *ޤA٥ȥꥬ2󸡽ФƤޤ⤢롣
	 *ɤᡢåѤǤIPMtask_intmask
	 *ͤӤơ˳ߤʤäå
	 *Ƥ롣ǥѥåΥߥ󥰤Ƚ̤ƤΤǡ
	 *chg_ipm()task_intmask񤭴Ƥ뿴ۤϤʤ
	 */
				/*  	r0åѤޤ줿sr  	*/
	mov.l  @(SP_SR_OFFSET,r15),r0
#ifdef SUPPORT_CHG_IPM
	mov.l  _task_intmask_ret,r2 /*  r2&task_intmask  		*/
	and    #0xf0, r0	/*  	IPMФ  			*/
	mov.l  @r2,r3		/*  	r3task_intmask  		*/
	cmp/eq r0, r3		/*  	褬ߤ 	*/
#else /* SUPPORT_CHG_IPM */
	/*
	 *chg_ipm򥵥ݡȤʤϡƥȤIPM
	 *0x0
	 */
	and    #0xf0, r0	/*  	IPMФ  			*/
	cmp/eq #0x00, r0	/*  	褬ߤ 	*/
#endif /* SUPPORT_CHG_IPM */
	bf     ret_to_task_int	/*    	ǥѥåʤǳ߸	*/
				/*				*/
	/*  ٱ䥹åȤʤ  */

#ifdef SUPPORT_CPU_EXC_ENTRY_CHECK
	/*
	 *褬CPU㳰ݤȽ
	 *
	 *SH1ǤCPU㳰ߤȤۤƱԤäƤ뤬
	 *CPU㳰դƤߥޥѲʤCPU㳰
	 *˳ߤäơåѤޤ줿
	 *ϤȤäȽ̤Ԥ
	 *
	 *
	 *check_exc_entry()API
	 *r4åѤޤ줿
	 *r0
	 *1褬CPU㳰
	 *0ʳ
	 */
	mov.l	_check_exc_entry_ret, r1
	jsr	@r1			/*  C롼ƤӽФ  	*/
	mov.l	@(SP_PC_OFFSET, r15), r4 /* ٱ䥹åȡ  	*/
	
	tst	r0, r0		/*  ͤȽ  */
	bf     ret_to_task_int	/*    褬CPU㳰Ǥ  */
				/*ǥѥåʤǳ߸ */
	/*  ٱ䥹åȤʤ  */

#endif /* SUPPORT_CPU_EXC_ENTRY_CHECK */

	/*  
	 *reqflgΥꥢ
	 *
	 *ãreqflg򥯥ꥢƤޤȡ嵭γA
	 *νиǥǥѥåƤӽФɬפʥǤǥ
	 *ѥå㤬ƤӽФʤ
	 *ʳBreqflg򥻥åȤơAreqflgѲʤ
	 *
	 */
	mov	#0x0, r0
	mov.l  _reqflg_ret,r1
	mov.l	r0, @r1		/* reqflg <- 0			   */ 
	
	mov.l  _runtsk_ret,r1   /* r7 <- runtsk                    */
	mov.l  @r1,r7
	mov.l  _enadsp_ret,r2   /* enadspΥå                */
	mov.l  @r2,r3
	tst    r3,r3		/* ǥѥåػߤʤret_int_1 */
	bt     ret_int_1
	/*  ٱ䥹åȤʤ  */

	mov.l  _schedtsk_ret,r4 /* r5 <- schedtsk                  */
	mov.l  @r4,r5
	cmp/eq r7,r5            /* runtsk  schedtsk        */
	bt     ret_int_1	/*  Ʊʤret_int_1  	   */
	/*  ٱ䥹åȤʤ  */

        mov.l  r8,@-r15        	/* ĤΥ쥸¸            */
        mov.l  r9,@-r15
        mov.l  r10,@-r15
        mov.l  r11,@-r15
        mov.l  r12,@-r15
        mov.l  r13,@-r15
        mov.l  r14,@-r15
#ifndef SAVE_MACL_BEFORE_INTERRUPT_HANDLER
	/*
	 *åȤΤߡ
	 *mac쥸¸
	 */
	sts.l  mach,@-r15
	sts.l  macl,@-r15
#endif  /*  SAVE_MACL_BEFORE_INTERRUPT_HANDLER  */
	stc.l  gbr,@-r15
	/*
	 * ȥ֥åTCBsp,pcƬ60ХȤ
	 * ϰˤꡢ饤Ȥ4ХȶˤʤäƤС
	 * ߥǥХɥå󥰤ǥǤ
	 */
#ifdef TCB_SHORT
				/*  åݥ󥿤¸  */
	mov.l  r15,@(TCB_sp, r7)
	mov.l  ret_int_r_ret,r1	/* ¹ԺƳ             	  */
	bra    dispatcher
	mov.l  r1,@(TCB_pc, r7)	/*  ٱ䥹åȡ*/

#else	/*  TCB_SHORT  */
	mov    #TCB_sp,r1      	/* å¸           */
	mov.l  r15,@(r7,r1)
	mov.l  ret_int_r_ret,r1	/* ¹ԺƳϤ¸             */
	mov    #TCB_pc,r2	/*  ǥѥå㤫  */
				/*  ret_int_r  		*/
	bra    dispatcher
	mov.l  r1,@(r7,r2)	/*  ٱ䥹å 		  */
#endif	/* TCB_SHORT */

/*
 *  ߤνиǥǥѥå㤫餳äƤ
 *    r7runtsk줿֤Ǥ
 */
ret_int_r:
	ldc.l  @r15+,gbr       /* 쥸                  */
#ifndef SAVE_MACL_BEFORE_INTERRUPT_HANDLER
	lds.l  @r15+,macl
	lds.l  @r15+,mach
#endif  /*  SAVE_MACL_BEFORE_INTERRUPT_HANDLER  */
	mov.l  @r15+,r14
	mov.l  @r15+,r13
	mov.l  @r15+,r12
	mov.l  @r15+,r11
	mov.l  @r15+,r10
	mov.l  @r15+,r9
	mov.l  @r15+,r8

	/*
	 * ǥѥå㤫ret_int_rʬ硢
	 * ret_intľܤʬ硢
	 * ξ⡢r7runtskƤ
	 *
	 * 쥸
	 * 	r7  : runtsk
	 * 	r0  : runtsk->enatex
	 *      mov.b @(imm, r),r0̿ϥڥɤr0
	 *      ꤵƤ
	 * 	r2  : runtsk->texptn
	 * 	r3  : call_texrtn()Ƭ
	 */
ret_int_1:
	mov.b  @(TCB_enatex,r7),r0	/*  ڥɤr0˸ (d) */
	and    #TCB_enatex_mask,r0
	tst    r0,r0			/*  runtsk->enatexΥå  	*/
	bt     ret_int_2
	/*  ٱ䥹åȤʤ  */
	mov.l  @(TCB_texptn,r7),r2	/*  runtsk->texptnΥå  	*/
	tst    r2,r2
	bt     ret_int_2
	/*  ٱ䥹åȤʤ  */
	mov.l  _call_texrtn_ret,r3 	/* 㳰롼ư	*/
	jsr    @r3
	nop				/*  ٱ䥹å		*/

ret_int_2:
#ifdef SUPPORT_CHG_IPM
	/*
	 *SH1ǤϳߤΥ꥿̿ǥϡɥå
	 *Υǡɤ߽ФSR롣
	 *ߤˤä̤Υڤؤäϡ
	 *ȤIPMѹƤǽΤǥåSR
	 *Υԡ˴ޤޤIPM򹹿Ƥɬפ롣
	 */
				/*  	r0åѤޤ줿sr  	*/
	mov.l  @(SP_SR_OFFSET,r15),r0
	mov.l  _unmask_ipm_ret,r1
	mov.l  _task_intmask_ret,r2 /*  r2&task_intmask  		*/
	and    r1,r0		/*  	IPMӥåȤ򥯥ꥢ 	 	*/
	mov.l  @r2,r3		/*  	r3task_intmask  		*/
	or     r3,r0		/*  	IPMӥåȤ򥻥å 	 	*/
				/*  åѤǤsr˾  	*/
	mov.l  r0,@(SP_SR_OFFSET,r15)
#endif /* SUPPORT_CHG_IPM */

	/*
	 *ؤ
	 *ǥѥåƤӽФפʤϤή롣
	 *ǳߤäϡ
	 *ʤ롣
	 */
ret_to_task_int:
ret_to_task_exc:
				/* pr,å쥸 		*/
				/*  åƬΥեå  	*/
#ifdef SAVE_MACL_BEFORE_INTERRUPT_HANDLER
	lds.l  @r15+,macl	/*   +0:MACL  */
	lds.l  @r15+,mach	/*   +4:MACH  */
#endif /*  SAVE_MACL_BEFORE_INTERRUPT_HANDLER */
	lds.l  @r15+,pr		/*   +0:PR  */
	mov.l  @r15+,r7		/*   +4:r7  */
	mov.l  @r15+,r6		/*   +8:r6  */
	mov.l  @r15+,r5		/*  +12:r5  */
	mov.l  @r15+,r4		/*  +16:r4  */
	mov.l  @r15+,r3		/*  +20:r3  */
	mov.l  @r15+,r2		/*  +24:r2  */
	mov.l  @r15+,r1		/*  +28:r1  */
	mov.l  @r15+,r0		/*  +32:r0  */
				/*  +36:PC  */
				/*  +40:SR  */
	rte
	nop			/*  ٱ䥹å  */
	.align 4
_reqflg_ret:
	.long  _reqflg
_call_texrtn_ret:
	.long _call_texrtn
_runtsk_ret:
	.long _runtsk
_schedtsk_ret:
	.long _schedtsk
_enadsp_ret:
	.long _enadsp
ret_int_r_ret:
	.long ret_int_r

#ifdef SUPPORT_CHG_IPM		/*  chg_ipm()򥵥ݡȤ */
_unmask_ipm_ret:
	.long  ~0xf0		/*  ipmӥåȰʳ٤ƣ  */
_task_intmask_ret:
	.long _task_intmask
#endif /* SUPPORT_CHG_IPM */

#ifdef SUPPORT_CPU_EXC_ENTRY_CHECK
_check_exc_entry_ret:
	.long _check_cpu_exc_entry
#endif /* SUPPORT_CPU_EXC_ENTRY_CHECK */


/*
 *  no_reg_exception()
 *  CPU㳰ȤϿƤʤ㳰ȯȸƤӽФ
 *  㳰ȯpc,sr,pr,r015Ϥƥͥ
 *  ߤ롣
 */
	.text
	.align 2
	.globl _no_reg_exception
_no_reg_exception:
				/*  pr,r015¸  */
	sts.l  pr, @-r15
	mov.l  r15,@-r15
	mov.l  r14,@-r15
	mov.l  r13,@-r15
	mov.l  r12,@-r15
	mov.l  r11,@-r15
	mov.l  r10,@-r15
	mov.l  r9, @-r15
	mov.l  r8, @-r15
	mov.l  r7, @-r15
	mov.l  r6, @-r15
	mov.l  r5, @-r15
	mov.l  r4, @-r15
	mov.l  r3, @-r15
	mov.l  r2, @-r15
	mov.l  r1, @-r15
	mov.l  r0, @-r15

				/*  cpu_experr()θƤӽФ  	*/
	mov.l  _cpu_experr_k,r1	/*  (cpu_config.c)  		*/
	jsr    @r1
	mov    r15, r4		/*  ٱ䥹åȡ	*/

	.align 2
_cpu_experr_k:
	.long  _cpu_experr



/*  ߥǥХɥå󥰤ǽå  */
#if !(CHECK_IMMEDIATE_ADDRESSING(TCB_tinib) 			\
	&& CHECK_IMMEDIATE_ADDRESSING(TINIB_task)		\
	&& CHECK_IMMEDIATE_ADDRESSING(TINIB_exinf) )

ǥ֥롦顼
#endif


/*
 *  ư
 *  dispatcherƤФΤǡr7runtskƤ
 *  
 */
	.text
	.align 2
	.globl _activate_r
_activate_r:
				/* ߵĤν 		*/
#ifndef SUPPORT_CHG_IPM		/*  t_unlock_cpuν 	*/
	mov   #0,r1		/*  IPMʳΥӥåȤ˲ */
#else  /* SUPPORT_CHG_IPM */
        mov.l _task_intmask_act,r2
	mov.l @r2,r1
#endif /* SUPPORT_CHG_IPM */
	ldc   r1,sr		/*  ߵ  		*/
	mov.l _ext_tsk_act,r3
	lds   r3,pr		/*  Ϥ  */

	/*
	 *  ǳߤäruntsk񤭴äƤ⡢
	 *  ΥäƤȤˤruntskͤ
	 *  äƤ
	 * 
	 *   쥸
	 * r7runtsk
	 * r1&(runtsk->tinib)
	 * r2runtsk->tinib->task
	 * r4γĥʰ
	 */
	mov.l @(TCB_tinib,r7),r1
	mov.l @(TINIB_task,r1),r2	/*  ư  	*/
	jmp   @r2		/* jsr̿Ǥpr˲Ƥޤ*/
	mov.l @(TINIB_exinf,r1),r4	/*  ٱ䥹å  	*/
				/*  ĥʥؤΰ  */
	.align 2
_ext_tsk_act:
	.long _ext_tsk

#ifdef SUPPORT_CHG_IPM
_task_intmask_act:
	.long _task_intmask
#endif /* SUPPORT_CHG_IPM */

/*
 *  Ԥ
 */
	.globl _sil_dly_nse
_sil_dly_nse:

    mov.l  _sil_dly_tim1, r1	/* r4 SIL_DLY_TIM1  */
    add    r1, r4
    cmp/pl r4			/* ̤ 0 ʲʤ꥿ */
    bt     _sil_dly_nse1
    /*  ٱ䥹åȤʤ  */
    rts
    nop
_sil_dly_nse1:            
    mov.l  _sil_dly_tim2, r1	/* r4 SIL_DLY_TIM2  */
    add    r1, r4
    cmp/pl r4			/* ̤ 0 ʲʤ꥿ */
    bt     _sil_dly_nse1
    /*  ٱ䥹åȤʤ  */
    rts
    nop   
    .align 2
_sil_dly_tim1:
    .long  -SIL_DLY_TIM1    
_sil_dly_tim2:                         
    .long  -SIL_DLY_TIM2


/*
 * ˺Ͽ
 * dispatcher(a)Ԥcmp/eq imm,r0̿Ȥʤͳ
 * 
 *dispatcherr7runtskͤʬdispatch_r
 *ret_int_ractivate_rǤ̵̤ʥɤ򤷤ʤ褦ˤƤ
 *롣
 *schedtsk̵ͭåȤcmp/eq imm,r0̿(a)
 *ԡˤڥɤr0˸ꤵƤ뤿ᡢ˹碌ơ
 *ǽruntskr0ƤƤ
 *r0ϳʬˤenatexɤ߽Ф(c),(d)Ԥmov.b
 *̿Ǥͽ󤷤Ƥ뤿ᡢǤжƤ
 *mov.b @(imm, r),r0̿ϥڥɤr0˸ꤵƤ롣
 *äơruntskr7˳ơ(a)Ԥcmp/eq imm,r0̿ᤫ
 *cmp/eq rn,rm̿ѹΤᡢ쥸0
 *̿(b)ԡˤ;ʬäƤ롣
 *
 *mov.l @(imm, r),r0̿ϥڥɤr0˸ꤵ
 *ʤ
 *SH3ǤΤ褦makeoffset.cǥ٥BIT_BWꤹС4
 *ñ̤ǥեåȤȥޥΤǡmov.l̿᤬
 *Ȥ쥸դڤˤʤ뤬enatexȽΥޥǡ
 *and̿Υߥǥͤ˼ޤڤʤʤ뤿ᡢ
 *̿᤬;ʬ롣
 *ɤĹû뤬ˤruntskƥ
 *ϥޥȻפ롣
 */
