/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sh1itu.h,v 1.8 2005/11/14 08:00:44 honda Exp $
 */

/*
 *	ޥɥ饤
 *SH1¢Υƥ졼ƥåɡޡѥ륹˥åITU
 *ͥ0
 */

#ifndef _SH1ITU_H_
#define _SH1ITU_H_

/*
 *  åȿ¸
 *  
 *  åȿϥѥ륪ץͿ
 */

/*
 *   ޤؤϥåʬ
 *   	f/8ǥ
 */
#define TCR_TPSC	0x3u

/*
 *   ޤ˶뤵륯åȿ[kHz]
 *   	20MHz/8 =2.5MHz =2500kHz
 */
#ifdef CONFIG_20MHZ
#define TIMER_CLOCK	2500
#endif

/*
 *   	19.6608MHz/8 =2.4576MHz =2457.6kHz
 */
#ifdef CONFIG_19MHZ
#define TIMER_CLOCK	2458
#endif

/*
 *   	16MHz/8 =2MHz =2000kHz
 */
#ifdef CONFIG_16MHZ
#define TIMER_CLOCK	2000
#endif



/*
 *  ͤɽη
 */
typedef UH	CLOCK;

/*
 *  ͤɽȥߥáñ̤ȤѴ
 *
 */
#define	TO_CLOCK(nume, deno)	(TIMER_CLOCK * (nume) / (deno))
#define	TO_USEC(clock)		((clock) * 1000 / TIMER_CLOCK)
#define CLOCK_PER_TICK	((CLOCK) TO_CLOCK(TIC_NUME, TIC_DENO))

/*
 *  ǤΥ޼ñ̤ɽ
 */
#define	MAX_CLOCK	((CLOCK) 0xffffu)

/*
 *  ޤθͤȯͤȤߤʤȽ
 */
#define	GET_TOLERANCE	100	/* ٤θѤ͡ñ̤ɽ*/
#define	BEFORE_IREQ(clock)  \
		((clock) >= TO_CLOCK(TIC_NUME, TIC_DENO) - GET_TOLERANCE)


/*
 *  ȥ쥸Υɥ쥹
 */

    	/*    */
#define ITU_TSTR (VB *)0x5ffff00 /*  ޥȥ쥸 1Хȡ*/
#define ITU_TSNC (VB *)0x5ffff01 /*  ޥ󥯥쥸 1Хȡ*/
#define ITU_TMDR (VB *)0x5ffff02 /*  ޥ⡼ɥ쥸 1Хȡ  */
	/*  ޥե󥯥󥳥ȥ쥸 1Хȡ */
#define ITU_TFCR (VB *)0x5ffff03 
	/*  ޥȥץåȥȥ쥸 1Хȡ   */
#define ITU_TOCR (VB *)0x5ffff31

	/*  ITU0  */
#define ITU_TCR0  (VB *)0x5ffff04 /*  ޥȥ쥸0 1Хȡ*/
		/*  I/Oȥ쥸0 1Хȡ*/
#define ITU_TIOR0 (VB *)0x5ffff05 
		/*  ޥ󥿥ץȥ֥͡쥸0 1Хȡ*/
#define ITU_TIER0 (VB *)0x5ffff06 
#define ITU_TSR0  (VB *)0x5ffff07 /*  ޥơ쥸0 1Хȡ*/
#define ITU_TCNT0 (VH *)0x5ffff08 /*  ޥ0 2Хȡ*/
#define ITU_GRA0  (VH *)0x5ffff0a /*  ͥ쥸A0 2Хȡ*/
#define ITU_GRB0  (VH *)0x5ffff0b /*  ͥ쥸B0 2Хȡ*/


/*
 *  ȥ쥸
 */
#define TSR_IMFA	0x01u	/*  GRAڥޥåե饰  		*/
#define TSTR_STR0	0x01u	/*  ޥȥӥå  		*/
#define TCR_CCLR_GRA	0x20u	/*  GRAڥޥåǥ󥿤򥯥ꥢ */
#define TIER_RESERVE	0x78u	/*  TIER쥸ͽӥå  		*/
#define TIER_IMIEA	0x01u	/*  GRAڥޥåˤ׵ */
#define TIOR_RESERVE	0x08u	/*  TIOR쥸ͽӥå  		*/
#define TIOR_IOA	0x00u	/*  GRAڥޥåˤüҽ϶ػ */


#ifndef _MACRO_ONLY

/*
 *  ޥ
 */
Inline void
sh1_itu_start(void)
{
	sh1_orb_reg(ITU_TSTR, TSTR_STR0);
}

/*
 *  ް
 */
Inline void
sh1_itu_stop(void)
{
	sh1_anb_reg(ITU_TSTR, (VB)~TSTR_STR0);
}

/*
 *  ޳׵Υꥢ
 *	TCR쥸IMFAӥåȤ1ɤ߽Фˣ񤭹
 */
Inline void
sh1_itu_int_clear(void)
{
	/* ׵򥯥ꥢ 	*/
	/*  GRAڥޥåե饰 */
	sh1_anb_reg(ITU_TSR0, (VB)~TSR_IMFA);
}


/*
 *  ޤεư
 *
 *  ޤŪʥ޳׵ȯ롥
 */
Inline void
sh1_itu_initialize(void)
{
	CLOCK	cyc = TO_CLOCK(TIC_NUME, TIC_DENO);


	/*
	 *  ޴Ϣ
	 */
	sh1_itu_stop();		/*  */
			     		/* ޾ͤΥå */
	assert(cyc <= MAX_CLOCK);
			/*  GRAڥޥåǥ󥿤򥯥ꥢ */
			/*  ʬ  			*/
	sil_wrb_mem(ITU_TCR0, TCR_CCLR_GRA | TCR_TPSC);
			/*  GRAڥޥåˤ׵ */
	sil_wrb_mem(ITU_TIER0, TIER_RESERVE | TIER_IMIEA);
			/*  GRAڥޥåˤüҽ϶ػ */
	sil_wrb_mem(ITU_TIOR0, TIOR_RESERVE | TIOR_IOA);
			/*  GRA쥸ʥɸ͡  	*/
	sil_wrh_mem(ITU_GRA0, CLOCK_PER_TICK);
	sil_wrh_mem(ITU_TCNT0, 0);	/* 󥿤򥯥ꥢ 	*/

}

/*
 *  ޤ߽
 *
 *  ޤưߤ롥
 */
Inline void
sh1_itu_terminate(void)
{
	sh1_itu_stop();			/* ޤ 	*/
	sh1_itu_int_clear();		/* ׵򥯥ꥢ */

					/* ޳ߤػ   */
			/*  OVIE,IMIEB,IMIEAӥåȤ򥯥ꥢ  */
	sil_wrb_mem(ITU_TIER0, TIER_RESERVE);
}

/*
 *  ޤθͤɽФ
 *ޤưŪߤͤɤ߽Ф
 */
Inline CLOCK
sh1_itu_get_current(void)
{
	CLOCK	clk;
	

	sh1_itu_stop();			/*    */
	
	/*  Ԥ֤٤  */
	
	clk = sil_reh_mem(ITU_TCNT0);
	sh1_itu_start();			/*  ޥ  */
	
	return(clk);
}

/*
 *  ޳׵Υå
 */
Inline BOOL
sh1_itu_fetch_interrupt(void)
{
	VB tsr0 = sil_reb_mem(ITU_TSR0);
	return(tsr0 & TSR_IMFA);
}

#endif /* _MACRO_ONLY */
#endif /* _SH1ITU_H_ */
