/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sh1sci.c,v 1.12 2005/11/14 08:00:44 honda Exp $
 */

/*
 *   SH1¢ꥢ륳ߥ˥󥤥󥿥եSCI ʰץɥ饤
 *
 *SCI0ΤߤΥݡȤ2chؤγĥϻĤƤ롣
 *
 *sh1sci.{c,h}hw_serial.hʬδ
 *sh1sci.{c,h}ꥢǥХ˰¸ʬΤߵ
 *hw_serial.hߥȥ¸
 *
 *åȿ¸ˤĤ
 *ǥХ¸Υѥ᡼sh1sci.cѰդ롣
 *縵Υåȿϥѥ륪ץȤͿ
 */

#include <s_services.h>
#include <sh1sci.h>

/*
 *  ȥ쥸Υɥ쥹 ʤ٤1Хȥ
 */
	/*  ͥ0  */
#define SCI_SMR0 (VB *)0x5fffec0	/*  ꥢ⡼ɥ쥸 */
#define SCI_BRR0 (VB *)0x5fffec1	/*  ӥåȥ졼ȥ쥸  */
#define SCI_SCR0 (VB *)0x5fffec2	/*  ꥢ륳ȥ쥸 */
#define SCI_TDR0 (VB *)0x5fffec3	/*  ȥ󥹥ߥåȥǡ쥸 */
#define SCI_SSR0 (VB *)0x5fffec4	/*  ꥢ륹ơ쥸 */
#define SCI_RDR0 (VB *)0x5fffec5	/*  쥷֥ǡ쥸 */

	/*  ͥ1  */
#define SCI_SMR1 (VB *)0x5fffec8	/*  ꥢ⡼ɥ쥸 */
#define SCI_BRR1 (VB *)0x5fffec9	/*  ӥåȥ졼ȥ쥸  */
#define SCI_SCR1 (VB *)0x5fffeca	/*  ꥢ륳ȥ쥸 */
#define SCI_TDR1 (VB *)0x5fffecb	/*  ȥ󥹥ߥåȥǡ쥸 */
#define SCI_SSR1 (VB *)0x5fffecc	/*  ꥢ륹ơ쥸 */
#define SCI_RDR1 (VB *)0x5fffecd	/*  쥷֥ǡ쥸 */


/*
 *  ȥ쥸
 */
/*  ꥢ륹ơ쥸SSRγƥӥå  */
#define SSR_TDRE	0x80u	/* ȥ󥹥ߥåȥǡ쥸ץƥ */
#define SSR_RDRF	0x40u	/* 쥷֥ǡ쥸ե 		*/
#define SSR_ORER	0x20u	/* С󥨥顼 			*/
#define SSR_FER		0x10u	/* ե졼ߥ󥰥顼 			*/
#define SSR_PER		0x08u	/* ѥƥ顼 			*/
#define SSR_TEND	0x04u	/* ȥ󥹥ߥåȥ 		*/
#define SSR_MPB		0x02u	/* ޥץåӥå 		*/
#define SSR_MPBT	0x01u	/* ޥץåӥåȥȥ󥹥ե 	*/

/*  ꥢ륳ȥ쥸SCRγƥӥå  */
#define SCR_TIE		0x80u	/* ȥ󥹥ߥåȥ󥿥ץȥ֥͡ */
#define SCR_RIE		0x40u	/* 쥷֥󥿥ץȥ֥͡ 	*/
#define SCR_TE		0x20u	/* ȥ󥹥ߥåȥ֥͡ 		*/
#define SCR_RE		0x10u	/* 쥷֥֥͡ 			*/
#define SCR_MPIE	0x08u	/* ޥץå󥿥ץȥ֥͡ */
				/* ȥ󥹥ߥåȥɥ󥿥ץ	*/
#define SCR_TEIE	0x04u	/* ֥͡ 				*/
#define SCR_CKE_MASK	0x03u	/* åѥޥ		*/
#define SCR_CKE		0x00u	/* å֥͡			*/
				/*   ĴƱΤȤ  			*/
				/*   	å  		*/
				/*   	Ϥʤ  			*/

/*  ꥢ⡼ɥSMRγƥӥå  */
				/* ߥ˥⡼ 	*/
#define SMR_CA_CLOCK	0x80u	/* 	åƱ 		*/
#define SMR_CA_ASYNC	0x00u	/* 	ĴƱ 		*/
	/*  ĴƱ̿Asynchronous Communication method	*/
				/* 饯󥰥 		*/
#define SMR_CHR8	0x00u	/* 	8ӥå 		*/
#define SMR_CHR7	0x40u	/* 	7ӥå 		*/
				/* ѥƥ֥͡ 		*/
#define SMR_PE		0x20u	/* 	ѥƥ 		*/
#define SMR_PE_NON	0x00u	/* 	ѥƥʤ 		*/
#define SMR_OE_ODD	0x10u	/* ѥƥ⡼ɡʴѥƥ*/
#define SMR_STOP2	0x08u	/* ȥåץӥåȥ󥰥2 	*/
#define SMR_STOP1	0x00u	/* ȥåץӥåȥ󥰥1 	*/
#define SMR_MP		0x04u	/* ޥץå⡼ 	*/

/*
 *  åȿ¸
 *  	ԥޥԥ塼KZ-SH1-01Υåȿ20MHz
 *  	CQ RISCɾå SH-1Υåȿ19.6608MHz
 *  	׾SH1/CPUBΥåȿ16MHz
 */

/*
 *  ʬȥӥåȥ졼Ȥ
 */
#if CONFIG_BAUD == 9600
/*
 *
 *  å	20MHzξ
 *  ӥåȥ졼ȡ9600bps
 *
 *  n=0(ʬʤΤǤΤޤ)
 *  N=64Ǹ0.16%
 *  äơ
 *  ꥢ⡼ɥ쥸SMRΥå쥯ȥӥåCKS=00
 *  ӥåȥ졼ȥ쥸BRR=64
 */
#ifdef CONFIG_20MHZ
#define SMR_CKS 	0x0u	/*  ʬ  		*/
#define SCI_BRR 	64u	/*  ӥåȥ졼  	*/
#endif

/*
 *  å	19.6608MHz
 *  ӥåȥ졼ȡ9600bps
 *
 *  n=0(ʬʤΤǤΤޤ)
 *  N=63Ǹ0%
 *  äơ
 *  ꥢ⡼ɥ쥸SMRΥå쥯ȥӥåCKS=00
 *  ӥåȥ졼ȥ쥸BRR=63
 */
#ifdef CONFIG_19MHZ
#define SMR_CKS 	0x0u	/*  ʬ  		*/
#define SCI_BRR 	63u	/*  ӥåȥ졼  	*/
#endif

/*
 *  å	16MHz
 *  ӥåȥ졼ȡ9600bps
 *
 *  n=0(ʬʤΤǤΤޤ)
 *  N=51Ǹ0.16%
 *  äơ
 *  ꥢ⡼ɥ쥸SMRΥå쥯ȥӥåCKS=00
 *  ӥåȥ졼ȥ쥸BRR=51
 */
#ifdef CONFIG_16MHZ
#define SMR_CKS 	0x0u	/*  ʬ  		*/
#define SCI_BRR 	51u	/*  ӥåȥ졼  	*/
#endif

/*
 *  ܡ졼塢åꤹޤǤԤ
 *  ʺǽ1ӥåʬˡ
 *  BPS=9600bpsξ
 *  t = 1 / BPS = 104,167 = 105,000[nsec]
 */
#define SH1SCI_DELAY 	105000


#elif CONFIG_BAUD == 19200


/*
 *
 *  å	20MHzξ
 *  ӥåȥ졼ȡ19200bps
 *
 *  n=0(ʬʤΤǤΤޤ)
 *  N=32Ǹ -1.36%
 *  äơ
 *  ꥢ⡼ɥ쥸SMRΥå쥯ȥӥåCKS=00
 *  ӥåȥ졼ȥ쥸BRR=32
 */
#ifdef CONFIG_20MHZ
#define SMR_CKS 	0x0u	/*  ʬ  		*/
#define SCI_BRR 	32u	/*  ӥåȥ졼  	*/
#endif

/*
 *  å	19.6608MHz
 *  ӥåȥ졼ȡ19200bps
 *
 *  n=0(ʬʤΤǤΤޤ)
 *  N=31Ǹ0%
 *  äơ
 *  ꥢ⡼ɥ쥸SMRΥå쥯ȥӥåCKS=00
 *  ӥåȥ졼ȥ쥸BRR=31
 */
#ifdef CONFIG_19MHZ
#define SMR_CKS 	0x0u	/*  ʬ  		*/
#define SCI_BRR 	31u	/*  ӥåȥ졼  	*/
#endif

/*
 *  å	16MHz
 *  ӥåȥ졼ȡ19200bps
 *
 *  n=0(ʬʤΤǤΤޤ)
 *  N=25Ǹ0.16%
 *  äơ
 *  ꥢ⡼ɥ쥸SMRΥå쥯ȥӥåCKS=00
 *  ӥåȥ졼ȥ쥸BRR=25
 */
#ifdef CONFIG_16MHZ
#define SMR_CKS 	0x0u	/*  ʬ  		*/
#define SCI_BRR 	25u	/*  ӥåȥ졼  	*/
#endif

/*
 *  ܡ졼塢åꤹޤǤԤ
 *  ʺǽ1ӥåʬˡ
 *  BPS=19200bpsξ
 *  t = 1 / BPS = 52,083 = 53,000[nsec]
 */
#define SH1SCI_DELAY 	53000


#elif CONFIG_BAUD == 38400


/*
 *
 *  å	20MHzξ
 *  ӥåȥ졼ȡ38400bps
 *
 *  n=0(ʬʤΤǤΤޤ)
 *  N=15Ǹ1.73%
 *  äơ
 *  ꥢ⡼ɥ쥸SMRΥå쥯ȥӥåCKS=00
 *  ӥåȥ졼ȥ쥸BRR=15
 */
#ifdef CONFIG_20MHZ
#define SMR_CKS 	0x0u	/*  ʬ  		*/
#define SCI_BRR 	15u	/*  ӥåȥ졼  	*/
#endif

/*
 *  å	19.6608MHz
 *  ӥåȥ졼ȡ38400bps
 *
 *  n=0(ʬʤΤǤΤޤ)
 *  N=15Ǹ0%
 *  äơ
 *  ꥢ⡼ɥ쥸SMRΥå쥯ȥӥåCKS=00
 *  ӥåȥ졼ȥ쥸BRR=15
 */
#ifdef CONFIG_19MHZ
#define SMR_CKS 	0x0u	/*  ʬ  		*/
#define SCI_BRR 	15u	/*  ӥåȥ졼  	*/
#endif

/*
 *  å	16MHz
 *  ӥåȥ졼ȡ38400bps
 *
 *  n=0(ʬʤΤǤΤޤ)
 *  N=12Ǹ0.16%
 *  äơ
 *  ꥢ⡼ɥ쥸SMRΥå쥯ȥӥåCKS=00
 *  ӥåȥ졼ȥ쥸BRR=16
 */
#ifdef CONFIG_16MHZ
#define SMR_CKS 	0x0u	/*  ʬ  		*/
#define SCI_BRR 	16u	/*  ӥåȥ졼  	*/
#endif

/*
 *  ܡ졼塢åꤹޤǤԤ
 *  ʺǽ1ӥåʬˡ
 *  BPS=38400bpsξ
 *  t = 1 / BPS = 26,042 = 27,000[nsec]
 */
#define SH1SCI_DELAY 	27000

#else	/*  CONFIG_BAUD  */

#error unsupported baud rate.

#endif 	/*  CONFIG_BAUD  */


/*
 *  ꥢI/Oݡȴ֥å
 *  2chݡȤ˳ĥϽѤΥǡޤ
 */
struct sio_port_control_block {
	VP_INT		exinf;		/* ĥ */
	BOOL		openflag;	/* ץѤߥե饰 */
};

/*
 *  ꥢI/Oݡȴ֥åΥꥢ
 *  ID = 1 SCI0бƤ롥
 */
static SIOPCB	siopcb_table[TNUM_SIOP];

/*
 *  ꥢI/OݡID֥åФΥޥ
 */
				/*  ݡIDǥХֹޥ  */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  ʸǤ뤫
 */
Inline BOOL
sh1sci_getready(SIOPCB *siopcb)
{
	VB ssr0 = sil_reb_mem(SCI_SSR0);
	return(ssr0 & SSR_RDRF);
}

/*
 *  ʸǤ뤫
 */
Inline BOOL
sh1sci_putready(SIOPCB *siopcb)
{
	VB ssr0 = sil_reb_mem(SCI_SSR0);
	return(ssr0 & SSR_TDRE);
}

/*
 *  ʸμФ
 */
Inline char
sh1sci_getchar(SIOPCB *siopcb)
{
	char data;

	data = sil_reb_mem(SCI_RDR0);
	
	/*  쥷֥ǡ쥸ե롦ե饰Υꥢ  */
	sh1_anb_reg(SCI_SSR0, (VB)~SSR_RDRF);
	return data;
}

/*
 *  ʸν
 */
Inline void
sh1sci_putchar(SIOPCB *siopcb, char c)
{
#ifdef GDB_STUB
	gdb_stub_putc( c );
#else
	sil_wrb_mem(SCI_TDR0 ,c);
	
	/*  ȥ󥹥ߥåȥǡ쥸ץƥե饰Υꥢ*/
	sh1_anb_reg(SCI_SSR0, (VB)~SSR_TDRE);
#endif
}

/*
 *  SIOɥ饤Фν롼
 */
void
sh1sci_initialize(void)
{
	SIOPCB	*siopcb;
	UINT	i;

	/*
	 *  ꥢI/Oݡȴ֥åν
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_SIOP; siopcb++, i++) {
		siopcb->openflag = FALSE;
	}
}

/*
 *  ץ󤷤ƤݡȤ뤫
 */
BOOL
sh1sci_openflag(void)
{
#if TNUM_SIOP < 2
	return(siopcb_table[0].openflag);
#else /* TNUM_SIOP < 2 */
	return(siopcb_table[0].openflag || siopcb_table[1].openflag);
#endif /* TNUM_SIOP < 2 */
}

/*
 *  ꥢI/OݡȤΥץ
 */
SIOPCB *
sh1sci_opn_por(ID siopid, VP_INT exinf)
{
	SIOPCB *siopcb = get_siopcb(siopid);

#ifndef GDB_STUB
	VB scr0, smr0;
	VH pbcr1;

	sh1_anb_reg(SCI_SCR0, (VB)~(SCR_TE | SCR_RE));	/*    */

	/*  ԥ󥢥
	 *     ꥢǥХΤλǤϤʤΤ
	 *     ϤΥե˵ҤΤϤդ路ʤ
	 *     hw_serial.cѰդΤѻʤΤǻŪˤƤ롣
	 */
	pbcr1 = sil_reh_mem((VP)PBCR1);
						/* PB8:RxD0 PB9:TxD0  */
	pbcr1 = (pbcr1 & PBCR1_TD0_RD0_MASK) |
			PBCR1_TD0 | PBCR1_RD0;
	sil_wrh_mem((VP)PBCR1, pbcr1);
						/*  եޥå  */
	smr0 = 	SMR_CA_ASYNC |	/*  ĴƱ  		*/
		SMR_CHR8 |	/*  饯󥰥8ӥå */
		SMR_PE_NON |	/*  ѥƥʤ  		*/
		SMR_STOP1 |	/*  ȥåץӥåȥ󥰥1 	*/
		SMR_CKS;	/*  å쥯ȡʬ  */
	sil_wrb_mem(SCI_SMR0, smr0);
	
	sil_wrb_mem(SCI_BRR0, SCI_BRR);	/*  ܡ졼  	*/

					/*  ߶ػߤȥå */
	scr0 = (VB)(~(SCR_TIE | SCR_RIE | SCR_TE | SCR_RE |
			  SCR_MPIE | SCR_TEIE | SCR_CKE_MASK) | SCR_CKE);
	sil_wrb_mem(SCI_SCR0, scr0);
	
	/*
	 * ܡ졼Ȥ塢1ʬԤʤФʤʤ
	 */
	sil_dly_nse(SH1SCI_DELAY);

					/* 顼ե饰򥯥ꥢ	*/
	sh1_anb_reg(SCI_SSR0, (VB)~(SSR_ORER | SSR_FER | SSR_PER));
					/* ߵ   	*/
					/*   		*/
	sh1_orb_reg(SCI_SCR0, (SCR_RIE | SCR_TE | SCR_RE));
			/*  ߤεĤؿǹԤ  */

#endif	/*  GDB_STUB  */

	siopcb->exinf = exinf;
	siopcb->openflag = TRUE;
	return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
void
sh1sci_cls_por(SIOPCB *siopcb)
{
				/*  ߡ߶ػ 	*/
	sh1_anb_reg(SCI_SCR0, (VB)~(SCR_TIE | SCR_RIE | SCR_TE | SCR_RE));
	siopcb->openflag = FALSE;
}

/*
 *  ꥢI/OݡȤؤʸ
 */
BOOL
sh1sci_snd_chr(SIOPCB *siopcb, char c)
{
	if (sh1sci_putready(siopcb)) {
		sh1sci_putchar(siopcb, c);
		return(TRUE);
	}
	return(FALSE);
}

/*
 *  ꥢI/OݡȤʸ
 */
INT
sh1sci_rcv_chr(SIOPCB *siopcb)
{
	if (sh1sci_getready(siopcb)) {
		return((INT)(UB)sh1sci_getchar(siopcb));
		/*  (UB)ǥ㥹ȤΤϥĥˤ뤿  */
	}
	return(-1);
}

/*
 *  ꥢI/OݡȤΥХåε
 */
void
sh1sci_ena_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:	/* ׵ */
		sh1_orb_reg(SCI_SCR0, SCR_TIE);
		break;
	case SIO_ERDY_RCV:	/* ׵ */
		sh1_orb_reg(SCI_SCR0, SCR_RIE);
		break;
	}
}

/*
 *  ꥢI/OݡȤΥХåζػ
 */
void
sh1sci_dis_cbr(SIOPCB *siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:	/* ׵ػ */
		sh1_anb_reg(SCI_SCR0, (VB)~SCR_TIE);
		break;
	case SIO_ERDY_RCV:	/* ׵ػ */
		sh1_anb_reg(SCI_SCR0, (VB)~SCR_RIE);
		break;
	}
}

/*
 *  ꥢI/OݡȤФ߽
 */
Inline void
sh1sci_isr_siop_out(SIOPCB *siopcb)
{
	VB scr0 = sil_reb_mem(SCI_SCR0);
	
	if ((scr0 & SCR_TIE) != 0 && sh1sci_putready(siopcb)) {
		/*
		 *  ΥХå롼ƤӽФ
		 */
		sh1sci_ierdy_snd(siopcb->exinf);
	}
}

/*
 *  ꥢI/OݡȤФ߽
 */
Inline void
sh1sci_isr_siop_in(SIOPCB *siopcb)
{
	VB scr0 = sil_reb_mem(SCI_SCR0);

	if ((scr0 & SCR_RIE) != 0 && sh1sci_getready(siopcb)) {
		/*
		 *  ΥХå롼ƤӽФ
		 */
		sh1sci_ierdy_rcv(siopcb->exinf);
	}
}

/*
 *  SIOߥӥ롼
 *  
 *  SH1¢SCIǤϳֹ椬̡̤ͥʬƤΤǡ
 *  SCI0߰ʳǤΥ롼󤬸ƤФ뤳ȤϤʤ
 *  
 */
void
sh1sci_isr_out(void)
{
	if (siopcb_table[0].openflag) {
		sh1sci_isr_siop_out(get_siopcb(1));
	}
}

/*
 *  SIOߥӥ롼
 *  
 *  SH1¢SCIǤϳֹ椬̡̤ͥʬƤΤǡ
 *  SCI0μ߰ʳǤΥ롼󤬸ƤФ뤳ȤϤʤ
 *  
 */
void
sh1sci_isr_in(void)
{
	if (siopcb_table[0].openflag) {
		sh1sci_isr_siop_in(get_siopcb(1));
	}
}

/*
 *  SIO顼ߥӥ롼
 *  
 *  SH1¢SCIǤϳֹ椬̤ͥʬƤΤǡ
 *  SCI0μ顼߰ʳǤΥ롼󤬸ƤФ뤳ȤϤʤ
 *  
 *  顼Τϥ顼ե饰ΥꥢΤߤˤȤɤƤ롣
 *  С󥨥顼
 *  ե졼ߥ󥰥顼
 *  ѥƥ顼
 */
void
sh1sci_isr_error(void)
{
	VB ssr0;
	
	if (siopcb_table[0].openflag) {
		ssr0 = sil_reb_mem(SCI_SSR0);	/*  1ɤ߽Ф  */
		ssr0 &= ~(SSR_RDRF | SSR_ORER | SSR_FER | SSR_PER);
		sil_wrb_mem(SCI_SSR0, ssr0);	/*  顼ե饰ꥢ  */
	}
}

/*
 * ݡ󥰤ˤʸ
 */
void
sh1sci_putc_pol(char c)
{
	while(!sh1sci_putready(&siopcb_table[0]));
	sh1sci_putchar(&siopcb_table[0], c);
}
