/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_serial.h,v 1.5 2005/07/06 00:45:07 honda Exp $
 */

/*
 *ꥢI/OǥХSIO/SCIF˥ɥ饤Сapsh02f6aѡ
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>
#ifndef _MACRO_ONLY
#include "sh7145sci.h"
#endif /* _MACRO_ONLY */

/*
 *  SIOγߥϥɥΥ٥ֹ
 */
#ifndef GDB_STUB

#define INHNO_SERIAL_IN	 RXI1
#define INHNO_SERIAL_OUT TXI1
#define INHNO_SERIAL_ERROR ERI1
#if TNUM_PORT >= 2
#define INHNO_SERIAL2_IN	 RXI0
#define INHNO_SERIAL2_OUT TXI0
#define INHNO_SERIAL2_ERROR ERI0
#endif /* TNUM_PORT >= 2 */

#else /* GDB_STUB */

#define INHNO_SERIAL_IN	 RXI0
#define INHNO_SERIAL_OUT TXI0
#define INHNO_SERIAL_ERROR ERI0

#endif /* GDB_STUB */

/*
 * SCIγߥ٥
 * ߥϥɥ̡ϿǤ뤬ߥ٥
 * Ʊ٥ˤǤʤ
 */
#define LEVEL0		0			/*  ߲Υ٥  */

#ifndef _MACRO_ONLY

/*
 *  SIOɥ饤Фν롼
 */
#define	sio_initialize	sh2sci_initialize

/*
 *  ꥢI/OݡȤΥץ
 */
Inline SIOPCB *
sio_opn_por (ID siopid, VP_INT exinf)
{
	SIOPCB *siopcb;
	BOOL openflag;

	/*
	 *  ץ󤷤ݡȤ뤫 openflag ɤǤ
	 */
	openflag = sh2sci_openflag (siopid);

	/*
	 *  ǥХ¸Υץ
	 */
	siopcb = sh2sci_opn_por (siopid, exinf);

	/*
	 *  ߥȥ¸
	 *  ꥢI/Oߤγߥ٥ꤹ
	 */
	if (!openflag) {
		if ((siopcb->siopinib->reg_base) == 0xffff81c0)
			define_int_plevel (IPRI, siopcb->siopinib->int_level, 12);
		if ((siopcb->siopinib->reg_base) == 0xffff81a0)
			define_int_plevel (IPRF, siopcb->siopinib->int_level, 4);
		if ((siopcb->siopinib->reg_base) == 0xffff81b0)
			define_int_plevel (IPRF, siopcb->siopinib->int_level, 0);
	}
	return (siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
Inline void
sio_cls_por (SIOPCB * siopcb)
{
	/*
	 *  ǥХ¸Υ
	 */
	sh2sci_cls_por (siopcb);

	/*
	 *  ꥢI/Oߥ٥٥ˤ
	 */
	if ((siopcb->siopinib->reg_base) == 0xffff81c0)
		define_int_plevel (IPRI, LEVEL0, 12);
	if ((siopcb->siopinib->reg_base) == 0xffff81a0)
		define_int_plevel (IPRF, LEVEL0, 4);
	if ((siopcb->siopinib->reg_base) == 0xffff81b0)
		define_int_plevel (IPRF, LEVEL0, 0);
}

/*
 *  SIOγߥϥɥ
 */
#define	sio_handler_in	sh2sci_isr_in	/*  ߥϥɥ  */
#define	sio_handler_out	sh2sci_isr_out	/*  ߥϥɥ  */
#define	sio_handler_error sh2sci_isr_error	/*  顼ߥϥɥ  */
#if TNUM_PORT >= 2
#define	sio_handler2_in		sh2sci_isr2_in	/*  ߥϥɥ  */
#define	sio_handler2_out	sh2sci_isr2_out	/*  ߥϥɥ  */
#define	sio_handler2_error	sh2sci_isr2_error	/*  顼ߥϥɥ  */
#endif /* TNUM_PORT >= 2 */

/*
 *  ꥢI/OݡȤؤʸ
 */
#define	sio_snd_chr	sh2sci_snd_chr

/*
 *  ꥢI/OݡȤʸ
 */
#define	sio_rcv_chr	sh2sci_rcv_chr

/*
 *  ꥢI/OݡȤΥХåε
 */
#define	sio_ena_cbr	sh2sci_ena_cbr

/*
 *  ꥢI/OݡȤΥХåζػ
 */
#define	sio_dis_cbr	sh2sci_dis_cbr

/*
 *  ꥢI/OݡȤǽХå
 *  jsp/systask/serial.cˤΤ͡षƤ
 *  ʰȡ
 */
#define	sio_ierdy_snd	sh2sci_ierdy_snd

/*
 *  ꥢI/OݡȤμΥХå
 *  jsp/systask/serial.cˤΤ͡षƤ
 *  ʰȡ
 */
#define	sio_ierdy_rcv	sh2sci_ierdy_rcv

#endif /* _MACRO_ONLY */
#endif /* _HW_SERIAL_H_ */
