/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2010 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_defs.h,v 1.5 2005/07/06 00:45:07 honda Exp $
 */

/*
 *	ץå˰¸SH2ѡ
 *ץꥱɬפȤ
 *
 *  Υ󥯥롼ɥեϡkernel.h  sil.h ǥ󥯥롼ɤ롥
 *  ¾Υե뤫ľܥ󥯥롼ɤ뤳ȤϤʤΥե򥤥
 *  롼ɤˡt_stddef.h  itron.h 󥯥롼ɤΤǡ
 *  ˰¸Ƥ褤
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

/*
 *  桼
 */
#include <user_config.h>	/*  SUPPORT_VXGET_TIMޥ  */



/* ͥ뵯ưΥå   */
#define COPYRIGHT_CPU \
"Copyright (C) 2001-2004 by Industrial Technology Institute,\n" \
"                            Miyagi Prefectural Government, JAPAN\n" \
"Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN\n" \
"   \n\n"

#ifndef _MACRO_ONLY

/*
 *  ߡCPU㳰ϥɥֹη
 */
typedef	UINT	INHNO;		/* ߥϥɥֹ */
typedef	UINT	EXCNO;		/* CPU㳰ϥɥֹ */

/*
 *  ߥޥηȳߥޥѹ
 *  
 *  #ifdef SUPPORT_CHG_IPM#endifǰϤ٤
 *  Υե뤬cpu_config.h˥󥯥롼ɤ뤿
 *  άƤ롣
 *  ʬĤ뤳Ȥˤꡢ륳ɤϤۤȤɤʤΤ
 *  ³ϤʤȽǤ
 */
typedef	UINT	IPM;		/* ߥޥ */

extern ER	chg_ipm(IPM ipm) throw();
extern ER	get_ipm(IPM *p_ipm) throw();

/*
 *  SILϢ
 */


/*
 *  ߤγߥޥɽФ
 */
#define _current_intmask_	current_intmask

/*
 *  ߥޥ
 */
#define _set_intmask_		set_intmask

/*
 *  NMI٤Ƥγߤػ
 *  disint()ͥ뤬ߤΤߤػߤΤФ
 *  _disint_()ϥͥγߤޤƶػߤ롣
 *  ŪˤGDB stubΥꥢߤΰۤʤ롣
 */
Inline void
_disint_(void)
{
	UW sr;

	Asm("stc  sr,%0" : "=r"(sr));
	sr |= 0x000000f0u;
	Asm("ldc %0, sr" : : "r"(sr) : "memory", "t");
}


/*
 *  ߥå֤
 */
#define	SIL_PRE_LOC	UW _intmask_ = _current_intmask_()
#define	SIL_LOC_INT()	_disint_()
#define	SIL_UNL_INT()	_set_intmask_(_intmask_)


#endif /* _MACRO_ONLY */

/*
 *  ץåΥǥ
 */
#define	SIL_ENDIAN	SIL_ENDIAN_BIG	/* ӥåǥ */


#ifndef _MACRO_ONLY
/*
 *  ǽɾѥƥλ
 */

#ifdef SUPPORT_VXGET_TIM
typedef	UD	SYSUTIM;	/* ǽɾѥƥ */

extern ER	vxget_tim(SYSUTIM *p_sysutim) throw();

#endif /*  SUPPORT_VXGET_TIM  */

#endif /* _MACRO_ONLY */


#endif /* _CPU_DEFS_H_ */
