/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 *  Copyright (C) 2006 by GJ Business Division RICOH COMPANY,LTD. JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id$
 */

/*
 *  SH7047¢ꥢ륳ߥ˥󥤥󥿡եSCI ʰץɥ饤
 */

#include <s_services.h>
#include "sh7047.h"
#include "sh7047scif.h"

/*
 *  ꥢI/OݡȽ֥å
 */
static const SIOPINIB siopinib_table[TNUM_PORT] = {
	{
		(IOREG_SCI_BASE+IOREG_SCI_WINDOW*1),
		(IOREG_INTC_BASE+IOREG_IPRI_OFFSET),
		9,
		ISR_SCR3_SHIFT
	},
	{
		(IOREG_SCI_BASE+IOREG_SCI_WINDOW*2),
		(IOREG_INTC_BASE+IOREG_IPRI_OFFSET),
		8,
		ISR_SCR4_SHIFT
	}
};

/*
 *  ꥢI/Oݡȴ֥åΥꥢ
 *      ID = 1 SCI3бƤ.
 */
SIOPCB siopcb_table[TNUM_PORT];

/*
 *  ꥢI/OݡID֥åФΥޥ
 */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  ʸǤ뤫
 */
Inline BOOL
sh7047scif_getready (SIOPCB * siopcb)
{
	/* 쥷֥ǡ쥸ե롦ե饰Υå */
	return (sil_reb_mem((VP)(siopcb->siopinib->cntrl+IOREG_SSR_OFFSET)) & SSR_RDRF);
}

/*
 *  ʸǤ뤫
 */
Inline BOOL
sh7047scif_putready (SIOPCB * siopcb)
{
	/* ȥ󥹥ߥåFIFOǡ쥸ץƥե饰Υå */
	return (sil_reb_mem((VP)(siopcb->siopinib->cntrl+IOREG_SSR_OFFSET)) & SSR_TDRE);
}

/*
 *  ʸμФ
 */
Inline char
sh7047scif_getchar (SIOPCB * siopcb)
{
	VB data;

	data = sil_reb_mem((VP)(siopcb->siopinib->cntrl+IOREG_RDR_OFFSET));
	/* 쥷֥ǡ쥸ե롦ե饰Υꥢ */
	sil_wrb_mem((VP)(siopcb->siopinib->cntrl+IOREG_SSR_OFFSET),
		sil_reb_mem((VP)(siopcb->siopinib->cntrl+IOREG_SSR_OFFSET)) & ~SSR_RDRF);
	return data;
}

/*
 *  ʸν
 */
Inline void
sh7047scif_putchar (SIOPCB * siopcb, char c)
{
	sil_wrb_mem((VP)(siopcb->siopinib->cntrl+IOREG_TDR_OFFSET), c);
	/* ȥ󥹥ߥåFIFOǡ쥸ץƥե饰Υꥢ */
	sil_wrb_mem((VP)(siopcb->siopinib->cntrl+IOREG_SSR_OFFSET),
		sil_reb_mem((VP)(siopcb->siopinib->cntrl+IOREG_SSR_OFFSET)) & ~SSR_TDRE);
}

/*
 *  SIOɥ饤Фν롼
 */
void
sh7047scif_initialize ()
{
	SIOPCB *siopcb;
	UINT i;

	/*
     *  ꥢI/Oݡȴ֥åν
     */
	for (siopcb = siopcb_table, i = 0; i < TNUM_PORT; siopcb++, i++) {
		siopcb->siopinib = &siopinib_table[i];
		siopcb->openflag = FALSE;
	}
}

/*
 *  ץ󤷤ƤݡȤϤ뤫
 */
BOOL
sh7047scif_openflag (ID siopid)
{
	if(siopcb_table[INDEX_SIOP(siopid)].openflag)
		return TRUE;
	sil_dly_nse(sh2scif_DELAY*4);	/* Wait for Banner */
	return FALSE;
}

/*
 *  ꥢI/OݡȤΥץ
 */
SIOPCB *
sh7047scif_opn_por (ID siopid, VP_INT exinf)
{
	SIOPCB *siopcb;
	UW     base;
	unsigned char  dummy;

	siopcb = get_siopcb (siopid);
	base   = siopcb->siopinib->cntrl;
	/*  */
	sil_wrb_mem((VP)(base+IOREG_SCR_OFFSET),
		 sil_reb_mem((VP)(base+IOREG_SCR_OFFSET)) & ~(SCR_TE | SCR_RE));
	/* ⡼ɥ쥸 */
	sil_wrb_mem((VP)(base+IOREG_SMR_OFFSET), DEFAULT_SMR);
	/* ܡ졼Ȥ */
	sil_wrb_mem((VP)(base+IOREG_BRR_OFFSET), DEFAULT_BRR);

	sil_dly_nse(sh2scif_DELAY);
	/* ߵ */
	sil_wrb_mem((VP)(base+IOREG_SCR_OFFSET), SCR_RIE|SCR_TE|SCR_RE);
	dummy = sil_reb_mem((VP)(base+IOREG_SSR_OFFSET));		/* Dummy read */
	/* ߥȥ */
	sil_wrb_mem((VP)(base+IOREG_SSR_OFFSET), SSR_TDRE);		/* Clear error flags */
	siopcb->exinf    = exinf;
	siopcb->openflag = TRUE;
	return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
void
sh7047scif_cls_por (SIOPCB * siopcb)
{
	/* ߡ߶ػ */
	sil_wrb_mem((VP)(siopcb->siopinib->cntrl+IOREG_SCR_OFFSET),
			sil_reb_mem((VP)(siopcb->siopinib->cntrl+IOREG_SCR_OFFSET)) & ~(SCR_TIE|SCR_RIE|SCR_TE|SCR_RE));

	siopcb->openflag = FALSE;
}

/*
 *  ꥢI/OݡȤؤʸ
 */
BOOL
sh7047scif_snd_chr (SIOPCB * siopcb, char c)
{
	if (sh7047scif_putready (siopcb)) {
		sh7047scif_putchar (siopcb, c);
		return (TRUE);
	}
	return (FALSE);
}

/*
 *  ꥢI/OݡȤʸ
 */
INT
sh7047scif_rcv_chr (SIOPCB * siopcb)
{
	if (sh7047scif_getready (siopcb)) {
		return ((INT) (UB) sh7047scif_getchar (siopcb));
	}
	return (-1);
}

/*
 *  ꥢI/OݡȤΥХå
 */
void
sh7047scif_ena_cbr (SIOPCB * siopcb, UINT cbrtn)
{
	UW base = siopcb->siopinib->cntrl;

	switch (cbrtn) {
	case SIO_ERDY_SND:		/* ׵ */
		sil_wrb_mem((VP)(base+IOREG_SCR_OFFSET), sil_reb_mem((VP)(base+IOREG_SCR_OFFSET)) | SCR_TIE);
		break;
	case SIO_ERDY_RCV:		/* ׵ */
		sil_wrb_mem((VP)(base+IOREG_SCR_OFFSET), sil_reb_mem((VP)(base+IOREG_SCR_OFFSET)) | SCR_RIE);
		break;
	default:
		break;
	}
}

/*
 *  ꥢI/OݡȤΥХåػ
 */
void
sh7047scif_dis_cbr (SIOPCB * siopcb, UINT cbrtn)
{
	UW base = siopcb->siopinib->cntrl;

	switch (cbrtn) {
	case SIO_ERDY_SND:		/* ׵ػ */
		sil_wrb_mem((VP)(base+IOREG_SCR_OFFSET), sil_reb_mem((VP)(base+IOREG_SCR_OFFSET)) & ~SCR_TIE);
		break;
	case SIO_ERDY_RCV:		/* ׵ػ */
		sil_wrb_mem((VP)(base+IOREG_SCR_OFFSET), sil_reb_mem((VP)(base+IOREG_SCR_OFFSET)) & ~SCR_RIE);
		break;
	default:
		break;
	}
}

/*
 *  ꥢI/OݡȤФ߽
 */
Inline void
sh7047scif_isr_siop_out (SIOPCB * siopcb)
{
	VB scr0 = sil_reb_mem((VP)(siopcb->siopinib->cntrl+IOREG_SCR_OFFSET));

	if ((scr0 & SCR_TIE) != 0 && sh7047scif_putready (siopcb)) {
		/*
		 *  ΥХå롼ƤӽФ
		 */
		sh7047scif_ierdy_snd (siopcb->exinf);
	}
}

/*
 *  ꥢI/OݡȤФ߽
 */
Inline void
sh7047scif_isr_siop_in (SIOPCB * siopcb)
{
	VB scr0 = sil_reb_mem((VP)(siopcb->siopinib->cntrl+IOREG_SCR_OFFSET));

	if ((scr0 & SCR_RIE) != 0 && sh7047scif_getready (siopcb)) {
		/*
		 *  ΥХå롼ƤӽФ
		 */
		sh7047scif_ierdy_rcv (siopcb->exinf);
	}
}

/*
 *  SIOߥӥ롼(SCI3)
 */
void
sh7047scif3_isr_out ()
{
	if (siopcb_table[0].openflag) {
		sh7047scif_isr_siop_out (&(siopcb_table[0]));
	}
}

/*
 *  SIOߥӥ롼(SCI4)
 */
void
sh7047scif4_isr_out ()
{
	if (siopcb_table[1].openflag) {
		sh7047scif_isr_siop_out (&(siopcb_table[1]));
	}
}

/*
 *  SIOߥӥ롼(SCI3)
 */
void
sh7047scif3_isr_in ()
{
	if (siopcb_table[0].openflag) {
		sh7047scif_isr_siop_in (&(siopcb_table[0]));
	}
}

/*
 *  SIOߥӥ롼(SCI4)
 */
void
sh7047scif4_isr_in ()
{
	if (siopcb_table[1].openflag) {
		sh7047scif_isr_siop_in (&(siopcb_table[1]));
	}
}

/*
 *  SIO顼ߥӥ롼(SCI3)
 */
void
sh7047scif3_isr_error (void)
{
	UW base = siopcb_table[0].siopinib->cntrl;

	if (siopcb_table[0].openflag) {
		sil_wrb_mem((VP)(base+IOREG_SSR_OFFSET), sil_reb_mem((VP)(base+IOREG_SSR_OFFSET)) & ~(SSR_OPER|SSR_FER|SSR_PER));
	}
}

/*
 *  SIO顼ߥӥ롼(SCI4)
 */
void
sh7047scif4_isr_error (void)
{
	UW base = siopcb_table[1].siopinib->cntrl;

	if (siopcb_table[1].openflag) {
		sil_wrb_mem((VP)(base+IOREG_SSR_OFFSET), sil_reb_mem((VP)(base+IOREG_SSR_OFFSET)) & ~(SSR_OPER|SSR_FER|SSR_PER));
	}
}


