/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2000-2003 by Industrial Technology Institute,
 *                              Miyagi Prefectural Government, JAPAN
 *  Copyright (C) 2002-2004 by Hokkaido Industrial Research Institute, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sh7615scif.c,v 1.3 2005/07/06 00:45:07 honda Exp $
 */

/*
 *   SH2¢ꥢ륳ߥ˥󥤥󥿥եSCIF ʰץɥ饤
 */

#include <s_services.h>
#include "sh7615scif.h"

/*
 *  ꥢI/Oݡȴ֥å
 */
/* ϥݡȤsys_config.c */
/* ߥ٥ֹhw_serial.h */
/* ֥åsh7615scif.c */

#ifndef GDB_STUB

const SIOPINIB siopinib_table[TNUM_PORT] = {
	{0xfffffcc0, BRR9600, 0x0, 6}, /* SCIF1 */
#if TNUM_PORT >= 2
	{0xfffffce0, BRR9600, 0x0, 6}, /* SCIF2 */
#endif /* TNUM_PORT >= 2 */
};

#else /* GDB_STUB */

const SIOPINIB siopinib_table[TNUM_PORT] = {
	{0xfffffce0, BRR9600, 0x0, 6}, /* SCIF2 */
};

#endif /* GDB_STUB */

#if defined(TTM)
/*
 *  ꥢI/Oݡȴ֥å
 *  2chݡȤ˳ĥϽѤΥǡޤ
 */
struct sio_port_control_block
{
	VP_INT exinf;				/* ĥ */
	BOOL openflag;				/* ץѤߥե饰 */
};
#endif
/*
 *  ꥢI/Oݡȴ֥åΥꥢ
 */
static SIOPCB siopcb_table[TNUM_PORT];

/*
 *  ꥢI/OݡID֥åФΥޥ
 */
#define INDEX_SIOP(siopid)	((UINT)((siopid) - 1))
#define get_siopcb(siopid)	(&(siopcb_table[INDEX_SIOP(siopid)]))

/*
 *  ʸǤ뤫
 */
Inline BOOL
sh2scif_getready (SIOPCB * siopcb)
{
	/*  쥷֥ǡ쥸ե롦ե饰Υå  */
	return (sil_reh_mem ((VH *) (siopcb->siopinib->reg_base + SCIF_SC1SSR)) &
			SC1SSR_RDRF);
}

/*
 *  ʸǤ뤫
 */
Inline BOOL
sh2scif_putready (SIOPCB * siopcb)
{
	/*  ȥ󥹥ߥåFIFOǡ쥸ץƥե饰Υå */
	return (sil_reh_mem ((VH *) (siopcb->siopinib->reg_base + SCIF_SC1SSR)) &
			SC1SSR_TDFE);
}

/*
 *  ʸμФ
 */
Inline char
sh2scif_getchar (SIOPCB * siopcb)
{
	VB data;

	data = sil_reb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCFRDR));
	/*  쥷֥ǡ쥸ե롦ե饰Υꥢ  */
	sil_wrh_mem ((VH *) (siopcb->siopinib->reg_base + SCIF_SC1SSR),
				 sil_reh_mem ((VH *) (siopcb->siopinib->reg_base +
									  SCIF_SC1SSR)) & ~SC1SSR_RDRF);
	return data;
}

/*
 *  ʸν
 */
Inline void
sh2scif_putchar (SIOPCB * siopcb, char c)
{
	/*  ȥ󥹥ߥåFIFOǡ쥸ץƥե饰Υꥢ */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCFTDR), c);
	sil_wrh_mem ((VH *) (siopcb->siopinib->reg_base + SCIF_SC1SSR),
				 sil_reh_mem ((VH *) (siopcb->siopinib->reg_base +
									  SCIF_SC1SSR)) & ~SC1SSR_TDFE);
}

/*
 *  SIOɥ饤Фν롼
 */
void
sh2scif_initialize ()
{
	SIOPCB *siopcb;
	UINT i;

	/*
	 *  륢I/Oݡȴ֥åν
	 */
	for (siopcb = siopcb_table, i = 0; i < TNUM_PORT; siopcb++, i++) {
		siopcb->openflag = FALSE;
		siopcb->siopinib = (&siopinib_table[i]);
	}
}

/*
 *  ץ󤷤ƤݡȤ뤫
 */
BOOL
sh2scif_openflag (ID siopid)
{
	return (siopcb_table[siopid - 1].openflag);
}

/*
 *  ꥢI/OݡȤΥץ
 */
SIOPCB *
sh2scif_opn_por (ID siopid, VP_INT exinf)
{
	SIOPCB *siopcb;

	siopcb = get_siopcb (siopid);

	/*    */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCSCR),
				 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
									  SCIF_SCSCR)) & ~(SCSCR_TE | SCSCR_RE));

	/*  SCIǡϥݡȤ  */
	/*  ԥ󥢥 */
	/* sys_initialize */

	/*  FIFOν  */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCFCR),
				 (VB) (SCFCR_TFRST | SCFCR_RFRST));

	/*  եޥå  */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCSMR), 0x00);
	/*  ĴƱ  */
	/*  8ӥåȡѥƥʤ  */
	/*  ȥåץӥåȥ󥰥1   */
	/*  å쥯 */

	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCBRR), (VB) siopcb->siopinib->brr);	/* ܡ졼 */


	/*
	 * ܡ졼Ȥ塢1ʬԤʤФʤʤ
	 */
	sil_dly_nse (sh2scif_DELAY);	/* ͤϣ裱Ʊ */

	/*  FIFO  */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCFCR), 0x00);

	/* 顼ե饰򥯥ꥢ */
	sil_wrh_mem ((VH *) (siopcb->siopinib->reg_base + SCIF_SC1SSR),
				 sil_reh_mem ((VH *) (siopcb->siopinib->reg_base +
									  SCIF_SC1SSR)) & ~SC1SSR_ER);

	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCSCR),
				 (VB) (SCSCR_RIE | SCSCR_TE | SCSCR_RE));

	siopcb->exinf = exinf;
	siopcb->openflag = TRUE;
	return (siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
void
sh2scif_cls_por (SIOPCB * siopcb)
{
	/*  ߡ߶ػ  */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCSCR),
				 (VB) ~ (SCSCR_TIE | SCSCR_RIE | SCSCR_TE | SCSCR_RE));

	siopcb->openflag = FALSE;
}

/*
 *  ꥢI/OݡȤؤʸ
 */
BOOL
sh2scif_snd_chr (SIOPCB * siopcb, char c)
{
	if (sh2scif_putready (siopcb)) {
		sh2scif_putchar (siopcb, c);
		return (TRUE);
	}
	return (FALSE);
}

/*
 *  ꥢI/OݡȤʸ
 */
INT
sh2scif_rcv_chr (SIOPCB * siopcb)
{
	if (sh2scif_getready (siopcb)) {
		return ((INT) (UB) sh2scif_getchar (siopcb));
	}
	return (-1);
}

/*
 *  ꥢI/OݡȤΥХåε
 */
void
sh2scif_ena_cbr (SIOPCB * siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:			/* ׵ */
		sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCSCR),
					 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
										  SCIF_SCSCR)) | SCSCR_TIE);
		break;
	case SIO_ERDY_RCV:			/* ׵ */
		sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCSCR),
					 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
										  SCIF_SCSCR)) | SCSCR_RIE);
		break;
	}
}

/*
 *  ꥢI/OݡȤΥХåζػ
 */
void
sh2scif_dis_cbr (SIOPCB * siopcb, UINT cbrtn)
{
	switch (cbrtn) {
	case SIO_ERDY_SND:			/* ׵ػ */
		sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCSCR),
					 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
										  SCIF_SCSCR)) & ~SCSCR_TIE);
		break;
	case SIO_ERDY_RCV:			/* ׵ػ */
		sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCSCR),
					 sil_reb_mem ((VB *) (siopcb->siopinib->reg_base +
										  SCIF_SCSCR)) & ~SCSCR_RIE);
		break;
	}
}

/*
 *  ꥢI/OݡȤФ߽
 */
Inline void
sh2scif_isr_siop_out (SIOPCB * siopcb)
{
	VB scr0 = sil_reb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCSCR));

	if ((scr0 & SCSCR_TIE) != 0 && sh2scif_putready (siopcb)) {
		/*
		 *  ΥХå롼ƤӽФ
		 */
		sh2scif_ierdy_snd (siopcb->exinf);
	}
}

/*
 *  ꥢI/OݡȤФ߽
 */
Inline void
sh2scif_isr_siop_in (SIOPCB * siopcb)
{
	VB scr0 = sil_reb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCSCR));

	if ((scr0 & SCSCR_RIE) != 0 && sh2scif_getready (siopcb)) {
		/*
		 *  ΥХå롼ƤӽФ
		 */
		sh2scif_ierdy_rcv (siopcb->exinf);
	}
}

/*
 *  ꥢI/OݡȤФ顼߽
 */
Inline void
sh2scif_isr_siop_err (SIOPCB * siopcb)
{
	/* 顼ե饰򥯥ꥢ */
	sil_wrh_mem ((VH *) (siopcb->siopinib->reg_base + SCIF_SC1SSR),
				 sil_reh_mem ((VH *) (siopcb->siopinib->reg_base +
									  SCIF_SC1SSR)) & ~SC1SSR_ER);
	/*  FIFOν  */
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCFCR),
				 (VB) SCFCR_RFRST);
	sil_wrb_mem ((VB *) (siopcb->siopinib->reg_base + SCIF_SCFCR), 0x30);
}

/* ֥졼н */
/* ե饰ꥻåȤ */
Inline void
sh2scif_isr_siop_brk (SIOPCB * siopcb)
{
	/* ե饰򥯥ꥢ */
	sil_wrh_mem ((VH *) (siopcb->siopinib->reg_base + SCIF_SC1SSR),
				 sil_reh_mem ((VH *) (siopcb->siopinib->reg_base +
									  SCIF_SC1SSR)) & ~SC1SSR_BRK);
}

/*
 *  SCIߥӥ롼 裱Ʊ
 *  
 *  SH1¢SCIǤϳֹ椬̡̤ͥʬƤΤǡ
 *  SCI0߰ʳǤΥ롼󤬸ƤФ뤳ȤϤʤ
 *  
 */
void
sh2scif_isr_out ()
{
	if (siopcb_table[0].openflag) {
		sh2scif_isr_siop_out (get_siopcb (1));
	}
}

/*
 *  SCIߥӥ롼󡡣裱Ʊ
 *  
 *  SH1¢SCIǤϳֹ椬̡̤ͥʬƤΤǡ
 *  SCI0μ߰ʳǤΥ롼󤬸ƤФ뤳ȤϤʤ
 *  
 */
void
sh2scif_isr_in ()
{
	if (siopcb_table[0].openflag) {
		sh2scif_isr_siop_in (get_siopcb (1));
	}
}

/*
 *  SIO顼ߥӥ롼󡡣裱Ʊ
 *  
 *  SH1¢SCIǤϳֹ椬̤ͥʬƤΤǡ
 *  SCI0μ顼߰ʳǤΥ롼󤬸ƤФ뤳ȤϤʤ
 *  
 *  顼Τϥ顼ե饰ΥꥢΤߤˤȤɤƤ롣
 *  С󥨥顼
 *  ե졼ߥ󥰥顼
 *  ѥƥ顼
 */
void
sh2scif_isr_error (void)
{

	if (siopcb_table[0].openflag) {
		sh2scif_isr_siop_err (get_siopcb (1));
	}
}

/* ֥졼 */
void
sh2scif_isr_brk (void)
{

	if (siopcb_table[0].openflag) {
		sh2scif_isr_siop_brk (get_siopcb (1));
	}
}

/*
 * ݡ󥰤ˤʸ
 */
void
sh2scif_putc_pol (ID portid, char c)
{
	while (!sh2scif_putready (&siopcb_table[portid - 1]));
	sh2scif_putchar (&siopcb_table[portid - 1], c);
}

#if TNUM_PORT >= 2
/*
 *  SCIߥӥ롼
 *  
 */
void
sh2scif_isr2_in (void)
{
	if (siopcb_table[1].openflag) {
		sh2scif_isr_siop_in (get_siopcb (2));
	}
}

/*
 *  SCIߥӥ롼
 *  
 */
void
sh2scif_isr2_out (void)
{
	if (siopcb_table[1].openflag) {
		sh2scif_isr_siop_out (get_siopcb (2));
	}
}

/*
 *  SCI顼ߥӥ롼
 */
void
sh2scif_isr2_error (void)
{
	if (siopcb_table[1].openflag) {
		sh2scif_isr_siop_err (get_siopcb (2));
	}
}

/* ֥졼 */
void
sh2scif_isr2_brk (void)
{

	if (siopcb_table[1].openflag) {
		sh2scif_isr_siop_brk (get_siopcb (2));
	}
}
#endif /* of #if TNUM_PORT >= 2 */
