/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_config.c,v 1.24 2006/04/10 09:58:15 honda Exp $
 */

/*
 *  ץå¸⥸塼SH3/4ѡ
 */
#include <s_services.h>
#include "jsp_kernel.h"
#include "check.h"
#include "task.h"

/*
 *  ƥȤǤγߥޥ
 */
#ifdef SUPPORT_CHG_IPM
UW	task_intmask;
#endif /* SUPPORT_CHG_IPM */


/*
 *  󥿥ƥȤǤγߥޥ
 */
UW	int_intmask;


/*
 * ߥϥɥ/ͥ٤εơ֥
 */
FP  int_table[(MAX_INTIVT>>5) + 1];
VW  int_plevel_table[(MAX_INTIVT>>5) + 1];


/*
 * CPU㳰ϥɥεơ֥
 */
FP	exc_table[(0x1E0 >> 5) + 1];


/*
 *  ץå¸ν
 */
void
cpu_initialize()
{
    int i;
    
    /*
     *  ƥȤǤγߥޥν
     */
#ifdef SUPPORT_CHG_IPM
    task_intmask = 0x0000;    
#endif /* SUPPORT_CHG_IPM */
    
    /*
     * int_table[],int_plevel_table[]ν
     * ̤Ͽγȯcpu_interrup()ƤӽФ褦
     * no_reg_interrup()Ͽ
     * ǥեȤint_plevel_table[]γͥ٤MAX_IPM - 1
     * Ȥ롥
     */
    for(i = 0; i < ((MAX_INTIVT>>5) + 1); i++){
        int_table[i] = no_reg_interrupt;
        int_plevel_table[i] = 0x40000000 | (MAX_IPM - 1) << 4;
    }
    
#ifndef GDB_STUB
    /*
     * ߥȥν 
     */
#if defined(SH7750)
    sil_wrh_mem((VP)ICR, 0x0000);
    sil_wrh_mem((VP)IPRA, 0x0000);
    sil_wrh_mem((VP)IPRB, 0x0000);
    sil_wrh_mem((VP)IPRC, 0x0000);
#else /* SH7708 || SH7709 || SH7709A || SH7729R || SH7727 */   
    sil_wrh_mem((VP)ICR0, 0x0000);
    sil_wrh_mem((VP)IPRA, 0x0000);     
    sil_wrh_mem((VP)IPRB, 0x0000);
#if defined(SH7709) || defined(SH7709A) || defined(SH7729R) || defined(SH7727) 
    sil_wrh_mem((VP)ICR1, 0x4000);
    sil_wrh_mem((VP)ICR2, 0x0000);     
    sil_wrh_mem((VP)PINTER, 0x0000);
    sil_wrh_mem((VP)IPRC, 0x0000);
    sil_wrh_mem((VP)IPRD, 0x0000);
    sil_wrh_mem((VP)IPRE, 0x0000);
    sil_wrb_mem((VP)IRR0, 0x0000);   
    sil_wrb_mem((VP)IRR1, 0x0000);
    sil_wrb_mem((VP)IRR2, 0x0000);
#endif /* SH7709 || SH7709A  */   
#endif /* SH7750 */
    
    /*
     *  ٥١쥸ν
     */
    set_vbr(BASE_VBR);
    
#endif /* GDB_STUB */
}


/*
 *  ץå¸νλ
 */
void
cpu_terminate()
{
}


/*
 * Trapaʳ㳰ϿƤʤ㳰ȯȸƤӽФ
 */
void
cpu_expevt(VW expevt,VW spc,VW ssr,VW pr)
{
    syslog(LOG_EMERG, "Unregistered Expevt error occurs.");
    syslog(LOG_EMERG, "Expevt = %08x SPC = %08x SR = %08x PR=%08X",
           expevt,spc,ssr,pr);
    while(1);
}

/*
 * ̤Ͽγߤȯ˸ƤӽФ
 */
void
cpu_interrupt(VW intevt, VW intevt2,VW spc,VW ssr)
{
    syslog(LOG_EMERG, "Unregistered Interrupt occurs.");
#if defined(SH7709) || defined(SH7709A) || defined(SH7729R) || defined(SH7727) 
    syslog(LOG_EMERG, "INTEVT = %08x INTEVT2 = %08x SPC = %08x SR = %08x ",
           intevt,intevt2,spc,ssr);
#else /* SH7708 || SH7750 */   
    syslog(LOG_EMERG, "INTEVT = %08x  SPC = %08x SR = %08x ",intevt,spc,ssr);
#endif    
    while(1);
}



#ifdef SUPPORT_CHG_IPM

/*
 *  ߥޥѹ
 *
 *  chg_ipm Ȥä IPM  MAX_IPM NMI ֥⡼ȥ֥졼 ʳ
 *  Τ٤Ƥγߤػߡ˰ʾѹ뤳ȤϤǤʤNMI ֥
 *  ⡼ȥ֥졼ʳΤ٤Ƥγߤػߤˤϡloc_cpu 
 *  CPUå֤ˤФ褤IPM  0 ʳλˤ⡤ǥ
 *  ѥåαʤIPM ϡǥѥåˤäơ
 *  Ծ֤ˤʤäذѤ롥Τᡤ¹ˡ
 *  Υˤä IPM ѹ礬롥JSPͥǤϡIPM
 *  ѹϥ㳰롼ˤäƤⵯΤǡˤäư
 *  񤷤ʤϾʤȻפ롥IPM ͤˤäƥǥ
 *  ѥåػߤˤϡdis_dsp ʻѤФ褤
 */

SYSCALL ER
chg_ipm(IPM ipm)
{
    ER  ercd;
    
    LOG_CHG_IPM_ENTER(ipm);
	CHECK_TSKCTX_UNL();
	CHECK_PAR(0 <= ipm && ipm <= MAX_IPM - 1);

	t_lock_cpu();
	task_intmask = (ipm << 4);
    ercd = E_OK;
	t_unlock_cpu();

  exit:
    LOG_CHG_IPM_LEAVE(ercd);
    return(ercd);
}


/*
 *  ߥޥλ
 */
SYSCALL ER
get_ipm(IPM *p_ipm)
{
    ER  ercd;

    LOG_GET_IPM_ENTER(p_ipm);
	CHECK_TSKCTX_UNL();

	t_lock_cpu();
	*p_ipm = (task_intmask >> 4);
    ercd = E_OK;
	t_unlock_cpu();

  exit:
    LOG_GET_IPM_LEAVE(ercd, *p_ipm);
    return(ercd);
}

#endif /* SUPPORT_CHG_IPM */
