/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: hw_serial.h,v 1.9 2005/07/28 06:56:29 honda Exp $
 */

/*
 *  ꥢI/OǥХSIO˥ɥ饤СMS7717CP01ѡ
 *  
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>

#include <sh3.h>
#include <ms7727cp01.h>
#include <st16c2550.h>

/*
 *  ꥢγߥϥɥΥ٥ֹ(ͥ)
 */
#define INHNO_SIO   ST16C2550_INT

/*
 * ߥ٥
 */
#define SIO_INTLVL   8

/*
 *  SIOɥ饤Фν롼
 */
#define sio_initialize  st16c2550_initialize

#ifndef _MACRO_ONLY
/*
 *  ꥢI/OݡȤΥץ
 */
Inline SIOPCB *
sio_opn_por(ID siopid, VP_INT exinf)
{
    SIOPCB  *siopcb;
    BOOL    openflag;

    /*
     *  ץ󤷤ݡȤ뤫 openflg ɤǤ
     */
    openflag = st16c2550_openflag();
    
    /*
     *  ǥХ¸Υץ
     */
    siopcb = st16c2550_opn_por(siopid, exinf);

    /*
     * ߴϢ
     * 顼ϥɥϿ٤
     */
    if(!openflag){
        define_int_plevel(INHNO_SIO,SIO_INTLVL);     /* SWͥ */
        sil_wrh_mem((VP)IPRD,                        /* HWͥ */  
                    (sil_reh_mem((VP)IPRD) | (SIO_INTLVL << 12))); 
        /* PINT֥͡ */
        sil_wrh_mem((VP)PINTER,
                    (sil_reh_mem((VP)PINTER) | siopcb->siopinib->pinter_val));
    }

    return(siopcb);
}

/*
 *  ꥢI/OݡȤΥ
 */
Inline void
sio_cls_por(SIOPCB *siopcb)
{
    /*
     *  ǥХ¸Υ
     */
    st16c2550_cls_por(siopcb);
}


/*
 *  SIOγߥϥɥ
 */
#define sio_handler st16c2550_isr

/*
 *  ꥢI/OݡȤؤʸ
 */
#define sio_snd_chr st16c2550_snd_chr

/*
 *  ꥢI/OݡȤʸ
 */
#define sio_rcv_chr st16c2550_rcv_chr

/*
 *  ꥢI/OݡȤΥХåε
 */
#define sio_ena_cbr st16c2550_ena_cbr

/*
 *  ꥢI/OݡȤΥХåζػ
 */
#define sio_dis_cbr st16c2550_dis_cbr

/*
 *  ꥢI/OݡȤǽХå
 */
#define sio_ierdy_snd   st16c2550_ierdy_snd

/*
 *  ꥢI/OݡȤμΥХå
 */
#define sio_ierdy_rcv   st16c2550_ierdy_rcv

#endif /* _MACRO_ONLY */
#endif /* _HW_SERIAL_H_ */
