/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                                  Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id: start.S,v 1.10 2003/12/11 00:52:12 honda Exp $
 */
        
/*
 *  ͥѤΥȥåץ⥸塼
 */               
#define _MACRO_ONLY
#include <t_config.h>
#include <sys_defs.h>
        
/*
 *   SH3ѥȥåץ⥸塼
 *   ͥϥץꥱȥ󥯤ƻѤ
 *   ʤΤJSPͥΤ߻Ѥ롣	
 */
	.global	_start
	.align 2
_start:
	/*
	 *  åν
	 */
	mov.l _ccr_addr,r1
	mov.l _ccr_disable,r2
	mov.l r2,@r1
	mov.l _ccr_mode,r2
	mov.l r2,@r1

	/*
	 *  SR롣
	 *  MD=1, RB=0, BL=0, I3I0=e fstubΤ
	 */
	mov.l _init_sr,r0
	ldc   r0,sr
	mov   #0x01,r0
	ldc   r0,r7_bank
	/*
	 * ΩΥåSTACKTOP˽
	 * STACKTOPϡsys_config.h
	 */
	mov.l  _stack_k, r15

	/*
	 *  _hardware_init_hook ƤӽФ(0Ǥʤ)
	 *
	 *  ϡɥ¸ɬפʽϡ
	 *  hardware_init_hook ȤؿѰդФ褤
	 *  ŪˤROMκݡRAMѲǽˤ뤿
	 *  ХȥνԤ
	 *  sys_support.S  _hardware_init_hook Ƥ
	 *  롥
	 */

start_0:
	mov.l  _hardware_init_hook_k, r0
	tst    r0,r0
	bt     start_1
	jsr    @r0
     or      r0,r0

	
	/*
     * bss򥯥ꥢ
	 */
start_1:		
	mov.l	_bss_start_k,r0
	mov.l	_end_k,r1
	cmp/eq  r0,r1
	bt      start_3
	mov	    #0,r2
start_2:
    mov.l	r2,@r0
	add	#4,r0
 	cmp/hi	r0,r1
	bt	start_2

	/*
	 *  dataROMбˡ
	 *
	 *  __idata_start  __idata_end ޤǤ__data_start ʹߤ
	 *  ԡ롥
	 */
start_3:
	mov.l   __idata_start_k,r1
	mov.l   __idata_end_k,r2
	cmp/eq  r1,r2
	bt      start_5
	mov.l   __data_start_k,r0
start_4:	
	mov.l   @r1+,r4
	mov.l   r4,@r0
	cmp/hi  r1,r2
	add     #4,r0
	bt      start_4

		
	/*
	 *  _software_init_hook ƤӽФ0 Ǥʤˡ
	 *
	 *  եȥĶä˥饤֥ˤ˰¸ɬפʽ
	 *  ϡsoftware_init_hook ȤؿѰդ
	 *  褤
	 */
start_5:	
	mov.l  _software_init_hook_k, r0
	tst    r0,r0
	bt     start_6		
	jsr    @r0
	or     r0,r0

		
start_6:
	/*	
     *  ͥư
	 */
	! call the mainline
	mov.l _kernel_start_k,r0
	jsr	  @r0
     or	   r0,r0


	.align 4
_ccr_addr:	
	.long CCR
_ccr_disable:	
	.long CCR_DISABLE
_ccr_mode:	
	.long CCR_MODE
_init_sr:	
	.long  0x40000000 + MAX_IPM << 4
_stack_k:	
	.long   STACKTOP
_bss_start_k:	
	.long   __bss_start	
_end_k:	
	.long  	_end	
__idata_start_k:	
	.long 	__idata_start
__idata_end_k:	
	.long   __idata_end
__data_start_k:	
	.long  	__data_start	
_kernel_start_k:	
	.long	_kernel_start
_hardware_init_hook_k:	
	.long   _hardware_init_hook
_software_init_hook_k:	
	.long   _software_init_hook	


















