/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2006-2010 by Witz Corporation, JAPAN
 * 
 *  The above copyright holders grant permission gratis to use,
 *  duplicate, modify, or redistribute (hereafter called use) this
 *  software (including the one made by modifying this software),
 *  provided that the following four conditions (1) through (4) are
 *  satisfied.
 * 
 *  (1) When this software is used in the form of source code, the above
 *      copyright notice, this use conditions, and the disclaimer shown
 *      below must be retained in the source code without modification.
 * 
 *  (2) When this software is redistributed in the forms usable for the
 *      development of other software, such as in library form, the above
 *      copyright notice, this use conditions, and the disclaimer shown
 *      below must be shown without modification in the document provided
 *      with the redistributed software, such as the user manual.
 * 
 *  (3) When this software is redistributed in the forms unusable for the
 *      development of other software, such as the case when the software
 *      is embedded in a piece of equipment, either of the following two
 *      conditions must be satisfied:
 * 
 *    (a) The above copyright notice, this use conditions, and the
 *           disclaimer shown below must be shown without modification in
 *        the document provided with the redistributed software, such as
 *        the user manual.
 * 
 *    (b) How the software is to be redistributed must be reported to the
 *        TOPPERS Project according to the procedure described
 *        separately.
 * 
 *  (4) The above copyright holders and the TOPPERS Project are exempt
 *      from responsibility for any type of damage directly or indirectly
 *      caused from the use of this software and are indemnified by any
 *      users or end users of this software from any and all causes of
 *      action whatsoever.
 * 
 *  THIS SOFTWARE IS PROVIDED "AS IS." THE ABOVE COPYRIGHT HOLDERS AND
 *  THE TOPPERS PROJECT DISCLAIM ANY EXPRESS OR IMPLIED WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, ITS APPLICABILITY TO A PARTICULAR
 *  PURPOSE. IN NO EVENT SHALL THE ABOVE COPYRIGHT HOLDERS AND THE
 *  TOPPERS PROJECT BE LIABLE FOR ANY TYPE OF DAMAGE DIRECTLY OR
 *  INDIRECTLY CAUSED FROM THE USE OF THIS SOFTWARE.
 * 
 *  嵭Ԥϡʲ (1)(4) ξ˸¤ꡤܥեȥ
 *  ܥեȥѤΤޤࡥʲƱˤѡʣѡ
 *  ۡʰʲѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ǤǺۤˤϡۤȼɥȡѼԥ
 *      ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ̵
 *      ڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ǤʤǺۤˤϡΤ줫ξȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡޤ
 *      ܥեȥΥ桼ޤϥɥ桼Τʤͳ˴
 *      ᤫ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơλŪФ
 *  ŬޤơʤݾڤԤʤޤܥեȥ
 *  ˤľŪޤϴŪʤ»˴ؤƤ⡤Ǥ
 *  ʤ
 * 
 *  @(#) $Id: makeoffset.c,v 1.1 2006/04/10 08:19:25 honda Exp $
 */


/*
 *	offset.inc (⤷ offset.h) ˤĤ
 *
 *	  offset.inc Ϲ¤ΤǤ¤ΤƬ鲿Хܤ
 *	¸ߤ뤫ȤȤ, ΥӥåȥեɤƬ
 *	Хβӥåܤ¸ߤ뤫, Ȥ
 *	֥եͿ뤿¸ߤƤ.
 *
 *	  offset.inc եȤ, ñʤ륷ܥեǤ.
 *	ܥȤäƤ륷ܥ̾Τˤϥѥ󤬤,
 *	礭ʬƼ3ʬǤ.
 *
 *	<¤̾>_<̾>	() TCB_sp, TCB_pc, TCB_enatex ʤ
 *	<¤̾>_<̾>_bit	() TCB_enatex_bit ʤ
 *	<¤̾>_<̾>_mask () TCB_enatex_mask ʤ
 *
 *	()
 *		TCB_texptn		equ		14
 *		TCB_sp			equ		20
 *		TCB_pc			equ		24
 *		TCB_enatex		equ		12
 *		TCB_enatex_bit	equ		14
 *		TCB_enatex_mask	equ		0x4000
 *
 *	  ֤ϤǤ¤ΤƬ鲿Хˤ뤫
 *	ȤȤ򼨤ͤˤĤ٥̾.
 *	  ܤΥӥåȥեΥӥåȤ, ̤
 *	ӥåܤˤ뤫ȤȤ򼨤ͤˤĤ٥̾. 
 *	0Ϥޤͤɽ. ǤⲼ̤ΥӥåȤ0ӥåȤǤ.
 *	  ܤۤɤ <¤̾>_<̾>_bit ȤϢ뤬,
 *	ΥӥåȥեΥӥåȤΥޥͤ̾.
 *	*_bit  *_mask ͤδ֤ˤϼδط.
 *		(*_mask) == (1 << *_bit)
 *	() TCB_enatex_bit  14 λ, TCB_enatex_mask  0x4000
 *
 *	  ʤߤTLCS-900L1¸μǤ, ӥåȤΥåʤɤ
 *	ӥå̿ᥢɥå󥰤ѤƤΤ *_mask Ȥ٥
 *	ѤƤʤ.
 */

#include "jsp_kernel.h"
#include "task.h"


void makeoffset(void);

void
makeoffset()
{
	Asm("; BEGIN TCB_texptn\n");
	(((TCB *)0)->texptn) |= (TEXPTN)1;
	Asm("; END");

	Asm("; BEGIN TCB_sp\n");
	(((TCB *)0)->tskctxb.xsp) = (VP)1;
	Asm("; END");

	Asm("; BEGIN TCB_pc\n");
	(((TCB *)0)->tskctxb.pc)();
	Asm("; END");

	Asm("; BEGIN TCB_enatex\n");
	(((TCB *)0)->enatex) = 1;
	Asm("; END");
}

