/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2007-2010 by Monami Software Limited Partnership, JAPAN.
 * 
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 */

/*
 * åȰ¸ꥢI/O⥸塼D70F3716GC ¢Ʊꥢch0ѡ
 *   ǡեޥåȤ8bit data, non-parity, 1stop-bit
 */

#ifndef _HW_SERIAL_H_
#define _HW_SERIAL_H_

#include <s_services.h>

/*
 *  ꥢݡȤν֥å
 */

typedef struct sio_port_initialization_block {
} SIOPINIB;

/*
 *  ꥢݡȤ֥å
 */
typedef struct sio_port_control_block {
	const SIOPINIB	*inib;		/* ֥å	*/
	VP_INT		exinf;		/* ĥ		*/
	BOOL		openflag;	/* ץѤߥե饰	*/
	int			port_id;	/* ݡֹ(0) */
} SIOPCB;

extern SIOPCB siopcb_table[TNUM_PORT];

/*
 *  SIO ID ֥åؤѴޥ
 */

#define INDEX_SIO(sioid)	((UINT)((sioid) - 1))
#define get_siopcb(sioid)	(&(siopcb_table[INDEX_SIO(sioid)]))

/*
 *  Хå롼μֹ
 */

#define SIO_ERDY_SND		1u			/* ǽХå			*/
#define SIO_ERDY_RCV		2u			/* ΥХå			*/


/*
 *  ꥢݡȤΥϡɥ¸
 */

#define SERIAL_PORT				(CONSOLE_PORTID-1)		/* ƥΥݡֹ */
#define SERIAL_INT_PRIORITY		3	/* ͥ */
#define SERIAL_CLKDIV			0x01	/* clk = fxx/2     */
#define SERIAL_COMPAREVALUE		0x82	/* 38400bps */
//#define SERIAL_CLKDIV			0x00	/* clk = fxx/1     */
//#define SERIAL_COMPAREVALUE		0x57	/* 115200bps */


#define FLG_RECEIVED 1

extern volatile unsigned int _serial_flag;


/*
 *  ꥢI/OγߥϥɥΥ٥ֹ
 */
#define INHNO_SERIAL_IN		(0x35)
#define INHNO_SERIAL_OUT	(0x36)

/*
 *  ٥ݡȾ֥åν
 */

#define NUM_PORT	1	/* ݡȤ륷ꥢݡȤο */

/*
 *  ꥢI/OݡȤν
 */
Inline BOOL
hw_port_initialize(int port_id)
{
#ifndef DEBUGGER
	while( (sil_reb_mem((VP)UA0STR) & 0x80) ) ;

	/* Ʊꥢ̿ϩν */

	/* ݡȤ򳫤 */
	if (port_id == 0) {
		sil_wrh_mem((VP)PMC3, sil_reh_mem((VP)PMC3) | 0x0300);
		sil_wrh_mem((VP)PFC3, sil_reh_mem((VP)PFC3) & ~0x0300);
	} else {

	}

	/* ܡ졼ȯν */
	sil_wrb_mem((VP)UA0CTL1, SERIAL_CLKDIV);
	sil_wrb_mem((VP)UA0CTL2, SERIAL_COMPAREVALUE);

	sil_wrb_mem((VP)UA0CTL0, 0x80);	/* enable ASIO */

	__asm("nop; nop");

	/* ѥƥʤ8ӥåȡȥå1ӥåȡLSBե */
	sil_wrb_mem((VP)UA0CTL0, sil_reb_mem((VP)UA0CTL0) | 0x12);

	__asm("nop; nop");

	sil_wrb_mem((VP)UA0CTL0, sil_reb_mem((VP)UA0CTL0) | 0x60);	/* Tx, Rx enable */

	/*  */
	sil_wrb_mem((VP)UA0RIC, SERIAL_INT_PRIORITY);
	sil_wrb_mem((VP)UA0TIC, SERIAL_INT_PRIORITY);
#endif
	return(FALSE);
}

/*
 *  ꥢI/OݡȤνλ
 */
Inline void
hw_port_terminate(int port_id)
{
	sil_wrb_mem((VP)UA0RIC, sil_reb_mem((VP)UA0RIC) | 0x40);
	sil_wrb_mem((VP)UA0TIC, sil_reb_mem((VP)UA0TIC) | 0x40);

	sil_wrb_mem((VP)UA0CTL0, 0x10);	/* Tx, Rx disable */
}

/*
 *  ꥢݡȳߥӥ롼ȡ
 */
extern void	serial_handler_in(int portid);
extern void	serial_handler_out(int portid);

/*
 *  ʸ
 */
Inline BOOL
hw_port_getready(int port_id)
{
	return ((_serial_flag & FLG_RECEIVED) != 0);
}


/*
 *  ʸǤ뤫
 */
Inline BOOL
hw_port_putready(int port_id)
{
	return ((sil_reb_mem((VP)UA0STR) & 0x80) == 0);
}


/*
 *  ʸμФ
 */
Inline unsigned char
hw_port_getchar(int port_id)
{
	_serial_flag &= ~FLG_RECEIVED;
	return sil_reb_mem((VP)UA0RX);
}

/*
 *  ʸν񤭹
 */
Inline void
hw_port_putchar(int port_id, unsigned char c)
{
	sil_wrb_mem((VP)UA0TX, c);
}

/*
 *  ʸν񤭹ߡǽˤʤޤԤġ
 */
Inline void
hw_port_wait_putchar(int port_id, unsigned char c)
{
	while( !hw_port_putready(port_id) ) ;
	hw_port_putchar(port_id, c);
}

/*
 *  ؿ
 */
Inline void
hw_port_sendstart(int port_id)
{
}

Inline void
hw_port_sendstop(int port_id)
{
}

extern void	sio_ierdy_rcv(VP_INT exinf);
extern void	sio_ierdy_snd(VP_INT exinf);

Inline void
hw_port_handler_in(int port_id)
{
	UB tmp;

	if((sil_reb_mem((VP)UA0STR) & 0x07) == 0) {
		_serial_flag |= FLG_RECEIVED;
		sio_ierdy_rcv(siopcb_table[port_id].exinf);	
	} else {
		/* 顼Хǡ˴ */
		tmp = sil_reb_mem((VP)UA0RX);
	}
}

Inline void
hw_port_handler_out(int port_id)
{
	if(hw_port_putready(port_id)) {
		sio_ierdy_snd(siopcb_table[port_id].exinf);
	}
}

/***********************************************************************************/

/*
 *  sio_initialize -- ꥢݡȥɥ饤Фν
 */
Inline void
sio_initialize (void)
{
	int ix;

	/* SIO ֥åν */
	for (ix = TNUM_PORT; ix -- > 0; ) {
		siopcb_table[ix].openflag = FALSE;
	}
}

/*
 *  sio_opn_por -- ݡȤΥץ
 */
Inline SIOPCB *
sio_opn_por(ID sioid, VP_INT exinf)
{
	SIOPCB	*pcb;

	pcb = get_siopcb(sioid);
	pcb->inib     = NULL;
	pcb->exinf    = exinf;
	pcb->openflag = TRUE;
	pcb->port_id  = sioid-1;
	hw_port_initialize(pcb->port_id);
	return pcb;
}

/*
 *  sio_snd_chr -- ʸ
 */
Inline BOOL
sio_snd_chr(SIOPCB *pcb, INT chr)
{
#if 0
	if (hw_port_putready(pcb->port_id)) {
		hw_port_putchar(pcb->port_id, (UB)chr);
		return TRUE;
	} else {
		return FALSE;
	}
#else
	/* ϡΤ褦ˤ٤ */
	/* syslogϤߤޤäƤޤᡢ */
	/*  */
	while(!hw_port_putready(pcb->port_id)) ;
	hw_port_putchar(pcb->port_id, (UB)chr);
	return TRUE;
#endif
}

/*
 *  sio_rcv_chr -- ʸ
 */
Inline INT
sio_rcv_chr(SIOPCB *pcb)
{
	if (hw_port_getready(pcb->port_id))
		return hw_port_getchar(pcb->port_id);
	else
		return -1;
}

/*
 *  sio_ena_cbr -- ꥢ I/O ΥХåε
 */
Inline void
sio_ena_cbr(SIOPCB *pcb, UINT cbrtn)
{
}

/*
 *  sio_dis_cbr -- ꥢ I/O ΥХåζػ
 */
Inline void
sio_dis_cbr(SIOPCB *pcb, UINT cbrtn)
{
}

/*
 *  sio_cls_por -- ݡȤΥ
 */
Inline void
sio_cls_por(SIOPCB *pcb)
{
	sio_dis_cbr(pcb, SIO_ERDY_SND);
	sio_dis_cbr(pcb, SIO_ERDY_RCV);
	pcb->openflag = FALSE;
}

Inline void
sio_in_handler(void)
{
	hw_port_handler_in(0);
}

Inline void
sio_out_handler(void)
{
	hw_port_handler_out(0);
}


#endif /* _HW_SERIAL_H_ */
