/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 */

#ifndef	_CQ_D70F3716GC_H_
#define	_CQ_D70F3716GC_H_
/*
 *	ץå˰¸V850ES/JG2ѡ
 */

/*
 * ¢RAM
 */
#define	IRAM_TOP	0x03FF9000		/* ¢RAMƬɥ쥹 */
#define IRAM_SIZE	0x6000			/* ¢RAM礭 24Kbyte */
/*
 * ¢FlashROM
 */
#define	IROM_TOP	0x0000000		/* ¢FlashROMƬɥ쥹 */
#define IROM_SIZE	0x40000			/* ¢FlashROM礭 256Kbyte */


/* 
 * V850ES/JG2IO쥸
 */
#define PRCMD		(0xFFFFF1FC)	/* Command Register */
#define VSWC		(0xFFFFF06E)	/* System Wait Control Register */
#define OCDM		(0xFFFFF9FC)	/* OnChip Debug Mode Register */
#define WDTM2		(0xFFFFF6D0)	/* Watchdog Debug Mode Register2 */

/*
 * åϢ
 */
#define PCC			(0xFFFFF828)	/* Processor Clock Control Register */
#define PLLCTL		(0xFFFFF82C)	/* PLL ȥ롦쥸 */

/*
 * LEDϢ
 */
/* ݡCT */
#define PCT			(0xFFFFF00A)	/* PCT Register vector */
#define PMCT		(0xFFFFF02A)	/* PCT Mode Register vector */
#define PMCCT		(0xFFFFF04A)	/* PCT Mode Control Register vector */

#define LED_BIT		(0x40)			/* LED */

/*
 * 16bit Interval Timer M
 */
#define TM0CTL0		(0xFFFFF690)
#define TM0CMP0		(0xFFFFF694)

/*
 * UART0Ϣ
 */
/* ݡ */
#define PMC3		(0xFFFFF446)
#define PFC3		(0xFFFFF466)
#define PFCE3L		(0xFFFFF706)

/* UART0 */
#define UA0CTL0		(0xFFFFFA00)	/* UARTA0 쥸0 */
#define UA0OPT0		(0xFFFFFA03)	/* UARTA0 ץ쥸0 */
#define UA0STR		(0xFFFFFA04)	/* UARTA0 ֥쥸 */
#define UA0RX		(0xFFFFFA06)	/* UARTA0 ǡ쥸 */
#define UA0TX		(0xFFFFFA07)	/* UARTA0 ǡ쥸 */

/* ܡ졼 */
#define UA0CTL1		(0xFFFFFA01)	/* UARTA0 쥸1 */
#define UA0CTL2		(0xFFFFFA02)	/* UARTA0 쥸2 */

/*
 * IntC
 */
#define TM0EQIC0	(0xFFFFF150)	/* TM0EQ0 쥸 */
#define UA0RIC		(0xFFFFF162)	/* UART0 λ쥸 */
#define UA0TIC		(0xFFFFF164)	/* UART0 ĳ쥸 */
#define IMR2		(0xFFFFF104)	/* ߥޥ쥸2 */
#define IMR2H		(0xFFFFF105)	/* ߥޥ쥸2H */
#define IMR2L		(0xFFFFF104)	/* ߥޥ쥸2L */
#define ISPR		(0xFFFFF1FA)	/* 󥵡ӥץ饤ƥ쥸 */

#endif	/* _CQ_D70F3716GC_H_ */
