/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2004 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2001-2004 by Dep. of Computer Science and Engineering
 *                   Tomakomai National College of Technology, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 *
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: tinet_cpu_config.h,v 1.2 2007/01/05 02:10:17 honda Exp $
 */

#ifndef _TINET_CPU_CONFIG_H_
#define _TINET_CPU_CONFIG_H_

/*
 *  TCP/IP ˴ؤ
 */

/* TCP ˴ؤ */

/*
 *  MAX_TCP_RCV_SEG: ȥκ
 *
 *    : ѹ٤ǤϤʤ
 */

#define MAX_TCP_RCV_SEG		(IF_MTU - (IP_HDR_SIZE + TCP_HDR_SIZE))

/*
 *  MAX_TCP_SND_SEG: ȥκ
 *
 *    ꤫ MSS ץǥȥꤵƤ⡢
 *    ͤǡȥ¤Ǥ롣
 */

#ifdef SUPPORT_PPP

#define MAX_TCP_SND_SEG		(256 - ((IF_IP_TCP_HDR_SIZE + 3) >> 2 << 2))
/*#define MAX_TCP_SND_SEG		(IF_MTU - (IP_HDR_SIZE + TCP_HDR_SIZE))*/
/*#define MAX_TCP_SND_SEG		TCP_MSS*/

#endif	/* of #ifdef SUPPORT_PPP */

#ifdef SUPPORT_ETHER

/*#define MAX_TCP_SND_SEG		(1024 - ((IF_IP_TCP_HDR_SIZE + 3) >> 2 << 2))*/
#define MAX_TCP_SND_SEG		(IF_MTU - (IP_HDR_SIZE + TCP_HDR_SIZE))
/*#define MAX_TCP_SND_SEG		TCP_MSS*/

#endif	/* of #ifdef SUPPORT_ETHER */

#ifdef SUPPORT_LOOP

#define MAX_TCP_SND_SEG		(IF_MTU - (IP_HDR_SIZE + TCP_HDR_SIZE))

#endif	/* of #ifdef SUPPORT_LOOP */

/*
 *  DEF_TCP_SND_SEG: ȥε
 *  DEF_TCP_RCV_SEG: ȥε
 */

#ifdef SUPPORT_PPP

#define DEF_TCP_SND_SEG		MAX_TCP_SND_SEG

#define DEF_TCP_RCV_SEG		(256 - ((IF_IP_TCP_HDR_SIZE + 3) >> 2 << 2))
/*#define DEF_TCP_RCV_SEG		MAX_TCP_RCV_SEG*/

#endif	/* of #ifdef SUPPORT_PPP */

#ifdef SUPPORT_ETHER

#define DEF_TCP_SND_SEG		MAX_TCP_SND_SEG

/*#define DEF_TCP_RCV_SEG		(1024 - ((IF_IP_TCP_HDR_SIZE + 3) >> 2 << 2))*/
#define DEF_TCP_RCV_SEG		(IF_MTU - (IP_HDR_SIZE + TCP_HDR_SIZE))
/*#define DEF_TCP_RCV_SEG		TCP_MSS*/

#endif	/* of #ifdef SUPPORT_ETHER */

#ifdef SUPPORT_LOOP

#define DEF_TCP_SND_SEG		MAX_TCP_SND_SEG
#define DEF_TCP_RCV_SEG		(IF_MTU - (IP_HDR_SIZE + TCP_HDR_SIZE))

#endif	/* of #ifdef SUPPORT_LOOP */

/* 
 *  Ȥν֤ؤȤ˿˥ͥåȥХåեƤơ
 *  ǡ򥳥ԡ륵Τ
 */
#define MAX_TCP_REALLOC_SIZE	1024	

#define TMO_TCP_GET_NET_BUF	1000	/* [ms]net_buf ॢ		*/
#define TMO_TCP_OUTPUT		1000	/* [ms]TCP ϥॢ			*/

#define TCP_CFG_OPT_MSS		/* ͥ߻ˡȥץĤ롣*/
#define TCP_CFG_DELAY_ACK	/* ACK ٤餻ȤϥȤ򳰤			*/
#define TCP_CFG_ALWAYS_KEEP	/* ˥ץ饤֤ϥȤ򳰤		*/

/*
 *  ϥ
 */

#define	TCP_OUT_TASK_STACK_SIZE	1024	/* TCP ϥΥå		*/
#define TCP_OUT_TASK_PRIORITY	5	/* TCP ϥͥ			*/

/* UDP ˴ؤ */

					/* UDP 塼				*/
#define NUM_DTQ_UDP_RCVQ	(NUM_MPF_NET_BUF_IF_PDU-1)	/* 󥳡Хå	*/
#define NUM_DTQ_UDP_CB_RCVQ	(NUM_DTQ_UDP_RCVQ+1)		/* Хå	*/

#define TMO_UDP_OUTPUT	10000		/* [ms]UDP ϥॢ			*/

#define UDP_CFG_IN_CHECKSUM	/* UDP ϥåԤϥȤ򳰤	*/
#define UDP_CFG_OUT_CHECKSUM	/* UDP νϥåԤϥȤ򳰤	*/

/*
 *  Υ֥å󥰥ԤȤ߹ॿȥǡ塼
 */

#define NUM_DTQ_UDP_OUTPUT	1	/* UDP ϥǡ塼			*/
#define	UDP_OUT_TASK_STACK_SIZE	1024	/* UDP ϥΥå			*/
#define UDP_OUT_TASK_PRIORITY	5	/* UDP ϥͥ				*/

/* ICMPv4/v6 ˴ؤ */

#define ICMP_REPLY_ERROR		/* ICMP 顼åϥȤ򳰤*/

#define TMO_ICMP_OUTPUT		1000	/* [ms]ICMP ϥХåեॢ	*/

/* IPv4/IPv6  */

#define TMO_IN_REDIRECT	(10*60*1000)	/* [ms]ľ롼ƥ󥰥ȥ꥿ॢ	*/

/* IPv4 ˴ؤ */

/*#define IP4_CFG_FRAGMENT		 ǡʬ䡦ƹԤϥȤ򳰤*/
#define NUM_IP4_FRAG_QUEUE	2	/* ǡƹ塼			*/
#define TMO_IP4_FRAG_GET_NET_BUF	1000	/* [ms]net_buf ॢ		*/

/* IPv6 ˴ؤ */

#ifdef SUPPORT_ETHER

#define IP6_CFG_AUTO_LINKLOCAL		/* 󥯥륢ɥ쥹μưԤϥȤ򳰤*/

#endif	/* of #ifdef SUPPORT_ETHER */

#define NUM_IP6_DAD_COUNT	1	/* ʣɥ쥹Фβ		*/
					/*  0 ꤹȡʣɥ쥹ФԤʤ	*/
#define NUM_ND6_CACHE_ENTRY	10	/* ٥åΥȥ			*/

#ifdef SUPPORT_ETHER

/*
 *  ǥեȥ롼ꥹȤΥȥ
 *  0 ꤹȥ롼Τʤ
 */
#define NUM_ND6_DEF_RTR_ENTRY	2

/*
 *  ưΥ롼ϲ
 *  0 ꤹȥ롼Ϥʤ
 */
#define NUM_ND6_RTR_SOL_RETRY	3	

#endif	/* of #ifdef SUPPORT_ETHER */

#define TMO_ND6_NS_OUTPUT	1000	/* [ms]ϥॢ		*/
#define TMO_ND6_NA_OUTPUT	1000	/* [ms]νϥॢ		*/
#define TMO_ND6_RS_OUTPUT	1000	/* [ms]롼ϥॢ		*/
#define TMO_ND6_RTR_SOL_DELAY	1000	/* [ms]롼ٱ			*/
#define TMO_ND6_RTR_SOL_INTERVAL	\
				3000	/* [ms]롼ϴֳ			*/

/*
 *  ǡ (ͥåȥ󥿥ե) ˴ؤ
 */

/*
 *  PPP ˴ؤ
 */

#define NUM_DTQ_PPP_OUTPUT	2	/* PPP ϥǡ塼2 ʾ	*/

#define	PPP_INPUT_STACK_SIZE	1024	/* PPP Υå		*/
#define	PPP_OUTPUT_STACK_SIZE	1024	/* PPP ϥΥå		*/

#define PPP_INPUT_PRIORITY	5	/* PPP ͥ			*/
#define PPP_OUTPUT_PRIORITY	5	/* PPP ͥ			*/

#define TMO_PPP_GET_NET_BUF	1000	/* [ms] net_buf ॢ	*/

/*
 *  PPPǥ˴ؤ
 */

#define MODEM_CFG_DIAL		"ATD"	/* 륳ޥʸ			*/
#define MODEM_CFG_RETRY_CNT	3	/* ȥ饤			*/
#define MODEM_CFG_RETRY_WAIT	10000	/* ȥ饤ޤǤԤ [ms]	*/

/*
 *  PPPHDLC ˴ؤ
 */

#define DEF_LOCAL_ACCM		0x000a0000	/* ʬ ACCMXON  XOFF ΤѴ	*/
#define DEF_REMOTE_ACCM		0xffffffff	/*  ACCMͤѴ		*/

/*
 *  PPPLCP ˴ؤ
 */

#define LCP_CFG_MRU		0x0001	/* MRU					*/
#define LCP_CFG_ACCM		0x0002	/* ACCM					*/
#define LCP_CFG_MAGIC		0x0004	/* ޥåֹ				*/
#define LCP_CFG_PCOMP		0x0008	/* ץȥ̵ǽ			*/
#define LCP_CFG_ACCOMP		0x0010	/* ɥ쥹			*/
#define LCP_CFG_PAP		0x0020	/* PAP					*/
/*#define LCP_CFG_CHAP		0x0040	   CHAP ϼͽ			*/

#ifdef LCP_CFG_MAGIC

#define LCP_ECHO_INTERVAL	(20*NET_TIMER_HZ)	/* 󥿡Х		*/
#define LCP_ECHO_FAILS		9			/* 			*/

#endif	/* of #ifdef LCP_CFG_MAGIC */

/*
 *  PPPPAP ˴ؤ
 */

#define DEF_PAP_TIMEOUT		(3*NET_TIMER_HZ)
#define DEF_PAP_REQTIME		(30*NET_TIMER_HZ)	/* ॢȽԤȤϥȤ򳰤*/
#define MAX_PAP_REXMT		10			/* ǧ׵κ	*/

/*
 *  ARP ˴ؤ
 */

#define NUM_ARP_ENTRY		10			/* ARP å奨ȥ	*/
#define ARP_CACHE_KEEP		(20*60*NET_TIMER_HZ)	/* ARP åΥॢ	*/
#define TMO_ARP_GET_NET_BUF	1000	/* [ms]ɥ쥹׵ net_buf ॢ*/
#define TMO_ARP_OUTPUT		1000	/* [ms]ɥ쥹׵ϥॢ	*/

/*
 *  DHCP ˴ؤ
 *
 *    : TINET ϡDHCP Ƥʤѥץǡ
 *            DHCP å뤿Ǥ롣
 *            ޤߤ IPv4 ΤͭǤ롣
 */

/*#define DHCP_CFG					 DHCP ϥȤ򳰤*/

/*
 *  Ethernet ˴ؤ
 */

#define NUM_DTQ_ETHER_OUTPUT	2	/* Ethernet ϥǡ塼	*/

#define	ETHER_INPUT_STACK_SIZE	1024	/* Ethernet ϥΥå	*/
#define	ETHER_OUTPUT_STACK_SIZE	1024	/* Ethernet ϥΥå	*/

#define ETHER_INPUT_PRIORITY	5	/* Ethernet ϥͥ		*/
#define ETHER_OUTPUT_PRIORITY	5	/* Ethernet ϥͥ		*/

/*#define ETHER_CFG_ACCEPT_ALL		 ޥ㥹ȡ顼ե졼ȤϥȤ򳰤	*/
/*#define ETHER_CFG_UNEXP_WARNING	 󥵥ݡȥե졼ηٹɽȤϥȤ򳰤		*/
/*#define ETHER_CFG_802_WARNING		 IEEE 802.3 ե졼ηٹɽȤϥȤ򳰤		*/
/*#define ETHER_CFG_MCAST_WARNING	 ޥ㥹ȤηٹɽȤϥȤ򳰤		*/

/*
 *  롼ץХå󥿥ե˴ؤ
 */

#define LOMTU			1500	/* 롼ץХå MTU			*/

#define NUM_DTQ_LOOP_INPUT	0	/* 롼ץХåϥǡ塼	*/
#define NUM_DTQ_LOOP_OUTPUT	0	/* 롼ץХåϥǡ塼	*/

#define	LOOP_INPUT_STACK_SIZE	1024	/* 롼ץХåϥΥå	*/
#define	LOOP_OUTPUT_STACK_SIZE	1024	/* 롼ץХåϥΥå	*/

#define LOOP_INPUT_PRIORITY	5	/* 롼ץХåϥͥ		*/
#define LOOP_OUTPUT_PRIORITY	5	/* 롼ץХåϥͥ		*/

/*
 *  ͥåȥ˴ؤ
 */

/* ͥåȥޥ */

#define	NET_TIMER_STACK_SIZE	1024	/* ͥåȥޥΥå */
#define NET_TIMER_PRIORITY	5	/* ͥåȥޥͥ */

#define NUM_NET_CALLOUT		10	/* ॢȸƽФ10 ʾ	*/

/* net_buf  */

#ifdef SUPPORT_PPP

/*
 *  PPP ǤϡѤ net_buf  PDU (1502) 
 *  ƤʤФʤʤΤ PDU ¿˳ݤ롣
 *  128  net_buf ϡTCP Ѥ¿˳ݤ롣
 */

#define NUM_MPF_NET_BUF_128	2	/* net_buf 1282 ʾ	*/
#define NUM_MPF_NET_BUF_256	4	/* net_buf 256		*/
#define NUM_MPF_NET_BUF_512	1	/* net_buf 512		*/
#define NUM_MPF_NET_BUF_1024	1	/* net_buf 1024		*/
#define NUM_MPF_NET_BUF_IF_PDU	1	/* net_buf PDU		*/

#if defined(SUPPORT_INET4) && defined(IP4_CFG_FRAGMENT)

#ifndef NUM_MPF_NET_BUF_4096
#define NUM_MPF_NET_BUF_4096	2	/* net_buf 4096		*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_4096 */

#endif	/* of #if defined(SUPPORT_INET4) && defined(IP4_CFG_FRAGMENT) */

#endif	/* of #ifdef SUPPORT_PPP */

#ifdef SUPPORT_ETHER

/*
 *  ͥåȤǤϡѤ net_buf ϡNIC ΥХåեˤ
 *  ե졼Ĺ򸫤ƳƤФ褤
 *  TCP κ祻ȥ 1024 ƥåȤ net_buf Ĵϡ
 *  Υ net_buf ¿˳ݤ롣
 *  128  net_buf ⡢TCP 楻Ѥ¿˳ݤ롣
 */

#ifndef NUM_MPF_NET_BUF_128
#define NUM_MPF_NET_BUF_128	4	/* net_buf 1282 ʾ	*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_128 */

#ifndef NUM_MPF_NET_BUF_256
#define NUM_MPF_NET_BUF_256	2	/* net_buf 256		*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_256 */

#ifndef NUM_MPF_NET_BUF_512
#define NUM_MPF_NET_BUF_512	2	/* net_buf 512		*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_512 */

#ifndef NUM_MPF_NET_BUF_1024
#define NUM_MPF_NET_BUF_1024	2	/* net_buf 1024		*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_1024 */

#ifndef NUM_MPF_NET_BUF_IF_PDU
#define NUM_MPF_NET_BUF_IF_PDU	4	/* net_buf PDU		*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_IF_PDU */

#if defined(SUPPORT_INET4) && defined(IP4_CFG_FRAGMENT)

#ifndef NUM_MPF_NET_BUF_4096
#define NUM_MPF_NET_BUF_4096	2	/* net_buf 4096		*/
#endif	/* of #ifndef NUM_MPF_NET_BUF_4096 */

#endif	/* of #if defined(SUPPORT_INET4) && defined(IP4_CFG_FRAGMENT) */

#endif	/* of #ifdef SUPPORT_ETHER */

#ifdef SUPPORT_LOOP

#define NUM_MPF_NET_BUF_128	2	/* net_buf 1282 ʾ	*/
#define NUM_MPF_NET_BUF_256	2	/* net_buf 256		*/
#define NUM_MPF_NET_BUF_512	2	/* net_buf 512		*/
#define NUM_MPF_NET_BUF_1024	2	/* net_buf 1024		*/
#define NUM_MPF_NET_BUF_IF_PDU	2	/* net_buf PDU		*/

#endif	/* of #ifdef SUPPORT_PPP */

/*
 *  ͥåȥ׾η¬
 *
 *  ͥåȥ׾η¬Ԥϡtinet/include/net/net.h
 *  Ƥץȥ뼱̥ե饰ꤹ롣
 */

#if 1

#ifdef SUPPORT_INET4

#define NET_COUNT_ENABLE	(0			\
				| PROTO_FLG_PPP_HDLC	\
				| PROTO_FLG_PPP_PAP	\
				| PROTO_FLG_PPP_LCP	\
				| PROTO_FLG_PPP_IPCP	\
				| PROTO_FLG_PPP		\
				| PROTO_FLG_LOOP	\
				| PROTO_FLG_ETHER_NIC	\
				| PROTO_FLG_ETHER	\
				| PROTO_FLG_ARP		\
				| PROTO_FLG_IP4		\
				| PROTO_FLG_ICMP4	\
				| PROTO_FLG_UDP		\
				| PROTO_FLG_TCP		\
				| PROTO_FLG_NET_BUF	\
				)

#endif	/* of #ifdef SUPPORT_INET4 */

#ifdef SUPPORT_INET6

#define NET_COUNT_ENABLE	(0			\
				| PROTO_FLG_PPP_HDLC	\
				| PROTO_FLG_PPP_PAP	\
				| PROTO_FLG_PPP_LCP	\
				| PROTO_FLG_PPP_IPCP	\
				| PROTO_FLG_PPP		\
				| PROTO_FLG_LOOP	\
				| PROTO_FLG_ETHER_NIC	\
				| PROTO_FLG_ETHER	\
				| PROTO_FLG_IP6		\
				| PROTO_FLG_ICMP6	\
				| PROTO_FLG_ND6		\
				| PROTO_FLG_UDP		\
				| PROTO_FLG_TCP		\
				| PROTO_FLG_NET_BUF	\
				)

#endif	/* of #ifdef SUPPORT_INET6 */

#else	/* of #if 0 */

#define NET_COUNT_ENABLE	(0			\
				)

#endif	/* of #if 0 */

#endif /* _TINET_CPU_CONFIG_H_ */
