/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2002 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *  Copyright (C) 2005 by Freelines CO.,Ltd 
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_config.h,v 1.4 2007/01/05 02:10:17 honda Exp $
 */

/*
 *	åȥƥ¸⥸塼TK-850/KJ1+ SRAMܡդ
 */

#ifndef _SYS_CONFIG_H_
#define _SYS_CONFIG_H_

/*
 *  ͥ̾Υ͡
 */

#include <sys_rename.h>

/*
 *  åȥƥΥϡɥ񸻤
 */
#include "v850es_kj1.h"

/*
 *  ưåΥåȥƥ̾
 */
#define	TARGET_NAME	"TK-850/KJ1+"

/*
 *  vxget_tim 򥵥ݡȤ뤫ɤ
 */
/* #define	SUPPORT_VXGET_TIM */

/*
 *  JSPͥưΥޥåפȴϢ
 */
#define	STACKTOP	(IRAM_TOP+IRAM_SIZE)	/* 󥿥ƥѤΥåν */

/* CPUưåȿ20MHz(5MHz4) */
#define	CPU_CLOCK		20000000

/* װο */
#define NUM_INTERRUPT	0x3B

/*
 *  ݡȤ륷ꥢǥХοϺ 2
 */
#define	CONSOLE_PORTID	1	/* 󥽡ѤѤ륷ꥢݡֹKJ1+Ǥ1or23ϳߥ٥ϤǤΤԲġ */
#define TNUM_PORT		1
#define SEPARATE_SIO_INT	/* ߤλߤ̤줿ߤˤʤäƤ뤫 */
#define	LOGTASK_PORTID		CONSOLE_PORTID	/* ƥϤ륷ꥢݡֹ	*/

#ifndef _MACRO_ONLY

/*
 *  åȥƥ¸ν
 */
extern void	sys_initialize(void);

/*
 *  åȥƥνλ
 *
 *  ƥλ˻ȤROM˥ƽФǼ¸뤳Ȥꤷ
 *  Ƥ롥
 */
extern void	sys_exit(void);

/*
 *  åȥƥʸ
 *
 *  ƥ٥ʸϥ롼ROM˥ƽФǼ¸뤳
 *  ȤꤷƤ롥
 */
Inline void
sys_putc(char c)
{
	extern void cpu_putc(char c);
	/* ROM˥ʤɤΥ󥽡إåϤ٥ؿꤷƤ뤬
	   ݤʤΤǥƥΥꥢݡȤؽϤ */
	cpu_putc(c);
}

#endif /* _MACRO_ONLY */
#endif /* _SYS_CONFIG_H_ */
