/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: cpu_defs.h,v 1.11 2003/12/15 07:19:22 takayuki Exp $
 */


/*
 *	ץå˰¸Windowsѡ
 */

#ifndef _CPU_DEFS_H_
#define _CPU_DEFS_H_

#define OMIT_SIL_ACCESS

#define WINDOWS

#define INT_NUMINTERRUPTS	7	/* ܿ */

#ifndef _MACRO_ONLY

#include <itron.h>
#include <vwindows.h>

typedef	UINT		INHNO;		/* ߥϥɥֹ */
typedef	UINT		EXCNO;		/* CPU㳰ϥɥֹ */

/*
 * ߥߥ졼Ϣ
 */

#define INT_STAT_MASK		0x0000ffffu
#define INT_STAT_PENDING	0x00000001u
#define INT_STAT_RUNNING	0x00000002u
#define INT_STAT_ENABLED	0x00000004u

#define INT_MOD_MASK		0xff000000u
#define INT_MOD_LOGMASK		0x01000000u

struct tagInterruptLevel
{
	HANDLE			ThreadHandle;
	DWORD			ThreadID;
	void *			Routine;
	unsigned int	Flags;
};

extern struct tagInterruptLevel InterruptLevel[INT_NUMINTERRUPTS];
extern unsigned int             CurrentInterruptLevel;

/*  㳰Ϣ */

#define EXC_MAXITEMS 32

struct tagExceptionLevel
{
	DWORD ExceptionCode;
	void * Routine;
};

extern struct tagExceptionLevel ExceptionLevel[EXC_MAXITEMS];

/*
 * ߥߥ졼ؿ
 */

extern BOOL			def_int( unsigned int ims, void * rtn);	/* ϥɥ */
extern BOOL			ini_int( void );				/*  */
extern void			fin_int( void );
extern BOOL			ras_int(unsigned int ims);		/* ׵ */
extern unsigned int sns_int( void );				/* Sense the highest pending request */
extern HANDLE		sch_int( void );				/* ߤΥ塼 */

extern BOOL			set_intlogmask( unsigned int ims, BOOL mask );

 /* Ĥȶػߤϰ˴طʤ&ػߤȤʤ */
extern ER	ena_int(unsigned int ims);			/*  */
extern ER	dis_int(unsigned int ims);			/* ػ */

extern ER	chg_ims(unsigned int ims);			/* ߥ٥ */
extern ER	get_ims(unsigned int *p_ims);		/* ߥ٥μ */
extern ER	vget_ims(unsigned int *p_ims);		/* ߥ٥μ */

extern BOOL def_exc(DWORD exc, void * routine);
extern BOOL ini_exc(void);
extern void fin_exc(void);

	/*
	 * ƥ९ƥ륻
	 *   ¾CPUåǡäƤ֥ǥѥåȯʤ
	 */
extern void enter_system_critical_section(BOOL *);
extern void leave_system_critiacl_section(BOOL *);

	/* ꤵ줿򥷥ƥ९ƥ륻󳰤ߤ */
extern ER   wait_for_thread_suspension_completion(HANDLE thread);

    /* ߥ졼󥿥 */
extern unsigned int current_timer_clock_unit;

    /* ߥ졼Υƥå
     *   clk : Υ޳˲ä륷ߥ졼
     *     (clk = 0 :  (TIMER_CLOCK_WINDOWS))
     */
extern ER set_clk(unsigned int clk);

#endif /* _MACRO_ONLY */

/*
 * ޡϢ
 */

#include <hw_timer.h>

/*
 *  ƥå
 */
#define	TIC_NUME	current_timer_clock_unit	/* ƥåμʬ */
#define	TIC_DENO	1						    /* ƥåμʬ */

#ifndef _MACRO_ONLY

/*
 * ĥޡ (Pentium Timer)
 */

typedef UD SYSUTIM;

Inline ER
vxget_tim(SYSUTIM * pk_sysutim)
{
	QueryPerformanceCounter((LARGE_INTEGER *)pk_sysutim);
	return E_OK;
}

#endif /* _MACRO_ONLY */

#endif /* _CPU_DEFS_H_ */
