/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 * 
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 * 
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 * 
 *  @(#) $Id: sys_manage.c,v 1.8 2003/07/01 13:30:35 hiro Exp $
 */

/*
 *	ƥִǽ
 */

#include "jsp_kernel.h"
#include "check.h"
#include "task.h"

/*
 *  ̤ͥβž
 */
#ifdef __rot_rdq

SYSCALL ER
rot_rdq(PRI tskpri)
{
	UINT	pri;
	ER	ercd;

	LOG_ROT_RDQ_ENTER(tskpri);
	CHECK_TSKCTX_UNL();
	CHECK_TPRI_SELF(tskpri);

	t_lock_cpu();
	pri = (tskpri == TPRI_SELF) ? runtsk->priority : INT_PRIORITY(tskpri);
	if (rotate_ready_queue(pri)) {
		dispatch();
	}
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_ROT_RDQ_LEAVE(ercd);
	return(ercd);
}

#endif /* __rot_rdq */

/*
 *  ̤ͥβž󥿥ƥѡ
 */
#ifdef __irot_rdq

SYSCALL ER
irot_rdq(PRI tskpri)
{
	ER	ercd;

	LOG_IROT_RDQ_ENTER(tskpri);
	CHECK_INTCTX_UNL();
	CHECK_TPRI(tskpri);

	i_lock_cpu();
	if (rotate_ready_queue(INT_PRIORITY(tskpri))) {
		reqflg = TRUE;
	}
	ercd = E_OK;
	i_unlock_cpu();

    exit:
	LOG_IROT_RDQ_LEAVE(ercd);
	return(ercd);
}

#endif /* __irot_rdq */

/*
 *  ¹Ծ֤ΥIDλ
 */
#ifdef __get_tid

SYSCALL ER
get_tid(ID *p_tskid)
{
	ER	ercd;

	LOG_GET_TID_ENTER(p_tskid);
	CHECK_TSKCTX_UNL();

	t_lock_cpu();
	*p_tskid = TSKID(runtsk);
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_GET_TID_LEAVE(ercd, *p_tskid);
	return(ercd);
}

#endif /* __get_tid */

/*
 *  ¹Ծ֤ΥIDλȡ󥿥ƥѡ
 */
#ifdef __iget_tid

SYSCALL ER
iget_tid(ID *p_tskid)
{
	ER	ercd;

	LOG_IGET_TID_ENTER(p_tskid);
	CHECK_INTCTX_UNL();

	i_lock_cpu();
	*p_tskid = (runtsk == NULL) ? TSK_NONE : TSKID(runtsk);
	ercd = E_OK;
	i_unlock_cpu();

    exit:
	LOG_IGET_TID_LEAVE(ercd, *p_tskid);
	return(ercd);
}

#endif /* __iget_tid */

/*
 *  CPUå֤ؤΰܹ
 */
#ifdef __loc_cpu

SYSCALL ER
loc_cpu(void)
{
	ER	ercd;

	LOG_LOC_CPU_ENTER();
	CHECK_TSKCTX();

	if (!(t_sense_lock())) {
		t_lock_cpu();
	}
	ercd = E_OK;

    exit:
	LOG_LOC_CPU_LEAVE(ercd);
	return(ercd);
}

#endif /* __loc_cpu */

/*
 *  CPUå֤ؤΰܹԡ󥿥ƥѡ
 */
#ifdef __iloc_cpu

SYSCALL ER
iloc_cpu(void)
{
	ER	ercd;

	LOG_ILOC_CPU_ENTER();
	CHECK_INTCTX();

	if (!(i_sense_lock())) {
		i_lock_cpu();
	}
	ercd = E_OK;

    exit:
	LOG_ILOC_CPU_LEAVE(ercd);
	return(ercd);
}

#endif /* __iloc_cpu */

/*
 *  CPUå֤β
 *
 *  CPUåϡǥѥåɬפȤʤ륵ӥƤӽФ
 *  ȤϤǤʤᡤCPUå֤β˥ǥѥåư
 *  ɬפϤʤ
 */
#ifdef __unl_cpu

SYSCALL ER
unl_cpu(void)
{
	ER	ercd;

	LOG_UNL_CPU_ENTER();
	CHECK_TSKCTX();

	if (t_sense_lock()) {
		t_unlock_cpu();
	}
	ercd = E_OK;

    exit:
	LOG_UNL_CPU_LEAVE(ercd);
	return(ercd);
}

#endif /* __unl_cpu */

/*
 *  CPUå֤β󥿥ƥѡ
 *
 *  CPUåϡǥѥåɬפȤʤ륵ӥƤӽФ
 *  ȤϤǤʤᡤCPUå֤β˥ǥѥåεư
 *  ᤹ɬפϤʤ
 */
#ifdef __iunl_cpu

SYSCALL ER
iunl_cpu(void)
{
	ER	ercd;

	LOG_IUNL_CPU_ENTER();
	CHECK_INTCTX();

	if (i_sense_lock()) {
		i_unlock_cpu();
	}
	ercd = E_OK;

    exit:
	LOG_IUNL_CPU_LEAVE(ercd);
	return(ercd);
}

#endif /* __iunl_cpu */

/*
 *  ǥѥåζػ
 */
#ifdef __dis_dsp

SYSCALL ER
dis_dsp(void)
{
	ER	ercd;

	LOG_DIS_DSP_ENTER();
	CHECK_TSKCTX_UNL();

	t_lock_cpu();
	enadsp = FALSE;
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_DIS_DSP_LEAVE(ercd);
	return(ercd);
}

#endif /* __dis_dsp */

/*
 *  ǥѥåε
 */
#ifdef __ena_dsp

SYSCALL ER
ena_dsp(void)
{
	ER	ercd;

	LOG_ENA_DSP_ENTER();
	CHECK_TSKCTX_UNL();

	t_lock_cpu();
	enadsp = TRUE;
	if (runtsk != schedtsk) {
		dispatch();
	}
	ercd = E_OK;
	t_unlock_cpu();

    exit:
	LOG_ENA_DSP_LEAVE(ercd);
	return(ercd);
}

#endif /* __ena_dsp */

/*
 *  ƥȤλ
 */
#ifdef __sns_ctx

SYSCALL BOOL
sns_ctx(void)
{
	BOOL	state;

	LOG_SNS_CTX_ENTER();
	state = sense_context() ? TRUE : FALSE;
	LOG_SNS_CTX_LEAVE(state);
	return(state);
}

#endif /* __sns_ctx */

/*
 *  CPUå֤λ
 */
#ifdef __sns_loc

SYSCALL BOOL
sns_loc(void)
{
	BOOL	state;

	LOG_SNS_LOC_ENTER();
	state = sense_lock() ? TRUE : FALSE;
	LOG_SNS_LOC_LEAVE(state);
	return(state);
}

#endif /* __sns_loc */

/*
 *  ǥѥåػ߾֤λ
 */
#ifdef __sns_dsp

SYSCALL BOOL
sns_dsp(void)
{
	BOOL	state;

	LOG_SNS_DSP_ENTER();
	state = !(enadsp) ? TRUE : FALSE;
	LOG_SNS_DSP_LEAVE(state);
	return(state);
}

#endif /* __sns_dsp */

/*
 *  ǥѥåα֤λ
 */
#ifdef __sns_dpn

SYSCALL BOOL
sns_dpn(void)
{
	BOOL	state;

	LOG_SNS_DPN_ENTER();
	state = (sense_context() || sense_lock() || !(enadsp)) ? TRUE : FALSE;
	LOG_SNS_DPN_LEAVE(state);
	return(state);
}

#endif /* __sns_dpn */

/*
 *  ͥư֤λ
 */
#ifdef __vsns_ini

SYSCALL BOOL
vsns_ini(void)
{
	BOOL	state;

	LOG_VSNS_INI_ENTER();
	state = !(iniflg) ? TRUE : FALSE;
	LOG_VSNS_INI_LEAVE(state);
	return(state);
}

#endif /* __vsns_ini */
