/*
 *  TOPPERS/JSP Kernel
 *      Toyohashi Open Platform for Embedded Real-Time Systems/
 *      Just Standard Profile Kernel
 *
 *  Copyright (C) 2000-2003 by Embedded and Real-Time Systems Laboratory
 *                              Toyohashi Univ. of Technology, JAPAN
 *
 *  嵭Ԥϡʲ (1)(4) ξ狼Free Software Foundation 
 *  ˤäƸɽƤ GNU General Public License  Version 2 ˵
 *  ҤƤ˸¤ꡤܥեȥܥեȥ
 *  ѤΤޤࡥʲƱˤѡʣѡۡʰʲ
 *  ѤȸƤ֡ˤ뤳Ȥ̵ǵ롥
 *  (1) ܥեȥ򥽡ɤηѤˤϡ嵭
 *      ɽѾ浪Ӳ̵ݾڵ꤬Τޤޤηǥ
 *      ˴ޤޤƤ뤳ȡ
 *  (2) ܥեȥ򡤥饤֥ʤɡ¾Υեȥȯ˻
 *      ѤǤǺۤˤϡۤȼɥȡ
 *      ԥޥ˥奢ʤɡˤˡ嵭ɽѾ浪Ӳ
 *      ̵ݾڵǺܤ뤳ȡ
 *  (3) ܥեȥ򡤵Ȥ߹ʤɡ¾Υեȥȯ˻
 *      ѤǤʤǺۤˤϡΤ줫ξ
 *      ȡ
 *    (a) ۤȼɥȡѼԥޥ˥奢ʤɡˤˡ嵭
 *        ɽѾ浪Ӳ̵ݾڵǺܤ뤳ȡ
 *    (b) ۤη֤̤ˡˤäơTOPPERSץȤ
 *        𤹤뤳ȡ
 *  (4) ܥեȥѤˤľŪޤϴŪ뤤ʤ»
 *      ⡤嵭ԤTOPPERSץȤդ뤳ȡ
 * 
 *  ܥեȥϡ̵ݾڤ󶡤ƤΤǤ롥嵭Ԥ
 *  TOPPERSץȤϡܥեȥ˴ؤơŬѲǽ
 *  ޤơʤݾڤԤʤޤܥեȥѤˤľ
 *  ŪޤϴŪʤ»˴ؤƤ⡤Ǥʤ
 *
 *  @(#) $Id: sample1.h,v 1.6 2003/12/20 09:13:29 takayuki Exp $
 */

/*
 *  ץץ(1)Υإåե
 */

#include "cpu_defs.h"
#include "sys_defs.h"

/*
 *  ƥͥ٤
 */

#define MAIN_PRIORITY	5		/* ᥤ󥿥ͥ */
					/* HIGH_PRIORITY ⤯뤳 */

#define HIGH_PRIORITY	9		/* ˼¹Ԥ륿ͥ */
#define MID_PRIORITY	10
#define LOW_PRIORITY	11

/*
 *  åȰ¸CPU㳰ϥɥεưˡʤɡ
 */

#ifdef M68K

#define CPUEXC1		5		/* 㳰 */
#define RAISE_CPU_EXCEPTION	syslog(LOG_NOTICE, "zerodiv = %d", 10 / 0)

#elif defined(SH3)

#define CPUEXC1		224		/* ɥ顼㳰 */
#define RAISE_CPU_EXCEPTION	(*((volatile int *) 0xFFFFFEC1))

#elif defined(SH1)

#define CPUEXC1		9		/* CPUɥ쥹顼㳰 */
#define RAISE_CPU_EXCEPTION	(*((volatile int *) 0xFFFFFEC1))
#ifdef TOKIWA_SH1
#define	STACK_SIZE	512		/* Υå */
#endif /* TOKIWA_SH1 */

#elif defined(ARM7TDMI)

#define CPUEXC1		4		/* ɥ顼㳰 */
#define RAISE_CPU_EXCEPTION	(*((volatile int *) 0xFFFFFEC1))

#elif defined(V850)

#elif defined(H8)

#undef CPUEXC1				/* CPU㳰ϥɥ򥵥ݡȤʤ */

#elif defined(H8S)

#undef CPUEXC1				/* CPU㳰ϥɥ򥵥ݡȤʤ */
#define LOOP_REF	4000L		/* ®ٷ¬ѤΥ롼ײ */

#elif defined(MICROBLAZE)

#undef CPUEXC1				/* CPU㳰ϥɥ򥵥ݡȤʤ */
#define STACK_SIZE	2048		/* Υå */

#elif defined(I386)

#define CPUEXC1		0		/* 㳰 */
#define RAISE_CPU_EXCEPTION   syslog(LOG_NOTICE, "zerodiv = %d", 10 / 0)
#define OMIT_VGET_TIM

#elif defined(TMS320C54X)

#undef CPUEXC1				/* CPU㳰ϥɥ򥵥ݡȤʤ */
#define STACK_SIZE	320		/* Υå */
#define LOOP_REF	500000L		/* ®ٷ¬ѤΥ롼ײ */

#elif defined(LINUX)

#undef CPUEXC1				/* CPU㳰ϥɥ򥵥ݡȤʤ */
#define OMIT_VGET_TIM
#define LOOP_REF	4000000		/* ®ٷ¬ѤΥ롼ײ */

#elif defined(WINDOWS)

#define LOOP_REF	5000000		/* ®ٷ¬ѤΥ롼ײ */

#endif

/*
 *  åȤ˰¸ǽΤ
 */

#ifndef TASK_PORTID
#define	TASK_PORTID	1		/* ʸϤ륷ꥢݡID */
#endif /* TASK_PORTID */

#ifndef STACK_SIZE
#define	STACK_SIZE	8192		/* Υå */
#endif /* STACK_SIZE */

#ifndef LOOP_REF
#define LOOP_REF	1000000		/* ®ٷ¬ѤΥ롼ײ */
#endif /* LOOP_REF */

/*
 *  ؿΥץȥ
 */
#ifndef _MACRO_ONLY

extern void	task(VP_INT tskno);
extern void	main_task(VP_INT exinf);
extern void	tex_routine(TEXPTN texptn, VP_INT tskno);
extern void	cyclic_handler(VP_INT exinf);
extern void	cpuexc_handler(VP p_excinf);

#endif /* _MACRO_ONLY */
